/*  Project firstapp
    
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    firstapp.exe Application
    FILE:         frstppap.cpp
    AUTHOR:       


	 OVERVIEW
    ========
    Source file for implementation of firstappApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\vbxctl.h>


#include "frstppap.h"
#include "frstppad.h"                        // Definition of about dialog.
#include "sqcmain.h"

//{{firstappApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(firstappApp, TApplication)
//{{firstappAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILENEW, CmFileNew),
	 EV_COMMAND(CM_FILEOPEN, CmFileOpen),
    EV_COMMAND(CM_FILECLOSE, CmFileClose),
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
    EV_COMMAND(CM_EXIT, CmExit),
//{{firstappAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
				TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
      {  }
    ~SDIDecFrame ()
      {  }
};


//////////////////////////////////////////////////////////
// firstappApp
// =====
//
firstappApp::firstappApp () : TApplication("FirstApp")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	 FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.

}


firstappApp::~firstappApp ()
{
	 // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// firstappApp
// =====
// Application intialization.
//
void firstappApp::InitMainWindow ()
{
    Client = new TEditFile(0, 0, 0);
	 SDIDecFrame *frame = new SDIDecFrame(0, GetName(), Client, FALSE);

    nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

	 //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);

    //
    // Associate with the accelerator table.
    //
	 frame->Attr.AccelTable = SDI_MENU;

  
    MainWindow = frame;

}


//////////////////////////////////////////////////////////
// firstappApp
// ===========
// Menu File New command
void firstappApp::CmFileNew ()
{
    Client->NewFile();
}


//////////////////////////////////////////////////////////
// firstappApp
// ===========
// Menu File Open command
void firstappApp::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
	 //
    *FileData.FileName = 0;
    if (Client->CanClose())
        if (TFileOpenDialog(MainWindow, FileData).Execute() == IDOK)
				OpenFile();
}


void firstappApp::OpenFile (const char *fileName)
{
    if (fileName)
        lstrcpy(FileData.FileName, fileName);

	 Client->ReplaceWith(FileData.FileName);
}


//////////////////////////////////////////////////////////
// firstappApp
// =====
// Menu File Close command
void firstappApp::CmFileClose ()
{
	 if (Client->CanClose())
	         Client->DeleteSubText(0, UINT(-1));
}


//////////////////////////////////////////////////////////
// firstappApp
// ===========
// Menu Help About firstapp.exe command
void firstappApp::CmHelpAbout ()
{
	 //
	 // Show the modal dialog.
	 //
	 firstappAboutDlg(MainWindow).Execute();
}


int OwlMain (int , char* [])
{
	 TBIVbxLibrary   vbxSupport;                 // This application has VBX controls.
	 firstappApp     App;
	 int             result;

	 SQcConnect(&App.AppHand, &App.Revision);
	 result = App.Run();
	 SQcDisconnect(App.AppHand);

	 return result;
}

void firstappApp::InitInstance ()
{
	 TApplication::InitInstance();
	 DocDlg = new TDocDlg(MainWindow, TResId(IDD_DOCTORS));
	 DocDlg->Create();
	 SQcGo(AppHand,0);
}


void firstappApp::CmExit ()
{
	 delete DocDlg;
	 DocDlg = NULL;
}

