//----------------------------------------------------------------------------
// Borland Visual Solutions Pack Volume 1
// (C) Copyright 1994 by Borland International
//----------------------------------------------------------------------------

#include "txframe.h"
#include "txglob.h"
#include "txglob.rh"

DEFINE_RESPONSE_TABLE1(TTXFrameWindow, TFrameWindow)
  EV_COMMAND(CM_VIEWPARAGRAPHBAR, CmViewParagraphBar),
  EV_COMMAND(CM_VIEWRULER, CmViewRuler),
  EV_COMMAND(CM_VIEWSTATUSBAR, CmViewStatusBar),
  EV_COMMAND(CM_VIEWCONTROLCHARS, CmViewControlChars),
END_RESPONSE_TABLE;

// Constructor
TTXFrameWindow::TTXFrameWindow(TWindow* parent, const char far* title)
  : TFrameWindow(parent, title),
	 TWindow(parent, title)
{
  AssignMenu(IDM_TXEXAMPLE);
}

//Initialize after window has been created at the windows level (a handle is available)
void
TTXFrameWindow::SetupWindow()
{
  TFrameWindow::SetupWindow();

  Client = new TTXClientDialog(this,"TXClientDLG");
  SetClientWindow(Client);
  
  MainMenu = new TMenu(HWindow);

  MainMenu->CheckMenuItem(CM_VIEWPARAGRAPHBAR, MF_BYCOMMAND | MF_CHECKED);
  MainMenu->CheckMenuItem(CM_VIEWRULER, MF_BYCOMMAND | MF_CHECKED);
  MainMenu->CheckMenuItem(CM_VIEWSTATUSBAR, MF_BYCOMMAND | MF_CHECKED);
}

// View the TX button bar, that gives font and paragraph format information
// View|ParagraphBar as command
void
TTXFrameWindow::CmViewParagraphBar()
{
  int Temp;
  TRect 	cr = Client->GetClientRect();
  TRect 	rr = Client->Ruler->GetWindowRect();
  TRect 	bbr;
  TRect 	sbr = Client->StatusBar->GetWindowRect();


  Client->ButtonBar->GetProp("Visible", Temp);
  Client->ButtonBar->SetProp("Visible", Temp == VBX_BOOLEAN_TRUE ? VBX_BOOLEAN_FALSE : VBX_BOOLEAN_TRUE);

  if (Temp == VBX_BOOLEAN_TRUE) //It is now hidden, it used to be visible
	 {
		MainMenu->CheckMenuItem(CM_VIEWPARAGRAPHBAR, MF_BYCOMMAND | MF_UNCHECKED);
		Client->ButtonBar->MoveWindow(cr.left, cr.top, cr.right, 0,TRUE);
	 }
  else
	 {					//It is now visible, it used to be hidden
		MainMenu->CheckMenuItem(CM_VIEWPARAGRAPHBAR, MF_BYCOMMAND | MF_CHECKED);
		Client->ButtonBar->MoveWindow(cr.left, cr.top, cr.right, 30,TRUE);
	 }

  bbr = Client->ButtonBar->GetWindowRect();

  Client->Ruler->MoveWindow(cr.left, cr.top+bbr.Height(), cr.right, rr.Height(),TRUE);
  Client->TextControl->MoveWindow(cr.left, cr.top+bbr.Height()+rr.Height(), cr.right, cr.Height()-sbr.Height()-rr.Height()-bbr.Height(),TRUE);
}

// View the TX ruler bar, that gives text spacing information
// View|Ruler as command
void
TTXFrameWindow::CmViewRuler()
{
  int Temp;
  TRect 	cr = Client->GetClientRect();
  TRect 	rr;
  TRect 	bbr = Client->ButtonBar->GetWindowRect();
  TRect 	sbr = Client->StatusBar->GetWindowRect();

  Client->Ruler->GetProp("Visible", Temp);
  Client->Ruler->SetProp("Visible", Temp == VBX_BOOLEAN_TRUE ? VBX_BOOLEAN_FALSE : VBX_BOOLEAN_TRUE);

  if (Temp == VBX_BOOLEAN_TRUE) //It is now hidden, it used to be visible
	 {
		MainMenu->CheckMenuItem(CM_VIEWRULER, MF_BYCOMMAND | MF_UNCHECKED);
		Client->Ruler->MoveWindow(cr.left, cr.top+bbr.Height(), cr.right, 0,TRUE);
	 }
  else
	 {					//It is now visible, it used to be hidden
		MainMenu->CheckMenuItem(CM_VIEWRULER, MF_BYCOMMAND | MF_CHECKED);
		Client->Ruler->MoveWindow(cr.left, cr.top+bbr.Height(), cr.right, 40,TRUE);
	 }

  rr = Client->Ruler->GetWindowRect();

  Client->ButtonBar->Refresh();
  Client->TextControl->MoveWindow(cr.left, cr.top+bbr.Height()+rr.Height(), cr.right, cr.Height()-sbr.Height()-rr.Height()-bbr.Height(),TRUE);
}

// View the TX status bar, that gives text placement and key info for CAPs, INS, NUM
// View|StatusBar as command
void
TTXFrameWindow::CmViewStatusBar()
{
  int 	Temp;
  TRect 	cr = Client->GetClientRect();
  TRect 	rr = Client->Ruler->GetWindowRect();
  TRect 	bbr = Client->ButtonBar->GetWindowRect();
  TRect 	sbr;

  Client->StatusBar->GetProp("Visible", Temp);
  Client->StatusBar->SetProp("Visible", Temp == VBX_BOOLEAN_TRUE ? VBX_BOOLEAN_FALSE : VBX_BOOLEAN_TRUE);

  if (Temp == VBX_BOOLEAN_TRUE) //It is now hidden, it used to be visible
	 {
		MainMenu->CheckMenuItem(CM_VIEWSTATUSBAR, MF_BYCOMMAND | MF_UNCHECKED);
		Client->StatusBar->MoveWindow(cr.left, cr.top, cr.right, 0,TRUE);
	 }
  else									//It is now visible, it used to be hidden
	 {
		MainMenu->CheckMenuItem(CM_VIEWSTATUSBAR, MF_BYCOMMAND | MF_CHECKED);
		Client->StatusBar->MoveWindow(cr.left, cr.bottom-25, cr.right, 25,TRUE);
	 }

  sbr = Client->StatusBar->GetWindowRect();

  Client->TextControl->MoveWindow(cr.left, cr.top+bbr.Height()+rr.Height(), cr.right, cr.Height()-sbr.Height()-rr.Height()-bbr.Height(),TRUE);
}

// View control characters such as the return key will show up with a paragraph symbol
// View|ControlChars as command
void
TTXFrameWindow::CmViewControlChars()
{
  int Temp;

  Client->TextControl->GetProp("ControlChars", Temp);
  Client->TextControl->SetProp("ControlChars", Temp == VBX_BOOLEAN_TRUE ? VBX_BOOLEAN_FALSE : VBX_BOOLEAN_TRUE);

  if (Temp == VBX_BOOLEAN_TRUE) //It is now hidden, it used to be visible
	 MainMenu->CheckMenuItem(CM_VIEWCONTROLCHARS, MF_BYCOMMAND | MF_UNCHECKED);
  else
	 MainMenu->CheckMenuItem(CM_VIEWCONTROLCHARS, MF_BYCOMMAND | MF_CHECKED);

}

