//----------------------------------------------------------------------------
// Borland Visual Solutions Pack Volume 1
// (C) Copyright 1994 by Borland International
//----------------------------------------------------------------------------

#include <owl\edit.rh>
#include <owl\editsear.rh>
#include "txclient.h"
#include "txglob.rh"
#include "txglob.h"

DEFINE_RESPONSE_TABLE2(TTXClientDialog, TWindow, TVbxEventHandler)
  EV_COMMAND(CM_EDITCUT, CmEditCut),
  EV_COMMAND(CM_EDITCOPY, CmEditCopy),
  EV_COMMAND(CM_EDITPASTE, CmEditPaste),
  EV_COMMAND(CM_EDITCLEAR, CmEditClear),
  EV_COMMAND(CM_EDITSELECTALL, CmEditSelectAll),
  EV_COMMAND(CM_EDITFIND, CmEditFind),
  EV_COMMAND(CM_EDITREPLACE, CmEditReplace),
  EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
  EV_WM_SIZE,
END_RESPONSE_TABLE;

TTXClientDialog::TTXClientDialog(TWindow* parent, const char* name)
	 : TWindow(parent)
{
  ButtonBar = new TVbxTXButtonBar(this, IDC_TXBUTTONBAR,"",0, 0, 400, 30);
  Ruler = new TVbxTXRuler(this, IDC_TXRULER,"",0, 30, 400, 40);
  StatusBar = new TVbxTXStatusBar(this, IDC_TXSTATUSBAR,"",0, 230, 400, 25);
  TextControl = new TVbxTextControl(this, IDC_TEXTCONTROL,"",0, 70, 400, 165);
}

void
TTXClientDialog::SetupWindow()
{
  TWindow::SetupWindow();

//Reset text in window to NULL
  TextControl->SetProp("Text", "");
//Add both horizontal and vertical scroll bars
  TextControl->SetProp("ScrollBars", SCROLLBARS_BOTH);
  TextControl->SetProp("BorderStyle", BORDER_NONE);

//Set PageWidth and PageHeight to 8-1/2 by 11 inches
  TextControl->SetProp("PageWidth", (long)VBXTwp2PixX(A4WidthInTwips));
  TextControl->SetProp("PageHeight", (long)VBXTwp2PixY(A4LengthInTwips));

//Simulate behavior of edit control
  TextControl->SetProp("FormatSelection", VBX_BOOLEAN_TRUE);
//Set margins to 1/2 inch all around
  TextControl->SetProp("PageMarginT", (long)VBXTwp2PixY(TwipsPerInch/2));
  TextControl->SetProp("PageMarginL", (long)VBXTwp2PixX(TwipsPerInch/2));
  TextControl->SetProp("PageMarginR", (long)VBXTwp2PixX(TwipsPerInch/2));
  TextControl->SetProp("PageMarginB", (long)VBXTwp2PixY(TwipsPerInch/2));

  Ruler->SetProp("ScaleUnits", SCALEUNITS_INCHES);

  StatusBar->SetProp("FontName","Arial");
  StatusBar->SetProp("FontBold",VBX_BOOLEAN_FALSE);
  StatusBar->SetProp("FontItalic",VBX_BOOLEAN_FALSE);
  StatusBar->SetProp("FontSize", 8*TwipsPerPoint);  //Pointsize = 8
}

// Remove the contents from the Text control, and place them on the clipboard
// Edit|Cut command
void
TTXClientDialog::CmEditCut()
{
  TextControl->SetProp("Clip", CLIP_CUT);
}

// Copy the contents of the Text control, and place them on the clipboard
// Edit|Copy command
void
TTXClientDialog::CmEditCopy()
{
  TextControl->SetProp("Clip", CLIP_COPY);
}

// Copy the contents of the clipboard, and place them in the Text control
// Edit|Paste as command
void
TTXClientDialog::CmEditPaste()
{
  TextControl->SetProp("Clip", CLIP_PASTE);
}

// Remove the contents from the Text control into bit bucket
// Edit|Clear as command
void
TTXClientDialog::CmEditClear()
{
  TextControl->SetProp("Clip", CLIP_CLEAR);
}

// Select all of the contents in the Text control
// Edit|SelectAll command
void
TTXClientDialog::CmEditSelectAll()
{
  int MousePointerType;

  TextControl->GetProp("MousePointer", MousePointerType);
  TextControl->SetProp("MousePointer", MOUSE_HOURGLASS);
  TextControl->SetProp("SelStart", SELECT_BEGIN);
  TextControl->SetProp("SelLength", SELECT_ALL);
  TextControl->SetProp("MousePointer", MousePointerType);
}

// Find a string of text in the Text control
// Edit|Find as command
void
TTXClientDialog::CmEditFind()
{
  TextControl->SetProp("FindReplace", EDIT_FIND);
}

// Find a string of text in the Text control, and replace with a new string of text
// Edit|Replace as command
void
TTXClientDialog::CmEditReplace()
{
  TextControl->SetProp("FindReplace", EDIT_REPLACE);
}

//Properly size and position controls on window
void
TTXClientDialog::EvSize(UINT sizeType, TSize& size)
{
	TRect cr = GetClientRect();
	TRect bbr = ButtonBar->GetWindowRect();
	TRect rr = Ruler->GetWindowRect();
	TRect sbr = StatusBar->GetWindowRect();

	ButtonBar->MoveWindow(0, 0, cr.right, bbr.Height(),TRUE);
	Ruler->MoveWindow(0, bbr.Height(), cr.right, rr.Height(),TRUE);
	StatusBar->MoveWindow(0, cr.bottom-sbr.Height(), cr.right, sbr.Height(),TRUE);
	TextControl->MoveWindow(0, bbr.Height()+rr.Height(), cr.right, cr.bottom-sbr.Height()-rr.Height()-bbr.Height(),TRUE);

   TextControl->SetFocus();
}

// Help | About message box
void
TTXClientDialog::CmHelpAbout()
{
  string msg;
  string newline('\n');
  msg += "TX Text Demonstration" + newline + newline;
  msg += " 1994 by Borland International" + newline;
  msg += "All rights reserved";
  MessageBox(msg.c_str(), "About TX Example", MB_OK);
}

