//----------------------------------------------------------------------------
// Borland Visual Solutions Pack Volume 1
// (C) Copyright 1994 by Borland International
//----------------------------------------------------------------------------

#include <stdio.h>
#include <owl\editfile.rh>
#include <owl\opensave.h>
#include "txframe.h"
#include "txapp.h"
#include "txglob.rh"

DEFINE_RESPONSE_TABLE1(TTXExampleApp, TApplication)
  EV_COMMAND(CM_FILENEW, CmFileNew),
  EV_COMMAND(CM_FILEOPEN, CmFileOpen),
  EV_COMMAND(CM_FILESAVE, CmFileSave),
  EV_COMMAND(CM_FILESAVEAS, CmFileSaveAs),
//  EV_COMMAND(CM_EXIT, CmFileExit),  Parent class handles message
END_RESPONSE_TABLE;

const char AppName[]="TX Example Program";

void
TTXExampleApp::InitMainWindow()
{
  Frame = new TTXFrameWindow(0,AppName);
  SetMainWindow(Frame);

  Frame->SetIcon(this, IDI_TXEXAMPLE);
  nCmdShow = SW_SHOWMAXIMIZED;

  EnableCtl3d(TRUE);
  EnableBWCC();

  ResetValues("Untitled");
}

// File|New command
void
TTXExampleApp::CmFileNew()
{
  //Reset text in window to NULL
  Frame->Client->TextControl->SetProp("Text", "");
  Frame->Client->TextControl->SetFocus();
  *filename = 0;

  ResetValues("Untitled");
}

// File|Open command
void
TTXExampleApp::CmFileOpen()
{
  TOpenSaveDialog::TData FileData(OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST|OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
											 "Rich Text Format (*.rtf)|*.rtf",
											 0, "", "*");

  if (TFileOpenDialog(MainWindow, FileData).Execute() == IDOK)
	 {
		//Reset text in window to NULL
		Frame->Client->TextControl->SetProp("Text", "");

		Frame->Client->TextControl->SetProp("RTFImport", FileData.FileName);
		filename = FileData.FileName;

		ResetValues(FileData.FileName);
	 }
}

// File|Save command
void
TTXExampleApp::CmFileSave()
{
  if (*filename == 0)
	 {
		CmFileSaveAs();
	 }
  else
	 Frame->Client->TextControl->SetProp("RTFExport", filename);
}

// File|Save As command
void
TTXExampleApp::CmFileSaveAs()
{
  TOpenSaveDialog::TData FileData(OFN_PATHMUSTEXIST|OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
											 "Rich Text Format (*.rtf)|*.rtf",
											 0, "", "*");

  *FileData.FileName = 0;
  if (TFileSaveDialog(MainWindow, FileData).Execute() == IDOK)
	 {
		Frame->Client->TextControl->SetProp("RTFExport", FileData.FileName);
		ResetValues(FileData.FileName);
	 }
}

//Reset the caption and the Dirty Flag.
void
TTXExampleApp::ResetValues(char *fname)
{
  DirtyFlag = FALSE;
  sprintf(buffer, "%s - %s", AppName, fname);
  Frame->SetCaption(buffer);
}

// OWLMain: setup VBX support and run application
int
OwlMain(int, char**)
{
  TBIVbxLibrary vbxLib;     // constructing this loads & inits the library

  return TTXExampleApp().Run();
}

