//----------------------------------------------------------------------------
// Borland Visual Solutions Pack
// (C) Copyright 1993 by Borland International
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\dialog.h>
#include <owl\edit.h>
#include "sysview.h"

#define IDC_TABS  102
#define IDC_EDIT  103

DEFINE_RESPONSE_TABLE2(TControlDialog, TWindow, TVbxEventHandler)
  EV_WM_SIZE,
  EV_VBXEVENTNAME(IDC_TABS, "Click", EvClickTabs),
END_RESPONSE_TABLE;

// Local function: return the contents of a file in a string
static string FileContents(char *szFilename)
{
  HFILE hFile = _lopen(szFilename, OF_READ);
  string Result = "";

  if (hFile != HFILE_ERROR) {
    char szText[101];
    UINT cbRead;

    do {
      cbRead = _lread(hFile, szText, 100);
      szText[cbRead] = 0;
      Result += szText;
    } while (cbRead == 100);
    _lclose(hFile);
  } else
	 Result = "\t\t(unable to read file)";
  return Result;
}

// ControlDialog constructor: setup Tabs VBX, read file contents in string array
TControlDialog::TControlDialog(TWindow* parent)
	 : TWindow(parent)
{
//  Tabs = new TVbxControl(this, IDC_TABS);
//  Edit = new TEdit(this, IDC_EDIT);
  Tabs = new TVbxControl(this, IDC_TABS,
                         "SAXTABS.VBX",
                         "SaxTab",
                         "autoexec.bat|config.sys|win.ini|system.ini",
                         0, 224, 424, 40);
  Edit = new TEdit(this, IDC_EDIT, "", 0, 0, 1, 1);
  Edit->Attr.Style |= ES_MULTILINE | ES_AUTOVSCROLL | ES_AUTOHSCROLL | ES_READONLY | WS_VSCROLL | WS_TABSTOP;
   
  EditContents[0] = FileContents("C:\\AUTOEXEC.BAT");
  EditContents[1] = FileContents("C:\\CONFIG.SYS");
  char szPath[128];
  GetWindowsDirectory(szPath, sizeof(szPath));
  strcat(szPath, "\\WIN.INI");
  EditContents[2] = FileContents(szPath);
  GetWindowsDirectory(szPath, sizeof(szPath));
  strcat(szPath, "\\SYSTEM.INI");
  EditContents[3] = FileContents(szPath);
}

// SetupWindow: Simulate a click tabs event to fill edit box
void TControlDialog::SetupWindow()
{
  TWindow::SetupWindow();
//  TDialog::SetupWindow();
  EvClickTabs(0);
}

// Click event: set edit contents to string of active tab
void TControlDialog::EvClickTabs(VBXEVENT far * /*event*/)
{
  int nActiveTab;
  Tabs->GetProp("ActiveTab", nActiveTab);
  SetDlgItemText(IDC_EDIT, EditContents[nActiveTab].c_str());
}

void TControlDialog::EvSize(UINT /*arg not used*/, TSize&/*arg not used*/)
{
   TRect r = GetClientRect();
   TRect tr = Tabs->GetWindowRect();

   Tabs->MoveWindow(0, r.bottom-tr.Height(), r.right, tr.Height());
   Tabs->Invalidate();

	Edit->MoveWindow(-1, -1, r.right+2, r.bottom-tr.Height()+1,TRUE);
   Edit->Invalidate();
}

