//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1993 by Borland International
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\dialog.h>
#include <owl\framewin.h>
#include <owl\vbxctl.h>
#include "integra1.rc"
#include "..\..\..\INCLUDE\sqcmain.h"
#include "..\..\..\INCLUDE\sqc1.h"

class TDBApp : public TApplication {
  public:
    TDBApp() : TApplication() {}
    long DBHandle;

  protected:
    void InitMainWindow();
};

class TDocDialog : public TDialog, public TVbxEventHandler {
  public:
    TDocDialog(TWindow* parent, TResId name);

  protected:
    void SetupWindow();
    BOOL PreProcessMsg(MSG& msg);

    // OWL Aliases for VBX controls in dialog
    //
    TVbxCIQry* Query;

    void EvPREFETCH(VBXEVENT FAR*);
    void EvPreAction(VBXEVENT FAR*);
    void EvPostAction(VBXEVENT FAR*);

  DECLARE_RESPONSE_TABLE(TDocDialog);
};

DEFINE_RESPONSE_TABLE2(TDocDialog, TDialog, TVbxEventHandler)
  EV_VBXEVENTINDEX( IDC_CIQRY1, Event_CIQry_PREFETCH,  EvPREFETCH ),
  EV_VBXEVENTINDEX( IDC_CIOP2,  Event_CIOP_PreAction,  EvPreAction ),
  EV_VBXEVENTINDEX( IDC_CIOP2,  Event_CIOP_PostAction, EvPostAction ),
  EV_WM_GETDLGCODE,
END_RESPONSE_TABLE;

BOOL TDocDialog::PreProcessMsg(MSG& msg)
{
  if (msg.message == WM_KEYDOWN &&
      (msg.wParam == VK_ESCAPE || msg.wParam == VK_RETURN))
    return TRUE;      // ignore OK and CANCEL keys, rather than quit dialog
  return TDialog::PreProcessMsg(msg);
}

void TDocDialog::EvPREFETCH(VBXEVENT FAR*)
{
// hCursor as Long,RowNum as Long,Lparam as Long,Action as long
}

void TDocDialog::EvPreAction(VBXEVENT FAR*)
{
//long bits;
//char buf[120];
//string sql;
//Query->GetPropModeBitMask(bits);
//Query->GetPropStatement(sql);
//sql.copy(buf, sizeof(buf)-1);
//wsprintf(buf, "Query Mode Bits = %lX", bits);
//Parent->SetCaption(buf);
//MessageBox("Received PreAction", "VBX Event", MB_OK);
  // hCursor as Long,Operation as long,Lparam as long,Action as long
}
void TDocDialog::EvPostAction(VBXEVENT FAR*)
{
//MessageBox("Received PostAction", "VBX Event", MB_OK);
  // hCursor as Long,ReturnCode as long,Lparam as long,Action as long
}

TDocDialog::TDocDialog(TWindow* parent, TResId name)
  : TDialog(parent, name)
{
  Query = new TVbxCIQry(this, IDC_CIQRY1);
}

void TDocDialog::SetupWindow()
{
  TDialog::SetupWindow();
  SQcGo(((TDBApp*)GetApplication())->DBHandle,0);
}

void TDBApp::InitMainWindow() {
  TDocDialog *DocDlg = new TDocDialog(0,TResId(IDD_DOCTORS));
  MainWindow = new TFrameWindow(0, "Integra Example", DocDlg, TRUE);
  MainWindow->Attr.Style &= ~(WS_MAXIMIZEBOX | WS_THICKFRAME);
}

int
OwlMain(int, char**)
{
  TBIVbxLibrary vbxLib;     // constructing this loads & inits the library
  TDBApp app;
  long revision;
  SQcConnect(&app.DBHandle,&revision);
  int result = app.Run();
  SQcDisconnect(app.DBHandle);
  return result;
}
