/*  Project vbx

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    vbx.exe Application
	 FILE:         vbxmdich.cpp
	 AUTHOR:


	 OVERVIEW
	 ========
	 Source file for implementation of vbxMDIChild (TMDIChild).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "vbxapp.h"
#include "vbxmdich.h"

#include <stdio.h>

const int IDC_ADD= 200;
const int IDC_SUB= 201;
const int IDC_MHGAUGE= 202;
//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE2(vbxMDIChild, TMDIChild, TVbxEventHandler)
//{{vbxMDIChildRSP_TBL_BEGIN}}
	EV_BN_CLICKED(IDC_ADD, OnClickedAdd),
	EV_BN_CLICKED(IDC_SUB, OnClickedSub),
	EV_WM_ERASEBKGND,
//{{vbxMDIChildRSP_TBL_END}}
END_RESPONSE_TABLE;

//{{vbxMDIChild Implementation}}

//////////////////////////////////////////////////////////
// vbxMDIChild
// ==========
// Construction/Destruction handling.
vbxMDIChild::vbxMDIChild (TMDIClient &parent, const char far *title, TWindow *clientWnd, BOOL shrinkToClient, TModule *module)
	 : TMDIChild (parent, title, clientWnd, shrinkToClient, module)
// AppExpert assumes that an MDI app is a text window, but we need a graphical base
// so we change the code to reflect that in our vbxMDIchild class
{
	 // INSERT>> Your constructor code here.
	VbxMhGauge = new TVbxMhGauge( this,
											IDC_MHGAUGE,
											"Test Gauge",
											200,
											200,
											64,
											48,
											sizeof(MhGaugeData),
											MhGaugeData);
	beenheredoneit=FALSE;
	AddPer = new TButton(this, IDC_ADD,"Add Percent",200,10,100,30,FALSE);
	SubPer = new TButton(this, IDC_SUB,"Sub Percent",200,80,100,30,FALSE);
   CurrentVbxValue = 0;
}


vbxMDIChild::~vbxMDIChild ()
{
	Destroy();

	// INSERT>> Your destructor code here.
	delete VbxMhGauge;

}

BOOL vbxMDIChild::EvEraseBkgnd (HDC dc)
{
	BOOL result;
	TDC dC(dc);                    //dc class for usage in painting
	result = TMDIChild::EvEraseBkgnd(dc);

	// INSERT>> Your code here.
	if(!beenheredoneit)
	{
	PICTURE temp;                          //Temporary picture structure
	HPIC pic;                              //Handle to the picture structure
	temp.Type = PICTURE_BMP;               //define type of pic to store
	temp.Data.Bitmap.Bitmap = LoadBitmap(_hInstance,MAKEINTRESOURCE(IDB_BITMAP1));
														//load the pic structure with bitmap data
	temp.Data.Bitmap.Palette = (HPALETTE)GetStockObject ( DEFAULT_PALETTE );
	//!!!!!IMPORTANT:You must define a palette or a stack fault will occur!!!!!!!!!
	pic = VBXCreatePicture(&temp); 			//get a handle to the temp pic structure
	VbxMhGauge->SetPropStyle(2);           //we want a full gauge style
	VbxMhGauge->SetPropPicture(pic);       //assign the picture to the gauge
	beenheredoneit=TRUE;                   //one time initialization is finished
	}

	// Move must use twips instead of pixels.
	TRect			windowSize			=	GetClientRect();      //get window coordinates
	TColor color(192,192,192);                             //get gray color
	TBrush brush(color);                                   //make a gray brush
	TRect rect;                                            //define a rectangle class object
	dC.GetClipBox(rect);                                   //get the window's coords
	dC.FillRect(rect,brush);

	VbxMhGauge->Move(	1440/4,   									//auto center
							1440/2,  										//auto center
							VBXPix2TwpX(221),                    //x size
							VBXPix2TwpY(90));                    //y size

	AddPer->MoveWindow(VBXTwp2PixX(1440/4),               	//move the buttons too
							 VBXTwp2PixY(1440*2),
							 100,30,TRUE);

	SubPer->MoveWindow(VBXTwp2PixX(1440*1.5),
							 VBXTwp2PixY(1440*2),
							 100,30,TRUE);

	char strbuf[8];
	wsprintf(strbuf, "%3d%%  ", CurrentVbxValue);
	dC.TextOut(10, 10, strbuf, strlen(strbuf));

	return result;
}

void vbxMDIChild::OnClickedAdd()
{
	VbxMhGauge->GetPropValue(CurrentVbxValue);
	if (CurrentVbxValue < 100)
	  {
		 CurrentVbxValue += 1;
	  }
	VbxMhGauge->SetPropValue(CurrentVbxValue);
	char strbuf[8];
	TClientDC dc(*this);
	wsprintf(strbuf, "%3d%%  ", CurrentVbxValue);
	dc.TextOut(10, 10, strbuf, strlen(strbuf));
}

void vbxMDIChild::OnClickedSub()
{
	VbxMhGauge->GetPropValue(CurrentVbxValue);
	if (CurrentVbxValue > 0)
	  {
		 CurrentVbxValue -= 1;
	  }
	VbxMhGauge->SetPropValue(CurrentVbxValue);
	char strbuf[8];
	TClientDC dc(*this);
	wsprintf(strbuf, "%3d%%  ", CurrentVbxValue);
	dc.TextOut(10, 10, strbuf, strlen(strbuf));
}
