//---------------------------------------------------------
//     DIBVIEW - TDIBDlgView source module
//---------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\validate.h>
#include <owl\inputdia.h>
#include "dibview.h"

////////////////////////////////////////////////////////////////
DEFINE_DOC_TEMPLATE_CLASS(TDIBDocument, TDibView, DIBDlgViewTmpl);
DIBDlgViewTmpl BMPTmpl("Windows Bitmap Format", 
                       "*.bmp;*.dib",
                        0,
                       "BMP",
								dtAutoOpen|dtAutoDelete|dtUpdateDir|dtFileMustExist);

DIBDlgViewTmpl PCXTmpl("ZSOFT Bitmap Format",
                       "*.pcx",
                        0,
                       "PCX",
								dtAutoOpen|dtAutoDelete|dtUpdateDir|dtFileMustExist);

DIBDlgViewTmpl TGATmpl("TrueVision Targa Format",
                       "*.tga",
                        0,
                       "TGA",
                        dtAutoOpen|dtAutoDelete|dtUpdateDir|dtFileMustExist);

////////////////////////////////////////////////////////////////
DEFINE_RESPONSE_TABLE1(TDibView, TVbxPicBuf)
  EV_VN_DOCOPENED,
  EV_VN_DOCCLOSED,
  EV_VN_VIEWOPENED,
  EV_VN_VIEWCLOSED,
  EV_VN_ISWINDOW,

  EV_COMMAND(CM_FILESAVE, CmFileSave),
  EV_COMMAND(CM_FILESAVEAS, CmFileSaveAs),

  EV_COMMAND_ENABLE(CM_AUTOSCALE, CeAutoscale),
  EV_COMMAND(CM_AUTOSCALE, CmAutoscale),
  EV_COMMAND_ENABLE(CM_ZOOMFACTOR, CeZoomFactor),
  EV_COMMAND(CM_ZOOMFACTOR, CmZoomFactor),

  EV_COMMAND(CM_IMKNEGATE, CmImkNegate),
  EV_COMMAND(CM_IMKMIRRORHORZ, CmImkMirrorHorizontal),
  EV_COMMAND(CM_IMKMIRRORVERT, CmImkMirrorVertical),
  EV_COMMAND(CM_IMKROTATE, CmImkRotate),
  EV_COMMAND(CM_IMKSHARPEN,CmImkSharpen),
  EV_COMMAND(CM_IMKSOFTEN, CmImkSoften),

  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_Click, PicBuf_EvClick),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_Change, PicBuf_EvChange),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_DblClick, PicBuf_EvDblClick),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_DragDrop, PicBuf_EvDragDrop),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_DragOver, PicBuf_EvDragOver),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_GotFocus, PicBuf_EvGotFocus),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_KeyDown, PicBuf_EvKeyDown),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_KeyPress, PicBuf_EvKeyPress),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_KeyUp, PicBuf_EvKeyUp),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_LostFocus, PicBuf_EvLostFocus),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_MouseDown, PicBuf_EvMouseDown),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_MouseMove, PicBuf_EvMouseMove),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_MouseUp, PicBuf_EvMouseUp),
  EV_VBXEVENTINDEX(IDC_PICBUF, Event_PicBuf_Paint, PicBuf_EvPaint),
END_RESPONSE_TABLE;


////////////////////////////////////////////////////////////////
TDibView::TDibView(TDIBDocument& doc, TWindow* parent, const char* name,
                         TModule* module) :
TVbxPicBuf(parent, IDC_PICBUF, name, 0,0,1,1, 0, 0, module ? module : ::Module),
TView(doc),
DocPtr(&doc)
{
  //
  // Set View's menu
  //
  SetViewMenu(new TMenuDescr("OPENDIBVIEW",0,2,1,0,0,0));
}

TDibView::~TDibView()
{
}

////////////////////////////////////////////////////////////////
void TDibView::SetupWindow()
{
  TVbxPicBuf::SetupWindow();
  SetPropBorderStyle(0);
  SetPropDragMode(DragMode_1_Automatic);
  PICTURE p;
  p.Type = PICTURE_ICON;
  p.Data.Icon.Icon = ::LoadIcon(*GetModule(), "IDI_COPYDIB");
  SetPropDragIcon(VBXCreatePicture(&p));
  FillViewData();
}

////////////////////////////////////////////////////////////////
BOOL TDibView::CanClose()
{
  return DocPtr->CanClose();
}

////////////////////////////////////////////////////////////////
void TDibView::FillViewData()
{
  SetPropFullPicture(int(DocPtr->GetHDIB()));
}

////////////////////////////////////////////////////////////////
void TDibView::UpdateViewData()
{
  FillViewData();
}

////////////////////////////////////////////////////////////////
BOOL TDibView::VnViewOpened(TView*)
{
  return TRUE;
}

BOOL  TDibView::VnViewClosed(TView*)
{
  return TRUE;
}

BOOL  TDibView::VnDocOpened(int /*omode*/)
{
  return TRUE;
}

BOOL  TDibView::VnDocClosed(int /*omode*/)
{
  return TRUE;
}

BOOL  TDibView::VnIsWindow(HWND hWnd)
{
  return Parent->HWindow == hWnd;  // Parent is TMDIChild
}

////////////////////////////////////////////////////////////////
void TDibView::CmFileSave()
{
  if (!DocPtr->GetDocPath()) {
    CmFileSaveAs();
    return;
  }
  if (!DocPtr->IsDirty()) {
    DocPtr->GetDocManager().PostDocError(*DocPtr, IDS_NOTCHANGED);
    return;
  }
  DocPtr->Commit();  // should force write here?
}

void TDibView::CmFileSaveAs()
{
  TDocTemplate* tpl;

  if ((tpl = DocPtr->GetDocManager().SelectAnySave(*DocPtr, FALSE)) == 0)
    return;
  if (tpl != DocPtr->GetTemplate())
    DocPtr->SetTemplate(tpl);       // replace existing template
  DocPtr->Commit(TRUE);             // force rewrite to new path
  Parent->SetCaption(DocPtr->GetTitle()); // Parent is TMDIChild
}

////////////////////////////////////////////////////////////////
void TDibView::CeAutoscale(TCommandEnabler& ce)
{
  BOOL autoscaleState;
  GetPropAutoScale(autoscaleState);
  ce.SetCheck(autoscaleState ? TCommandEnabler::Checked : TCommandEnabler::Unchecked);
}

void TDibView::CmAutoscale()
{
  BOOL autoscaleState;
  GetPropAutoScale(autoscaleState);
  SetPropAutoScale(!autoscaleState);
}

////////////////////////////////////////////////////////////////
void TDibView::CeZoomFactor(TCommandEnabler& ce)
{
  BOOL autoscaleState;
  GetPropAutoScale(autoscaleState);
  ce.Enable(!autoscaleState);
}

void TDibView::CmZoomFactor()
{
  float zoomFactor;
  GetPropZoomFactor(zoomFactor);

  char dlgBuffer[15];
  gcvt(zoomFactor, 6, dlgBuffer);
  TInputDialog dlgZoom(this, "Zoom Factor",
                       "Enter Zoom Factor:", dlgBuffer,
                       sizeof(dlgBuffer));

  if (dlgZoom.Execute() == IDOK) {
    // Get Zoom entered
    zoomFactor = atof(dlgBuffer);
    SetPropZoomFactor(zoomFactor);
  }
}

////////////////////////////////////////////////////////////////
void TDibView::CmImkNegate()
{
  DocPtr->SetHDIB((HDIB)imkNegate((short)DocPtr->GetHDIB()));
  UpdateViewData();
}

void TDibView::CmImkMirrorHorizontal()
{
  DocPtr->SetHDIB((HDIB)imkMirror((short)DocPtr->GetHDIB(),TRUE,FALSE));
  UpdateViewData();
}

void TDibView::CmImkMirrorVertical()
{
  DocPtr->SetHDIB((HDIB)imkMirror((short)DocPtr->GetHDIB(),FALSE,TRUE));
  UpdateViewData();
}

void TDibView::CmImkRotate()
{
  char dlgBuffer[7] = "90";
  TRangeValidator degreeValidator(0, 360);
  TInputDialog dlgDegree(this, "Degrees of Rotation",
                         "Enter degrees to rotate:", dlgBuffer,
                         sizeof(dlgBuffer), 0, &degreeValidator);

  if (dlgDegree.Execute() == IDOK) {
    // Get Degree entered
    int degree = atoi(dlgBuffer);

    // Get Background color
    COLORREF backColor;
    GetPropBackColor(backColor);

    // Create PaletteEntry for background color
    PALETTEENTRY peBackColor;
    peBackColor.peRed = GetRValue(backColor);
    peBackColor.peGreen = GetGValue(backColor);
    peBackColor.peBlue = GetBValue(backColor);
    peBackColor.peFlags = 0;

    DocPtr->SetHDIB((HDIB)imkRotate((short)DocPtr->GetHDIB(), degree, peBackColor));
    UpdateViewData();
  }
}

void TDibView::CmImkSharpen()
{
  char dlgBuffer[3] = "1";
  TRangeValidator sharpnessValidator(1, 10);
  TInputDialog dlgSharpen(this, "Degree of Sharpness",
                          "Enter degrees to sharpen(1-10):", dlgBuffer,
                          sizeof(dlgBuffer), 0, &sharpnessValidator);

  if (dlgSharpen.Execute() == IDOK) {
    // Get Sharpness entered
    DocPtr->SetHDIB((HDIB)imkSharpen((short)DocPtr->GetHDIB(), atoi(dlgBuffer)));
    UpdateViewData();
  }
}

void TDibView::CmImkSoften()
{
  char dlgBuffer[3] = "1";
  TRangeValidator softnessValidator(1, 10);
  TInputDialog DlgSoften(this,"Degree of Softness",
                         "Enter degrees to soften(1-10):", dlgBuffer,
                          sizeof(dlgBuffer), 0, &softnessValidator);

  if (DlgSoften.Execute() == IDOK) {
    // Get Softness entered
    DocPtr->SetHDIB((HDIB)imkSoften((short)DocPtr->GetHDIB(), atoi(dlgBuffer)));
    UpdateViewData();
  }
}

////////////////////////////////////////////////////////////////
void TDibView::PicBuf_EvDragDrop(VBXEVENT FAR* event) {
  // Source As Control,X As Integer,Y As Integer
  HCTL hCtl = VBX_EVENTARGNUM(event, HCTL, 0);
  TVbxPicBuf* src = TYPESAFE_DOWNCAST(GetWindowPtr(VBXGetHwnd(hCtl)), TVbxPicBuf);

  if (src) {
    int hDib;
    src->GetPropFullPicture(hDib);
    DocPtr->SetHDIB((HDIB)imkDuplicate(hDib));
    DocPtr->SetDocPath(0);
    TView::SetDocTitle(0, 0);
    Parent->SetCaption(DocPtr->GetTitle()); // Parent is TMDIChild
    UpdateViewData();
  }
}

////////////////////////////////////////////////////////////////
// Could implement selection rect by handling these events & setting
// the SelectionXxx properties.
//
void TDibView::PicBuf_EvMouseDown(VBXEVENT FAR*) {
  // Button As Integer,Shift As Integer,X As Integer,Y As Integer
}

void TDibView::PicBuf_EvMouseMove(VBXEVENT FAR*) {
  // Button As Integer,Shift As Integer,X As Integer,Y As Integer
}

void TDibView::PicBuf_EvMouseUp(VBXEVENT FAR*) {
  // Button As Integer,Shift As Integer,X As Integer,Y As Integer
}

