//---------------------------------------------------------
//     DIBVIEW Sample Application
//---------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#define KNIFE_DATA
#include "dibdoc.h"
#include "dibview.h"
#include "dibapp.rc"

//---------------------------------------------------------
// A variant of TMDIChild that can parent vbx controls directly
//---------------------------------------------------------
class TVbxMDIChild : public TMDIChild, public TVbxEventHandler {
  public:
    TVbxMDIChild(TMDIClient& parent, const char far* title, TWindow* client)
      : TMDIChild(parent, title, client, FALSE) {}
  DECLARE_RESPONSE_TABLE(TVbxMDIChild);
};

DEFINE_RESPONSE_TABLE2(TVbxMDIChild, TMDIChild, TVbxEventHandler)
END_RESPONSE_TABLE;

//---------------------------------------------------------
//     TDIBApp Class
//---------------------------------------------------------
class TDIBApp : public TApplication {
  public:
	 TDIBApp();

  protected:
	 // Override methods of TApplication
	 void InitInstance();
	 void InitMainWindow();

	 // Event handlers
	 void EvNewView  (TView& view);
	 void EvCloseView(TView& view);
	 void CmCopyDib();
	 void CmCopyDibEnable(TCommandEnabler& ce);
	 void CmAbout();

	 TMDIClient* Client;
  DECLARE_RESPONSE_TABLE(TDIBApp);
};

///////////////////////////////////////

DEFINE_RESPONSE_TABLE1(TDIBApp, TApplication)
  EV_OWLVIEW(dnCreate, EvNewView),
  EV_OWLVIEW(dnClose,  EvCloseView),
  EV_COMMAND(CM_COPYDIB, CmCopyDib),
  EV_COMMAND_ENABLE(CM_COPYDIB, CmCopyDibEnable),
  EV_COMMAND(CM_ABOUT, CmAbout),
END_RESPONSE_TABLE;

///////////////////////////////////////
TDIBApp::TDIBApp() : TApplication("Dib View")
{
}

///////////////////////////////////////
void TDIBApp::InitMainWindow()
{
  // Construct the decorated frame window
  TDecoratedMDIFrame* frame = new TDecoratedMDIFrame(GetName(), 0,
											*(Client = new TMDIClient), TRUE);
  // Construct a status bar
  TStatusBar* sb = new TStatusBar(frame, TGadget::Recessed);

  // Construct a control bar
  TControlBar *cb = new TControlBar(frame);
  cb->Insert(*new TButtonGadget(CM_FILEOPEN, CM_FILEOPEN, TButtonGadget::Command));
  cb->Insert(*new TButtonGadget(CM_FILESAVE, CM_FILESAVE, TButtonGadget::Command));
  cb->Insert(*new TButtonGadget(CM_FILESAVEAS, CM_FILESAVEAS, TButtonGadget::Command));
  cb->Insert(*new TButtonGadget(CM_COPYDIB, CM_COPYDIB, TButtonGadget::Command));
  cb->Insert(*new TSeparatorGadget);
  cb->Insert(*new TButtonGadget(CM_ABOUT, CM_ABOUT, TButtonGadget::Command));
  cb->SetHintMode(TGadgetWindow::EnterHints);

  // Insert the status bar and control bar into the frame
  frame->Insert(*sb, TDecoratedFrame::Bottom);
  frame->Insert(*cb, TDecoratedFrame::Top);

  // Install the document manager
  SetDocManager(new TDocManager(dmMDI));

  // Set the main window and its menu
  frame->SetMenuDescr(TMenuDescr("COMMANDS",1,0,0,0,1,1));
  SetMainWindow(frame);
}

///////////////////////////////////////

void TDIBApp::InitInstance()
{
  TApplication::InitInstance();
  EnableCtl3d();
}

///////////////////////////////////////

void TDIBApp::EvNewView(TView& view)
{
  TMDIChild* child = new TVbxMDIChild(*Client, view.GetDocument().GetTitle(),
                                      view.GetWindow());
  if (view.GetViewMenu())
    child->SetMenuDescr(*view.GetViewMenu());
  child->Create();
}

///////////////////////////////////////

void TDIBApp::EvCloseView(TView& /*view*/)
{  // nothing needs to be done here for MDI
}

void TDIBApp::CmCopyDib()
{
  // Could add code to create a new Doc&View, or a new view on current doc
}

void TDIBApp::CmCopyDibEnable(TCommandEnabler& ce)
{
 // Disable button since functionality is not yet implemented
 ce.Enable(FALSE);
}

void TDIBApp::CmAbout()
{
  TDialog(GetMainWindow(), IDD_ABOUT).Execute();
}

//---------------------------------------------------------
//     TIMKLibrary Class
//---------------------------------------------------------
class TIMKLibrary
{
  public:
    TIMKLibrary() { imkBegin(); }
   ~TIMKLibrary() { imkEnd();  }
};

//---------------------------------------------------------
//     OWLMAIN
//---------------------------------------------------------
int OwlMain(int /*argc*/, char* /*argv*/ [])
{
  TBIVbxLibrary vbxLib;
  TIMKLibrary imkLib;

  return TDIBApp().Run();
}
