//----------------------------------------------------------------------------
// Borland Visual Solutions Pack
// (C) Copyright 1993 by Borland International
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\opensave.h>
#include "termchld.h"
#include "settings.h"
#include "termapp.rh"            // Definition of all resources.
#include <stdio.h>
#include <dir.h>

static char *Session = "Session";

//
// Build a response table for all messages/commands handled
// by SaxTermChild derived from TMDIClient.
//
DEFINE_RESPONSE_TABLE1(SaxTermChild, TVbxsaxComm)
    EV_COMMAND(CM_FILESAVE, CmFileSave),
    EV_COMMAND(CM_FILESAVEAS, CmFileSaveAs),
    EV_COMMAND(CM_FILEDOWNLOAD, CmFileDownload),
    EV_COMMAND(CM_FILEUPLOAD, CmFileUpload),
    EV_COMMAND_ENABLE(CM_FILEDOWNLOAD, CmPortOpenEnable),
    EV_COMMAND_ENABLE(CM_FILEUPLOAD, CmPortOpenEnable),
    EV_COMMAND(CM_PHONEDISCONNECT, CmPhoneDisconnect),
    EV_COMMAND_ENABLE(CM_PHONEDISCONNECT, CmPortOpenEnable),
    EV_COMMAND(CM_PHONESETTINGS, CmPhoneSettings),
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// SaxTermChild
// ==========
// Constuction/Destruction handling.
SaxTermChild::SaxTermChild(TWindow* parent, const char far* title, TModule* module)
    : TVbxsaxComm(parent, 100, title, 0, 0, 1, 1, 0, 0, module)
{
  Filename = title;
}

SaxTermChild::~SaxTermChild()
{
  Destroy();
}

void SaxTermChild::SetupWindow()
{
  string title;
  if (!Filename.length()) {
    char  t[128];
    GetApplication()->LoadString(IDS_UNTITLED, t, sizeof t);
    title = t;
  } else
    title = Filename;

  string newCaption;
  if (Parent->Title && *Parent->Title) {
    newCaption = Parent->Title;
    newCaption += " - ";
  }
  newCaption += title;
  Parent->SetWindowText(newCaption.c_str());

  LoadTextProp("Port");
  LoadNumProp("Parity");
  LoadNumProp("StopBits");
  LoadNumProp("DataBits");
  LoadNumProp("CtsRts");
  LoadNumProp("XonXoff");
  LoadNumProp("Speed");
}

void SaxTermChild::CmPhoneSettings()
{
  SaxTermSettingsDlg(this).Execute();
}

void SaxTermChild::CmFileUpload()
{
  static TOpenSaveDialog::TData  fileData;

  *fileData.FileName = 0;
  fileData.Flags = OFN_HIDEREADONLY;
  fileData.SetFilter("All Files (*.*)|*.*|");
  fileData.DefExt = "";
  if (TFileOpenDialog(this, fileData, 0, "File to upload").Execute() == IDOK)
    SetProp("Upload", fileData.FileName);
}

void SaxTermChild::CmFileDownload()
{
  static TOpenSaveDialog::TData  fileData;

  *fileData.FileName = 0;
  fileData.Flags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
  fileData.SetFilter("All Files (*.*)|*.*|");
  fileData.DefExt = "";
  if (TFileSaveDialog(this, fileData, 0, "File to download").Execute() == IDOK)
    SetProp("Download", fileData.FileName);
}

void SaxTermChild::CmPortOpenEnable(TCommandEnabler& ce)
{
  ce.Enable(IsPortOpen());
}

BOOL SaxTermChild::IsPortOpen()
{
  string s;
  GetProp("Port", s);
  return s.length();
}

void SaxTermChild::CmPhoneDisconnect()
{
  SetProp("Send", "+++");
  // Switch modem to command mode
  for (DWORD dwTicks = GetTickCount() ; dwTicks + 1000 > GetTickCount(); )
    ;
  SetProp("Send", "ATH\r"); // Hang up
}

void SaxTermChild::SaveTextProp(char* name)
{
  string value;
  GetProp(name, value);
  WritePrivateProfileString(Session, name, value.c_str(), Filename.c_str());
}

void SaxTermChild::SaveNumProp(char* name)
{
  long value;
  GetProp(name, value);
  value &= 0xFFFF;
  char text[30];
  wsprintf(text, "%ld", value);
  WritePrivateProfileString(Session, name, text, Filename.c_str());
}

void SaxTermChild::LoadTextProp(char* name)
{
  static char text[100];
  GetPrivateProfileString(Session, name, "", text, sizeof text, Filename.c_str());
  if (*text)
    SetProp(name, text);
}

void SaxTermChild::LoadNumProp(char* name)
{
   UINT value = GetPrivateProfileInt(Session, name, (UINT)0xFFFE, Filename.c_str());
   if (value != 0xFFFE)
      SetProp(name, (long)value);
}

void SaxTermChild::CmFileSave()
{
  if (!Filename.length()) {
    CmFileSaveAs();
    return;
  }
  SaveTextProp("Port");
  SaveNumProp("Parity");
  SaveNumProp("StopBits");
  SaveNumProp("DataBits");
  SaveNumProp("CtsRts");
  SaveNumProp("XonXoff");
  SaveNumProp("Speed");
}

void SaxTermChild::CmFileSaveAs()
{
  TOpenSaveDialog::TData  fileData;

  *fileData.FileName = 0;
  fileData.Flags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
  fileData.SetFilter("Comm Session Files (*.ses)|*.ses|All Files (*.*)|*.*|");
  fileData.DefExt = "SES";
  if (TFileSaveDialog(this, fileData).Execute() == IDOK) {
    Filename = fileData.FileName;
    SetCaption(fileData.FileName);
    CmFileSave();
  }
}

