//----------------------------------------------------------------------------
// Borland Visual Solutions Pack
// (C) Copyright 1993 by Borland International
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\decframe.h>
#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <owl\opensave.h>
#include <stdio.h>
#include <dir.h>
#include "termchld.h"            // The terminal as a child window
#include "termapp.rh"            // Definition of all resources.

class SaxTermApp : public TApplication {
  public:
    SaxTermApp();
   ~SaxTermApp();

  protected:
    void InitMainWindow();
    void SetupToolBar(TDecoratedFrame* frame);

    void CmFileNew();
    void CmFileOpen();
    void CmHelpAbout();

  private:
    void OpenFile(const char* fileName);

  DECLARE_RESPONSE_TABLE(SaxTermApp);
};

//
// Build a response table for all messages/commands handled
// by SaxTermApp derived from TApplication.
//
DEFINE_RESPONSE_TABLE1(SaxTermApp, TApplication)
  EV_COMMAND(CM_MDIFILENEW, CmFileNew),
  EV_COMMAND(CM_MDIFILEOPEN, CmFileOpen),
  EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// SaxTermApp
// =====
//
SaxTermApp::SaxTermApp () : TApplication("Sax Terminal")
{
}

SaxTermApp::~SaxTermApp ()
{
}

void SaxTermApp::SetupToolBar(TDecoratedFrame* frame)
{
  //
  // Create default toolbar New and associate toolbar buttons with commands.
  //
  TControlBar* cb = new TControlBar(frame);
  cb->Insert(*new TButtonGadget(CM_MDIFILENEW, CM_MDIFILENEW));
  cb->Insert(*new TButtonGadget(CM_MDIFILEOPEN, CM_MDIFILEOPEN));
  cb->Insert(*new TButtonGadget(CM_FILESAVE, CM_FILESAVE));
  cb->Insert(*new TSeparatorGadget(6));
  cb->Insert(*new TButtonGadget(CM_FILEUPLOAD, CM_FILEUPLOAD));
  cb->Insert(*new TButtonGadget(CM_FILEDOWNLOAD, CM_FILEDOWNLOAD));
  cb->SetHintMode(TGadgetWindow::EnterHints);

  frame->Insert(*cb, TDecoratedFrame::Top);
}

//////////////////////////////////////////////////////////
// SaxTermApp
// =====
// Application intialization.
//
void SaxTermApp::InitMainWindow()
{
  TDecoratedFrame* frame = new TDecoratedFrame(0, GetName(), new SaxTermChild(0, 0),TRUE);
  nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

  // Assign ICON w/ this application.
  //
  frame->SetIcon(this, IDI_SAXAPPLICATION);

  // Menu associated with window and accelerator table associated with table.
  //
  frame->AssignMenu(IDM_MENU);
  frame->Attr.AccelTable = IDA_EDITFILE;

  SetupToolBar(frame);

  TStatusBar* sb = new TStatusBar(frame, TGadget::Recessed, TStatusBar::CapsLock | TStatusBar::NumLock);
  frame->Insert(*sb, TDecoratedFrame::Bottom);

  MainWindow = frame;

  // Windows 3-D controls.
  //
  EnableCtl3d(TRUE);
}

void SaxTermApp::OpenFile(const char* fileName)
{
  // Create a new sax term client
  //
  delete GetMainWindow()->SetClientWindow(new SaxTermChild(GetMainWindow(), fileName));
}

//////////////////////////////////////////////////////////
// Menu File New command
void SaxTermApp::CmFileNew()
{
  OpenFile(0);
}

//////////////////////////////////////////////////////////
// Menu File Open command
void SaxTermApp::CmFileOpen()
{
  //
  // Display standard Open dialog box to select a file name.
  //
  TOpenSaveDialog::TData  fileData;

  fileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_CREATEPROMPT | OFN_OVERWRITEPROMPT;
  fileData.SetFilter("Comm Session Files (*.ses)|*.ses|All Files (*.*)|*.*|");
  fileData.DefExt = "SES";
  *fileData.FileName = 0;
  if (TFileOpenDialog(GetMainWindow(), fileData).Execute() == IDOK)
    OpenFile(fileData.FileName);
}

//////////////////////////////////////////////////////////
// Menu Help About SaxTerm.exe command
void SaxTermApp::CmHelpAbout ()
{
  TDialog(GetMainWindow(),IDD_ABOUT).Execute();    // Show the modal dialog.
}

//////////////////////////////////////////////////////////

int OwlMain (int /*argc*/, char* /*argv*/ [])
{
  TBIVbxLibrary vbxLib;     // constructing this loads & inits the library
  //
  // Application characteristics and function.
  //
  return SaxTermApp().Run();
}

