/*  Project vbx

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    vbx.exe Application
	 FILE:         vbxmdich.cpp
	 AUTHOR:


	 OVERVIEW
	 ========
	 Source file for implementation of vbxMDIChild (TMDIChild).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "vbxapp.h"
#include "vbxmdich.h"

#include <stdio.h>

const int IDC_STYLE= 200;
const int IDC_ALARMSET= 201;
const int IDC_MHCLOCK= 202;
//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE2(vbxMDIChild, TMDIChild, TVbxEventHandler)
//{{vbxMDIChildRSP_TBL_BEGIN}}
	EV_VBXEVENTINDEX( IDC_MHCLOCK, Event_MhClock_Alarm, EvAlarm ),
	EV_BN_CLICKED(IDC_STYLE, OnClickedStyle),
	EV_BN_CLICKED(IDC_ALARMSET, OnClickedAlarmSet),
	EV_WM_ERASEBKGND,
//{{vbxMDIChildRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{vbxMDIChild Implementation}}

//////////////////////////////////////////////////////////
// vbxMDIChild
// ==========
// Construction/Destruction handling.
vbxMDIChild::vbxMDIChild (TMDIClient &parent, const char far *title, TWindow *clientWnd, BOOL shrinkToClient, TModule *module)
	 : TMDIChild (parent, title, clientWnd, shrinkToClient, module)
// AppExpert assumes that an MDI app is a text window, but we need a graphical base
// so we change the code to reflect that in our vbxMDIchild class
{
	 // INSERT>> Your constructor code here.
	VbxMhClock = new TVbxMhClock( this,
											IDC_MHCLOCK,
											"Test Clock",
											200,
											200,
											100,
											100,
											sizeof(MhClockData),
											MhClockData);
	beenheredoneit=FALSE;
	Style  = new TButton(this, IDC_STYLE,"Style",100,10,100,30,FALSE);
	AlarmSet = new TButton(this, IDC_ALARMSET,"Minute Change Alarm",100,80,200,30,FALSE);
}


vbxMDIChild::~vbxMDIChild ()
{
	Destroy();

	// INSERT>> Your destructor code here.
	delete VbxMhClock;

}

BOOL vbxMDIChild::EvEraseBkgnd (HDC dc)
{
	BOOL result;
	TDC dC(dc);                    //dc class for usage in painting
	result = TMDIChild::EvEraseBkgnd(dc);

	// INSERT>> Your code here.
	if(!beenheredoneit)
	{
	VbxMhClock->SetPropStyle(0);
	VbxMhClock->SetPropFontStyle(2);
	beenheredoneit=TRUE;                   //one time initialization is finished
	}

	// Move must use twips instead of pixels.
	TRect			windowSize			=	GetClientRect();      //get window coordinates
	TColor color(192,192,192);                                 //get gray color
	dC.SetBkColor(color);
	TBrush brush(color);                                   //make a gray brush
	TRect rect;                                            //define a rectangle class object
	dC.GetClipBox(rect);                                   //get the window's coords
	dC.FillRect(rect,brush);

	VbxMhClock->Move(	1440,  	 									//1 inch over
							1440/2,   									//1/2 inch down
							VBXPix2TwpX(100),                   //x size
							VBXPix2TwpY(50));                   //y size

	Style->MoveWindow(VBXTwp2PixX(1440/4),                //move the buttons too
							VBXTwp2PixY(1440*2),
					      100,30,TRUE);

	AlarmSet->MoveWindow(VBXTwp2PixX(1440*1.5),
								VBXTwp2PixY(1440*2),
								200,30,TRUE);
								
	return result;
}

void vbxMDIChild::EvAlarm(VBXEVENT FAR*)
	 {
		VbxMhClock->SetPropAlarmMinute(-1);
		MessageBox("The Alarm is fired!","ALARM !!!");
	 }

void vbxMDIChild::OnClickedStyle()
{
	TRect			windowSize			=	GetClientRect();
	ENUM CurrentVbxStyle;
	VbxMhClock->GetPropStyle(CurrentVbxStyle);
	CurrentVbxStyle+=1;
	if(CurrentVbxStyle>7)
		CurrentVbxStyle=0;
	if(CurrentVbxStyle>3)
		{
		 VbxMhClock->Move(1440,										//1 inch over
								1440/2, 									//1/2 inch down
								VBXPix2TwpX(100),                //x size
								VBXPix2TwpY(100));               //y size
		}
	else
		{
		 VbxMhClock->Move(1440,										//1 inch over
								1440/2,  								//1/2 inch down
								VBXPix2TwpX(100),                //x size
								VBXPix2TwpY(50));                //y size
		}
	VbxMhClock->SetPropStyle(CurrentVbxStyle);
}

void vbxMDIChild::OnClickedAlarmSet()
{
	VbxMhClock->GetPropHour(Hour);
	VbxMhClock->GetPropMinute(Minute);
	VbxMhClock->GetPropSecond(Second);
	AHour=-1;
	AMinute=Minute+1;
	ASecond=-1;
	VbxMhClock->SetPropAlarmHour(AHour);
	VbxMhClock->SetPropAlarmMinute(AMinute);
	VbxMhClock->SetPropAlarmSecond(ASecond);
	MessageBox("The Alarm will fire when the minute changes!!!","Message");
	}


