/*  Project vbx
    
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    vbx.exe Application
    FILE:         vbxmdicl.cpp
    AUTHOR:       


    OVERVIEW
    ========
    Source file for implementation of vbxMDIClient (TMDIClient).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <dir.h>

#include "vbxapp.h"
#include "vbxmdicl.h"
#include "vbxmdich.h"


//{{vbxMDIClient Implementation}}


//
// Build a response table for all messages/commands handled
// by vbxMDIClient derived from TMDIClient.
//
DEFINE_RESPONSE_TABLE1(vbxMDIClient, TMDIClient)
//{{vbxMDIClientRSP_TBL_BEGIN}}
	 EV_COMMAND(CM_MDIFILENEW, CmFileNew),
//{{vbxMDIClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// vbxMDIClient
// ===========
// Construction/Destruction handling.
 vbxMDIClient::vbxMDIClient ()
 : TMDIClient ()
{
	 // Change the window's background color
	 SetBkgndColor(RGB(0xc0, 0xc0, 0xc0));

	 ChildCount = 0;

	 // INSERT>> Your constructor code here.

}


 vbxMDIClient::~vbxMDIClient ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.

}

//////////////////////////////////////////////////////////
// vbxMDIClient
// ===========
// Menu File New command
void vbxMDIClient::CmFileNew ()
{
	 char    title[255];

	 // Generate a title for the MDI child window.
	 wsprintf(title, "%d", ChildCount++);

	 vbxMDIChild* child = new vbxMDIChild(*this, title, 0);

	 // Associate ICON w/ this child window.
	 child->SetIcon(GetApplication(), IDI_DOC);

	 // If the current active MDI child is maximize then this one should be also.
	 vbxMDIChild *curChild = (vbxMDIChild *)GetActiveMDIChild();
	 if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
		  child->Attr.Style |= WS_MAXIMIZE;

	 child->Create();
}

