/*  Project vbx

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    vbx.exe Application
	 FILE:         vbxmdich.cpp
	 AUTHOR:


	 OVERVIEW
	 ========
	 Source file for implementation of vbxMDIChild (TMDIChild).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "vbxapp.h"
#include "vbxmdich.h"

#include <stdio.h>

const int IDC_STYLE= 200;
const int IDC_RINGON= 201;
const int IDC_MHALARM= 202;
//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE2(vbxMDIChild, TMDIChild, TVbxEventHandler)
//{{vbxMDIChildRSP_TBL_BEGIN}}
	EV_VBXEVENTINDEX( IDC_MHALARM, Event_MhIAlarm_Click, EvClick ),
	EV_BN_CLICKED(IDC_STYLE, OnClickedStyle),
	EV_BN_CLICKED(IDC_RINGON, OnClickedRingState),
	EV_WM_ERASEBKGND,
//{{vbxMDIChildRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{vbxMDIChild Implementation}}

//////////////////////////////////////////////////////////
// vbxMDIChild
// ==========
// Construction/Destruction handling.
vbxMDIChild::vbxMDIChild (TMDIClient &parent, const char far *title, TWindow *clientWnd, BOOL shrinkToClient, TModule *module)
	 : TMDIChild (parent, title, clientWnd, shrinkToClient, module)
// AppExpert assumes that an MDI app is a text window, but we need a graphical base
// so we change the code to reflect that in our vbxMDIchild class
{
	 // INSERT>> Your constructor code here.
	VbxMhAlarm = new TVbxMhIAlarm( this,
											IDC_MHALARM,
											"Test Alarm",
											200,
											200,
											64,
											64,
											sizeof(MhIAlarmData),
											MhIAlarmData);
	beenheredoneit=FALSE;
	Style = new TButton(this, IDC_STYLE,"Style",200,10,100,30,FALSE);
	RingOn = new TButton(this, IDC_RINGON,"Ring State",200,80,100,30,FALSE);
}


vbxMDIChild::~vbxMDIChild ()
{
	Destroy();

	// INSERT>> Your destructor code here.
	delete VbxMhAlarm;

}

void vbxMDIChild::EvClick(VBXEVENT FAR*)
	 {
		MessageBox("You clicked the control!","Message");
	 }

BOOL vbxMDIChild::EvEraseBkgnd (HDC dc)
{
	BOOL result;
	TDC dC(dc);                    //dc class for usage in painting
	result = TMDIChild::EvEraseBkgnd(dc);

	// INSERT>> Your code here.
	if(!beenheredoneit)
	{
	VbxMhAlarm->SetPropStyle(0);

	beenheredoneit=TRUE;                   //one time initialization is finished
	}

	// Move must use twips instead of pixels.
	TRect			windowSize			=	GetClientRect();      //get window coordinates
	TColor color(0,255,0);                                 //get green color

	dC.SetBkColor(color);
	TBrush brush(color);                                   //make a green brush

	TRect rect;                                            //define a rectangle class object
	dC.GetClipBox(rect);                                   //get the window's coords
	dC.FillRect(rect,brush);
	VbxMhAlarm->Move(	1440*1.25, 									//1-1/4 inches over
							1440,  										//1 inch down
							VBXPix2TwpX(64),                 	//x size
							VBXPix2TwpY(64));                	//y size

	Style->MoveWindow(VBXTwp2PixX(1440/4),               	//move the buttons too
							VBXTwp2PixY(1440*2),
							100,30,TRUE);

	RingOn->MoveWindow(VBXTwp2PixX(1440*1.5),
							 VBXTwp2PixY(1440*2),
							 100,30,TRUE);

	char strbuf[255];
	wsprintf(strbuf, "Click on the Alarm control to force a ring.");
	dC.TextOut(10, 30, strbuf, strlen(strbuf));

	if(CurrentVbxRingOn==2)
	  wsprintf(strbuf, "The Ring State is set to Continuous.");
	else
	  wsprintf(strbuf, "The Ring State is set to Off.                 ");

	dC.TextOut(10, 10, strbuf, strlen(strbuf));

	return result;
}

void vbxMDIChild::OnClickedStyle()
{
	ENUM CurrentVbxStyle;
	VbxMhAlarm->GetPropStyle(CurrentVbxStyle);
	CurrentVbxStyle+=1;
	if(CurrentVbxStyle>2)
		CurrentVbxStyle=0;
	VbxMhAlarm->SetPropStyle(CurrentVbxStyle);
}

void vbxMDIChild::OnClickedRingState()
{
	char strbuf[255];

	TClientDC dc(*this);
	TColor color(0,255,0);
	dc.SetBkColor(color);
	VbxMhAlarm->GetPropRingOn(CurrentVbxRingOn);

	if(CurrentVbxRingOn==0)
		{
		CurrentVbxRingOn=2;
		wsprintf(strbuf, "The Ring State is set to Continuous.");
		}
	else
		{
		CurrentVbxRingOn=0;
		wsprintf(strbuf, "The Ring State is set to Off.               ");
		}
	dc.TextOut(10, 10, strbuf, strlen(strbuf));

	VbxMhAlarm->SetPropRingOn(CurrentVbxRingOn);
}

