/******************************************************************

Description:    IBM Image Support Run Exec.

Details:        This exec sets up the appropriate IBM OS/2 Image
                Support defaults.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    Always use same drive.
   Directories: DLLs and EXEs in current directory.
   Window Type: FS/Win
   App Title:   OS/2 Image Support

Last Updated:   9/9/91
******************************************************************/
 trace 'O'
 '@echo off'

/* Set up the PATH and LIBPATH strings */
 parse source . . exec
 Odr=left(exec, lastpos('\', exec))
 OS2='OS2ENVIRONMENT'

 say; say 'Setting up IBM OS/2 Image Support environment for this session...'

 oldpath = value('PATH',,OS2)
 newpath = Odr';'oldpath
 olddpath = value('DPATH',,OS2)
 newdpath = Odr';'olddpath
 oldhelp = value('HELP',,OS2)
 newhelp = Odr'HELP;'oldhelp
 oldlib  = value('LIB',,OS2)
 newlib  = Odr'LIB;'oldlib
 oldinc  = value('INCLUDE',,OS2)
 newinc  = Odr'INCLUDE;'oldinc

 call value 'PATH',      newpath,  OS2
 call value 'DPATH',     newdpath, OS2
 call value 'HELP',      newhelp,  OS2
 call value 'LIB',       newlib,   OS2
 call value 'INCLUDE',   newinc,   OS2
 say 'Done'; say

/** Run OIS **/
 say
 say ' Starting OS/2 Image Support...'
 say
 say ' Please wait a moment while OS/2 Image Support is loaded.'
 say '       ( This may take a short while )'
 say
 say ' This window will be hidden after OS/2 Image Support is started...'
 'START HIDEWIN /D=20 OS/2 Image Support'
 'OIS'

'exit 0'
