; Template file: QUERY.APL
; Type         : AreaMgr
;
; This template generates a three different lists:
;
; 1 - A list of all the fileechos a system only receives files in.
; 2 - A list of all the fileechos a system only sends files in,
; 3 - A list of all the fileechos a system both sends and receives files in.
;
@assign(@bcount,0)
@assign(@count,0)

@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"+")
@test(@doneheader,=,"No")
  Your system receives files from our system for the following fileechos:

  File echo     Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count file echo(s)
@end

@assign(@count,0)

@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"*")
@test(@doneheader,=,"No")
  Our system receives files from your system for the following fileechos:

  File echo     Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count file echo(s)
@end

@assign(@count,0)

@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"&")
@test(@doneheader,=,"No")
  We both send files to each other for the following fileechos:

  File echo     Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count file echo(s)
@end

@test(@bcount,=,0)
  You are not connected to any file echos.
@end

--- ALLFIX @prgversion
 * Origin: use %HELP for help using the AreaMgr in ALLFIX (@akatouse)
