
CAE/DOS v1.2 (IP20429) & SDK/DOS v1.2 (IP20431) Service Paks
============================================================

                Welcome to DOS/Windows DB2 Clients

- DB2 Client Application Enabler/DOS (CAE/DOS) v1.2
- DB2 Software Developers's Kit/DOS (SDK/DOS) v1.2

Please see section 1.2 for Service Pak install information

Service Pak IP20429 should be used to update clients that were
installed using CAE/DOS v1.2 product diskettes.

Service Pak IP20431 should be used to update clients that were
installed using SDK/DOS v1.2 product diskettes.

PART 1 of this file contains important information about these Service Paks.
It includes installation instructions and details changes to the product
since the shipping of Service Paks IP20252 and IP20253.  IP20429 and
IP20431 are cumulative Service Paks and contain all code changes since the
initial product was released.

PART 2 contains information about the first Service Paks IP20252 and
IP20253 shipped for these products.  It also describes support for
Memory Extenders, Microsoft(TM) Visual C++ v1.5 Professional Edition
(C compiler only).

NOTE (1):  If an existing version of CAE/DOS or SDK/DOS is executing it
should be stopped before applying the Service Pak.

NOTE (2):  After installation is complete, you will need to re-bind your
databases.  Refer to section 1.2.3.1 for details.

NOTE (3):  If you have received private fixes from IBM Support after
95/05/04, then you should contact IBM support after the Service Pak
installation to request an updated version of the private fixes.  By
doing this, you are assured that your system is in a consistent state
and no private fixes are lost.

========
Contents

1.0 PART 1 - Service Pak IP20429 & IP20431, May 1995
1.1 Introduction
1.2 Information for installing this Service Pak
  1.2.1  Pre-Requisites
  1.2.2  Installation Instructions
  1.2.3  After Installation (IMPORTANT)
    1.2.3.1  Rebinding Bind Files
1.3 General Information
  1.3.1 Service Information (U.S.A / Canada)
    1.3.1.1 CAE/DOS and SDK/DOS Support
    1.3.1.2 Electronic Customer Support and Corrective Service
    1.3.1.3 Accessing Corrective Service and Customer Support
  1.3.2 The DB2 Family Newsletter
  1.3.3 Submitting Suggestions to IBM
1.4 Defects Fixed
  1.4.1 CAE/DOS & SDK/DOS APAR descriptions
    1.4.1.1 APAR IC08974: Table name alias on AS/400
    1.4.1.2 APAR IC09071: Yield on server connect using IPX/SPX
    1.4.1.3 APAR IC09438: ODBC accessing graphic columns
    1.4.1.4 APAR IC09868: ODBC collections on AS/400
    1.4.1.5 APAR IX46959: ODBC inconsistent result set
    1.4.1.6 APAR JR08276: ODBC NULL parameters for column name
    1.4.1.7 APAR JR08456: Server interrupts with downlevel clients
  1.4.2 Other CAE/DOS & SDK/DOS Fixes
    1.4.2.1 Logon Security


2.0 PART 2 - Service Pak IP20252 & IP20253, January 1995
2.1 Defects Fixed
  2.1.1 CAE/DOS & SDK/DOS APAR descriptions
    2.1.1.1 APAR IC07930: Unequal Code Page Support
    2.1.1.2 APAR IC08006: Lotus Query Fails
    2.1.1.3 APAR IC08044: Detach from Novell Fileserver
    2.1.1.4 APAR IC08045: Trailing Blanks ODBC Driver
    2.1.1.5 APAR IC08183: ODBC Driver, SQL0199
    2.1.1.6 APAR IC08287: DBCS ODBC/CLI Statement scanner "{" (Ox7B)
    2.1.1.7 APAR IC08581: TCP/IP gives up control in Socket call
    2.1.1.8 APAR IX46939: TCP/IP is NON-BLOCKING
    2.1.1.9 APAR JR08119, JR08271: MSQUERY (Microsoft Office) Query Fails
  2.1.2 Other CAE/DOS & SDK/DOS Fixes
    2.1.2.1 Fetching CHAR column with NULL entry
    2.1.2.2 SQLWindows
    2.1.2.3 Query for SQL/DS
2.2 IBM DB2 CAE/DOS & SDK/DOS support for DOS Memory Extenders
  2.2.1  Installation Notes
    2.2.1.1  Software Requirements
    2.2.1.2  Hardware Requirements
    2.2.1.3  Installation of new versions of DB2.EXE
  2.2.2  Usage Notes
    2.2.2.1  Using XM and Micro Focus COBOL
    2.2.2.2  Using Blinker and Microsoft C
    2.2.2.3  Linker Changes Required for All Users of this ServicePak
2.3 Microsoft(TM) Visual C++ v1.5 Professional Edition (C compiler only)
    Support for DB2 Client/Server
  2.3.1  Installation Notes
    2.3.1.1  Recommended Software Installation Sequence
    2.3.1.2  Installation Directories
    2.3.1.3  Configuration of Command Line Tools for DOS
    2.3.1.4  Setup File MSVCVARS.BAT and INCLUDE Path
  2.3.2  Usage Notes
    2.3.2.1  Application Stack Overflow
    2.3.2.2  RW4005 Resource Compiler Error
    2.3.2.3  Modifications to Build and Run Sample Programs
    2.3.2.4  ODBC vs DB2 Embedded SQL Applications
    2.3.2.5  DB2 Call Level Interface Applications
    2.3.2.6  Other Recommended Compiler and/or Link Options
  2.3.3  Changes to Documentation
    2.3.3.1  Programming Guide
2.4  Helpful hints for taking traces
  2.4.1  Avoiding Zero (0) byte Trace files



1.0 PART 1 - Service Pak IP20429 & IP20431, May 1995

1.1 Introduction

This Service Pak provides fixes to problems reported since the initial
release of the products.  The effects and descriptions of these changes
is the subject of the following topics.


1.2 Service Pak Installation

See sections 2.2.1, 2.3.1 for additional installation information.

1.2.1  Pre-Requisites

The CAE/DOS Service Pak can be applied to the following level of CAE/DOS v1.2
  - CAE/DOS v1.2.0  (GOLD, level WR07000)
  - Service Pak IP20252 (level IPx20252)
  - CAE/DOS v1.2.1 Refresh Code (level IPx20252)

The SDK/DOS Service Pak can be applied to the following level of SDK/DOS v1.2
  - SDK/DOS v1.2.0  (GOLD, level WR07000)
  - Service Pak IP20253 (level IPx20253)
  - SDK/DOS v1.2.1 Refresh Code (level IPx20253)

(where letter 'x' in the db2lvl indicates the country code for this
 Service Pak:

       Country         x

       U.S.A           0
       France          F
       Italy           I
       Germany         G
       Japan           J
       Spain           S )

NOTE:  This Service Pak cannot be applied to any version of DB2/2,
       PC DOS/Windows Clients.  This product has a separate Service Pak.


1.2.2  Installation Instructions

To start the Service Pak install, type INSTALL on a command line.

Ensure that the Environment variable DB2PATH is set to the path where
CAE/DOS v1.2 or SDK/DOS v1.2 is installed on your system.


1.2.3  After Installation (IMPORTANT)
1.2.3.1  Rebinding Bind Files

Due to new bind (.BND) files that have been shipped with this Service Pak,
you will need to rebind databases on the DB2 server by issuing the
following command:

- At the Client DOS prompt:
       db2 BIND <path>\@db2ubind.lst BLOCKING ALL
or

- At the Client DB2 command line:
       BIND <path>\@db2ubind.lst BLOCKING ALL

Where <path> is the full path name of the directory where the bind
files are located, such as \sqllib\bnd\.  DB2UBIND.LST is the file
containing the list of all bind files for CAE/DOS or SDK/DOS.

You will also need to rebind databases on the Host by issuing the
following command:

- At the Client DOS prompt:
       db2 BIND <path>\@ddcsbind.lst BLOCKING ALL
or

- At the Client DB2 command line:
       BIND <path>\@ddcsbind.lst BLOCKING ALL

Where <path> is the full path name of the directory where the bind
files are located, such as \sqllib\bnd\.  DDCSBIND.LST is the file
containing the list of all bind files for CAE/DOS or SDK/DOS.

For the DOS/Windows client, the following are the package names for
which RUN authority must be provided:

 SQLAB4B0                        SQLUF4B0
 SQLC24B0                        SQLUG4B0
 SQLC34B0                        SQLUH4B0
 SQLC44B0                        SQLL14B1 **
 SQLUA4B0                        SQLL24B1 **
 SQLUB4B0                        SQLL34B1 **
 SQLUC4B0                        SQLL44B2 ** *
 SQLUD4B0                        SQLL54B2 ** *
 SQLUE4B0                        SQLL64B3 ** *

*  indicates package names that have changed due to this Service Pak
** indicates package names that have changed in previous Service Pak(s).

For further information concerning binding, please refer to
DATABASE 2 Client Application Enabler/DOS - Users Guide,
Version 1.2. (pages 32-34).


1.3 General Information
1.3.1  Service Information (U.S.A / Canada)
1.3.1.1 CAE/DOS and SDK/DOS Support

Call 1-800-992-4777 for information regarding free and chargeable
service options or to receive assistance on

- IBM Client Application Enabler/DOS (CAE/DOS) Version 1.2

- IBM Software Developer's Kit/DOS (SDK/DOS) Version 1.2


Assistance is also available using the electronic options described below.


1.3.1.2 Electronic Customer Support and Corrective Service

The following electronic support is available:

Customer support is provided via a questions-and-answers (Q&A) forum
provided by the DB2/2 Service Team.  The forum is accessible
through CompuServe, IBMLink, and TALKLink as described below.

Corrective Service is provided by Service Paks.  A Service Pak contains
all fixes that have accumulated since the product first became generally
available.

Service Paks will be issued approximately every 3 to 4 months
depending on the number, severity and visibility of fixes that have
accumulated.

If you cannot obtain these Service Paks electronically please
call 1-800-992-4777 to request them to be sent to you in the mail.


1.3.1.3  Accessing Corrective Service and Customer Support

CompuServe - call 1-800-848-8199 in Canada or the US for membership information.
 -Execute GO IBMDB2.
 -Use CLIENTS section for questions and answers.
 -Use CLIENTS library for fixes and other files.

US (IBMLink) TALKLINK OS/2 BBS call 1-800-547-1283 for membership information.
 -Go to OS2BBS in TALKLINK.
 -Choose Service Package section (Corrective Service only).
 -Access DB2OS2 FORUM (Q&A and Technical Support).

Canadian IBMLink OS/2 BBS - call 905-474-6666 or 1-800-268-3100 for
membership information.
 -Go to IBMLink from the IIN Menu.
 -Type ICONF on the IBMLink Desktop.
 -Select View from the Conference File Selection List.
 -Select Option 5 Select Files and type: WR* * (NOTE: these two asterisks are
  wildcards) (Corrective Service only).
 -Select DB2OS2 FORUM (Q&A and Technical Support).

The Service Paks are also available on the Technical Connection CD ROM.
To order call 1-800-992-4777.


The next methods are available for Corrective Service only.

Internet.
 -FTP to anonymous server ps.boulder.ibm.com (198.17.57.66)
 -Enter 'anonymous' as the userid and your complete e-mail address as the
  password.
 -Go to ps/products/db2/fixes

NOTE: The ps.boulder.ibm.com FTP site contains Corrective Service
for all languages supported by the family of DB2 workstation products.

 OR

 -FTP to anonymous server software.watson.ibm.com (129.34.139.5)
 -Enter 'anonymous' as the userid and your complete e-mail address as the
  password.
 -Go to pubs/db2/os2 directory.


Canadian IBM PS BBS - to dial into the BBS call 905-316-4255 Toronto,
416-492-1823 Toronto, 514-938-3022 Montreal, or 604-664-6464 Vancouver
(8 databits, no parity, 1 stop bit).
 -Go to area 34 OS/2 Database and Host.

US IBM PCC BBS - to dial into this BBS, call 919-517-0001 Raleigh (8 databits,
no parity, 1 stop bit).
 -Go to Directory 4 (the CSD Directory).


1.3.2 The DB2 Family Newsletter

This is a bi-monthly newsletter that reports the latest news for the family
of DB2 products (DB2 and DDCS on all available platforms: OS2, AIX, MVS...)

If you are interested in receiving this newsletter, please mail or fax
your request to

 IBM Canada Ltd.
 c/o Tina Kocevski
 Grenville Management & Printing
 25 Scarsdale Rd.
 Don Mills, Ontario
 Canada M3B 2R2

 Fax:  (416) 449-4119


1.3.3 Submitting Suggestions to IBM

If you have any suggestions to enhance our products, there are two
vehicles to communicate your requirements to IBM.

* If your organization has an IBM representative, discuss your
  requirements with your IBM representative, and have them submit your
  requirements to the DATABASE TECHNOLOGY group at TOROLAB2(DBMREQ).

* Or, send your detailed comments/suggestions to the following address:

  IBM Canada Ltd.
  c/o Tina Kocevski
  Grenville Management & Printing
  25 Scarsdale Rd.
  Don Mills, Ontario
  Canada M3B 2R2

  Fax:  (416) 449-4119


1.4 Defects Fixed

This section describes changes that have been made to the product
as a result of direct customer feedback. The descriptions contained in
this section are for the fixes that have gone into the product since
CAE/DOS Service Pak IP20252 (level IPx20252) and SDK/DOS Service
Pak IP20253 (level IPx20253) was shipped.

1.4.1 CAE/DOS & SDK/DOS APAR descriptions

1.4.1.1 APAR IC08974: Table name alias on AS/400

Previously the CAE/DOS client did not support the use of SYNONYM on
an AS/400.  This problem has been fixed, and will require that you
rebind your databases.


1.4.1.2 APAR IC09071: Yield on server connect using IPX/SPX

Previously the DOS client, using IPX/SPX, would wait indefinitely
for a response from a DB2/2 server that was not found.  This caused
the CPU to yield all other Windows applications that were running.
The problem has been fixed.


1.4.1.3 APAR IC09438: ODBC accessing graphic columns

Previously, ODBC applications using the DOS client may have returned
corrupted characters or trapped when accessing graphic columns in DB2
databases.  This problem has been fixed.


1.4.1.4 APAR IC09868: ODBC collections on AS/400

To access any collection in an AS/400 the keyword SYSOWNER, found in the
ODBC.INI file, should be set to the name of the collection.  This was
not being retrieved properly, but has now been resolved.


1.4.1.5 APAR IX46959: ODBC inconsistent result set

Previously, if the ODBC API SQLStatistics was called more than once
the second attempt would not return any information.  This fix
corrects the problem.


1.4.1.6 APAR JR08276: ODBC NULL parameters for column name

Previously, the SQLDESCRIBECOL API did not allow NULL parameters
for the column name.  This fix corrects the problem.


1.4.1.7 APAR JR08456: Server interrupts with downlevel clients

Previously an interrupt issued from a CAE/DOS v1.2, or SDK/DOS v1.2
client against a DB2/2 v2.1 (beta) or DB2/6000 v2.1 (beta) server was
ignored when using the NETBIOS or IPX/SPX communications protocols.
This fix corrects the problem.


1.4.2 Other CAE/DOS & SDK/DOS Fixes

1.4.2.1 Logon Security

This feature was previously found in the DB2/2 v1.2 DOS/Windows client
when the commands SQLLOGN2.EXE and SQLLOGF2.EXE were used.  The CAE/DOS
and SDK/DOS products previously had these commands, but no action was
performed on the information entered.  This has been fixed, and these
commands now work with the following syntax:

   (a) Just type SQLLOGN2 and let the program prompt you for userid and
       password.
or (b) Type "SQLLOGN2 userid" , no password is prompted
or (c) Type "SQLLOGN2 userid *" , let the program prompt for password
or (d) Type "SQLLOGN2 userid /p=password"

 NOTE: In using (d), the password will be displayed on the screen.

Prior to the changes made to SQLLOGN2.EXE and SQLLOGF2.EXE, the
userid and password were stored in one of 3 methods:

 1) The environment variables DB2USERID and DB2PASSWORD.
 2) Supply userid and password in .INI files. (ODBC applications)
 3) Provide userid and password everytime a connection to a database
    was made.

  Hints and Tips:

 When using the commands SQLLOGN2 and SQLLOGF2 please be aware of the
 following features:

 1) In the DB2/2 DOS/Windows client, SQLLOGN2 and SQLLOGF2 converted
    the userid and password to uppercase, since it only connected to
    DB2/2 and the OS/2 UPM (user profile management) only accepted
    uppercase userid and passwords.  With the CAE/DOS and SDK/DOS clients
    the userid and password are kept as mixed case for connecting to
    other platforms, such as DB2/6000.

 2) SQLLOGN2.EXE in the DB2/2 DOS/Windows client checked the syntax
    of the userid and password that it was supplied (ie. the first
    character was not a number).  The SQLLOGN2.EXE that is supplied
    with CAE/DOS and SDK/DOS does not check the userid and password.

 3) The userid and password are limited to 8 characters in length.

 4) CAE/DOS and SDK/DOS still supports the original 3 methods of
    providing a userid and password to the server.

 The order of priority that is followed is:

 For non-ODBC applications:

   1) logon via SQLLOGN2.EXE has highest priority

   2) if logon is not performed via SQLLOGN2.EXE, then the environment
      variables DB2USERID and DB2PASSWORD are queried.


 For ODBC applications

   1) ODBC-specific logon procedures have the highest priority.
      (ie. userid and password are stored in ODBC .INI files)

   2) If logon is not performed via 1), then userid and password
      are retrieved from the information stored from SQLLOGN2.EXE.

   3) If logon is not performed via 1) or 2), then the environment
      variables DB2USERID and DB2PASSWORD are queried.



2.0 PART 2 - Service Pak IP20252 & IP20253, January 1995

2.1 Defects Fixed

This section describes changes that have been made to the product
as a result of direct customer feedback. The descriptions contained in
this section are for the fixes that have gone into the product since
CAE/DOS v1.2.0 (GOLD, level WR07000) and SDK/DOS v1.2.0 (GOLD,
level WR07000) was shipped.


2.1.1 CAE/DOS & SDK/DOS APAR descriptions

2.1.1.1 APAR IC07930: Unequal Code Page Support

This fix adds unequal code page support for European countries to the
ODBC drivers.  Users can now connect Windows CAE/DOS v1.2.0 clients to
DB2/2 servers and through DDCS/2 to host databases.  There had been
no support for unequal code pages in the DB2/2 and DDCS/2 products.

The codepage conversions that were required were between the following
codepages:

        Server      Client
        ------      ------
        437          819 (1004 in Windows)
        850          819 (1004 in Windows)

To invoke unequal codepage support:
1. Re-run DB2ODBC.EXE from the FILE pulldown menu on the windows desktop
2. Re-bind packages (section 1.2.3.1 of this file)
3. EDIT ODBC.INI, add to specific data source entry the following:

       TranslateDLL=x:\path\db2trans.dll
       TranslateOption=y
          (where x:\path\ is value of DB2PATH, and y is 850 or 437)


2.1.1.2 APAR IC08006: Lotus Query Fails

While connected to DB2/6000, the client did not handle code page
specific queries from Lotus correctly.  This fix corrects the problem.

2.1.1.3 APAR IC08044: Detach from Novell Fileserver

Previously, after the CAE/DOS client attached to the Novell
fileserver to read the bindery object containing the network address
of the OS/2 DB2/2 server, the client did not subsequently detach from
the fileserver.  This fix corrects the problem.  Now, after reading the
bindery object, the client remains attached only if had been previously
attached to the fileserver, otherwise it detaches from the fileserver.

2.1.1.4 APAR IC08045: Trailing Blanks ODBC Driver

Previously, the ODBC driver passed trailing blanks in delimited
identifiers, causing a syntax error in SQL/DS.  This fix corrects
the problem, the trailing blanks have been eliminated.

2.1.1.5 APAR IC08183: ODBC Driver, SQL0199

The ODBC driver placed a scalar function in a VALUE statement, which
produced an SQL statement that was not valid for DB2/2 v1.1 or v1.2.  This
resulted in the error SQL0199, "The use of reserved word '<keywords>'
following '<text>' is not valid.  Expected tokens may include:
'<token-list>'".   This fix corrects the problem.

2.1.1.6 APAR IC08287: DBCS ODBC/CLI Statement scanner "{" (Ox7B)

For Double-Byte countries (ie. Japan), the CLI/ODBC statement scanner
did not recognize the character "{" (0x7B) as the second byte of a
double byte character.  This fix corrects the problem.

2.1.1.7 APAR IC08581: TCP/IP gives up control in Socket call

TCP/IP gives up control of the CPU in a socket call, allowing
concurrent multiple database connections, which can not be handled
by CAE/DOS.  We have replaced the default blocking hook routine with
a non-yielding blocking hook routine.  With this fix, the underlying
winsock will not yield.

2.1.1.8 APAR IX46939: TCP/IP is NON-BLOCKING

The send function of TCP/IP is NON-BLOCKING, meaning that we are
unable to verify that the entire buffer will all be sent in one
send call.  This resulted in the client hanging.  This fix corrects
the problem by checking for partial sends.

2.1.1.9 APAR JR08119, JR08271: MSQUERY (Microsoft Office) Query Fails

When constructing SQL statements with MSQuery (Microsoft office)
there was a missing space in the statement causing an unexpected token
error.  This fix corrects the problem.


2.1.2 Other CAE/DOS & SDK/DOS Fixes

2.1.2.1 Fetching CHAR column with NULL entry

Previously, if a buffer was bound twice, and a NULL entry from a
CHAR column was fetched, it would generate an SQL error on
the second fetch.  This fix corrects the problem.  Below is an
example of the Scenario:

   SQLExecDirect( hStmt, "select c from t", SQL_NTS );
   SQLBindCol( hStmt, 1, SQL_C_CHAR, ... );
   SQLFetch( hStmt );  /* Non null value */
   SQLBindCol( hStmt, 1, SQL_C_CHAR, ... );
   SQLFetch( hStmt );  /* Null value returns SQL_ERROR */

2.1.2.2 SQLWindows

Previously, when using SQLWindows, SQLGetTypeInfo would return an
empty set instead of S1C00.  This fix corrects the problem.

2.1.2.3 Query for SQL/DS

Previously, when connected to an SQL/DS server the SQLSpecialColumns Query
resulted in a syntax error.  This fix corrects the problem.


2.2 IBM DB2 CAE/DOS & SDK/DOS support for DOS Memory Extenders

Support for DOS memory extenders has been added for the following products:

- DB2 Client Application Enabler/DOS v1.2
- DB2 Software Developer's Kit/DOS v1.2

The objective of this support is to allow DOS-based applications that
access DB2 to take advantage of extended memory.  Memory extenders
that have been tested with Client Application Enabler/DOS are listed
in section 2.2.1.1.  The libraries provided for the Software
Developer's Kit/DOS are now protected-mode compatible.  You can
develop protected-mode DOS programs with these libraries, using a
16-bit DOS extender that supports DPMI (DOS protected mode interface)
calls.  IBM has tested these libraries with XM (for developing Micro
Focus COBOL programs), Blinker, and Phar Lap 286 DOS-Extender.

Specific instructions for developing applications with the products
Blinker (for developing applications with Microsoft C) and XM (for
developing applications with Micro Focus COBOL) are also provided.

Most of the material in this section concerns only SDK/DOS users.
For Client Application Enabler/DOS users, the only practical
difference is a new version of the Command Line Processor, DB2.EXE.
This is a protected mode version of the Command Line Processor that
can be installed on client workstations with memory constrained by
DOS's limit of 640K of addressable memory.


2.2.1  Installation Notes
2.2.1.1  Software Requirements

The following DOS memory managers and extenders have been tested with
this ServicePak for the DB2 DOS Client:

Memory Managers
---------------

    IBM DOS v5.0 and later (with HIMEM.SYS)
    Windows v3.1
    Qualitas BlueMAX v7.00
    Quarterdeck Enhanced Memory Manager v7.04 (QEMM)
    note: QEMM 7.03 or earlier will not work

If you are developing DOS extended applications using Micro Focus
COBOL with XM, you must use a memory manager that provides DPMI
support.  HIMEM.SYS and EMM386.EXE do not provide DPMI support.  QEMM
and the DOS session support in Windows and OS/2 do provide DPMI
support.

Memory Extenders
----------------

    Blinker v3.01 by Blink, Inc.
    Phar Lap 286 Dos-Extender
    XM v1.4.6 from Micro Focus COBOL v3.2.20

This ServicePak also ships a new version of DB2.EXE, the command line
processor used by DB2 DOS Clients.  The old version is still shipped,
and can be used unless you are having memory-related problems with the
command line processor.  The new version of DB2.EXE requires one of
the memory managers listed above.

The new version of DB2.EXE should be used with Novell NetWare IPX/SPX.
It can also be used with other communications protocols when the DOS
memory manager is QEMM, Blue Max, or DOS's HIMEM.SYS.  When running in
the DOS box under Windows or OS/2, the new version of DB2.EXE is not
supported with TCP/IP.

To use the new version of DB2.EXE in a Windows DOS session or OS/2 DOS
session, you must set the environment variable DB2EXTENDER to the
value /HD+, like this:  SET DB2EXTENDER=/HD+

NOTE:  When using the new version of DB2.EXE, you cannot terminate the
       application with Ctrl-C or Ctrl-Break.

2.2.1.2  Hardware Requirements

The new version of DB2.EXE requires a minimum of 2 MB of RAM on the
workstation.  For the memory managers and extenders, please consult
appropriate product documentation to determine additional memory and
disk requirements.

2.2.1.3  Installation of new versions of DB2.EXE

The old version of DB2.EXE will be installed automatically when
you install this ServicePak.  To install the new version of DB2.EXE
please follow the instructions below.

A file (DB2EXTND.ZIP) is located on the first installation diskette
of this ServicePak.

For SDK/DOS Users:

DB2BSDK.EXE  - The new version of DB2.EXE (Dos Extender version)
BSTUB.OBJ    - Required link file (See sections 1.5.2.1, 1.5.2.3)

   PKUNZIP the contents of DB2EXTND.ZIP (2 MB) to a \TMP directory.
Rename the file DB2BSDK.EXE to DB2.EXE, and copy DB2.EXE to \SQLLIB\BIN
of your SDK/DOS installation.  The file BSTUB.OBJ should already exist
in the directory \SQLLIB\LIB, if it doesn't, copy the file from the
\TMP directory to \SQLLIB\LIB.


For CAE/DOS Users:

DB2BCAE.EXE  - The new version of DB2.EXE (Dos Extender version)

   PKUNZIP the contents of DB2EXTND.ZIP (2 MB) to a \TMP directory.
Rename the file DB2BCAE.EXE to DB2.EXE, and copy DB2.EXE to \SQLLIB\BIN
of your CAE/DOS installation.

2.2.2  Usage Notes

The SDK/DOS libraries are now protected-mode compatible.  You can
develop protected-mode DOS programs with these libraries, using a
16-bit DOS memory extender.

The following restriction applies:  if you are running under Windows
and using FTP PC/TCP for TCP/IP support, programs developed with
SDK/DOS cannot use DOS memory extenders.

2.2.2.1  Using XM and Micro Focus COBOL

The versions of XM and Micro Focus COBOL tested are:

     XM: v1.4.6
     Micro Focus COBOL: v3.2.20

Consult Micro Focus and XM documentations for details and any
limitations of XM support.  For example, XM limits the size of an
executable (.EXE) file to 1 MB.

When developing applications with this ServicePak applied, you must
link in the file BSTUB.OBJ in the \SQLLIB\LIB directory.

If you are developing DOS extended applications using Micro Focus
COBOL with XM, you must use a memory manager that provides DPMI
support.  HIMEM.SYS and EMM386.EXE do not provide DPMI support.  QEMM
and the DOS session support in Windows and OS/2 do provide DPMI
support.

2.2.2.2  Using Blinker and Microsoft C

The Blinker product replaces the Microsoft linker, and allows you to
create protected mode programs that use DPMI.  Please consult the
Blinker documentation for details of using Blinker to develop
protected mode DOS programs.

When linking large executables, Blinker may require over 500K of
conventional memory.  Use a memory manager like one of those listed in
"Software Requirements" above to free memory for Blinker.

Below is a sample Blinker link script:

        output myprog.exe
        stack 10000
        blinker executable extended
        blinker executable nodelete
        blinker executable alignment 64
        blinker host dpmi off
        blinker environment name DB2EXTENDER

        file mysrc1.obj
        file mysrc2.obj

        lib \sqllib\lib\db2sdk1.lib
        lib \sqllib\lib\db2sdk2.lib
        lib \sqllib\lib\db2sdk3.lib
        lib \sqllib\lib\db2util.lib
        lib \sqllib\lib\db2prep.lib
        search blxmsc70
        lib \c700\lib\llibce.lib
        lib \c700\lib\oldnames.lib

See the Blinker documentation for the meaning of these script file
commands.  For more information about Blinker, please contact:

        Blink, Inc.                             Blink, Inc Ltd.
        8001 West Broad Street,                 33, Plassey Street
        Richmond,                               Penarth,
        VA 23294,                               South Glamorgan,
        USA.                                    UK.
        Tel (804) 747-6700                      Tel (1222) 712444
        Fax (804) 747-4200                      Fax (1222) 700888

2.2.2.3 Linker Changes Required for All Users of this ServicePak

If you are developing a DOS application using SDK/DOS, and you are not
using Blinker, you must now link in the file \SQLLIB\LIB\BSTUB.OBJ.
This applies to applications developed with Microsoft linker to
develop real mode applications, and users of Micro Focus COBOL and XM.


2.3 Microsoft(TM) Visual C++ v1.5 Professional Edition (C compiler only)
    Support for DB2 Client/Server

This section contains information about support for the C compiler
under Microsoft(TM) Visual C++ v1.5 (Professional Edition) for the
following product:

- DB2 Software Developer's Kit/DOS v1.2

For information, see also  --------------------------------

     * Microsoft(TM) Visual C++ v1.5 (Professional Edition)
        -  README.TXT file
        -  README.WRI file (using TechNote Viewer)
        -  Online Documentation
     * DB2 Client Application EnablerDOS v1.2.0 User's Guide
     * DB2 Software Developer's Kit/DOS v1.2.0 Programming Guide

  ---------------------------------------------------------

2.3.1  Installation Notes
2.3.1.1  Recommended Software Installation Sequence

  When installing the Microsoft Visual C++ compiler for use with
  DB2 SDK/DOS, it is recommended that the following software already
  be installed, configured and each tested individually, in the
  following sequence:

         - DOS 3.3 or higher
         - Windows 3.1 (if required)
         - IBM LAN Support Program 1.2x/1.3x (if required)
         - DOS LAN Requester 2.0/3.0 (if required)
         - One of the following communication programs:
                   - FTP Software PC/TCP v2.3
                   - IBM TCP/IP for DOS v2.1.0.5 or higher
                   - NetWare Requester for DOS/Windows
                   - NOVIX for Netware
         - DB2 SDK/DOS
         - Memory manager (if required) such as:
                   - Qualitas 386MAX (for 80386 PCs)
                   - Qualitas BlueMAX v7.00 (for IBM PS/2s)
                   - Quarterdeck Enhanced Memory Manager v7.04 (QEMM)
                   - MS-DOS 6.2 MemMaker
                   - NetROOM
                   - Phar Lap 286 Dos-Extender

2.3.1.2  Installation Directories

The Visual C++ SETUP.EXE will install Visual C++ in the following directory:

<drive>:\MSVC

2.3.1.3  Configuration of Command Line Tools for DOS

The Visual C++ Setup program does not configure your system
to run Visual C++ components from DOS. However, the command line
tools are available. To use the Visual C++ components from the
command line, you need to either make changes to your
AUTOEXEC.BAT, or run the batch file \MSVC\BIN\MSVCVARS.BAT
to temporarily set the environment variables. Please refer to
the Visual C++ installation manual (Getting Started) for
further details.

2.3.1.4  Setup File MSVCVARS.BAT and INCLUDE Path

Running the MSVCVARS.BAT file will result in the Visual C++ v1.5
libraries being specified before the SDK/DOS v1.2.0 libraries in
the PATH, INCLUDE and LIB statements. If you will be developing
DB2 embedded SQL applications, please ensure that the SDK/DOS
v1.2.0 libraries precede the Visual C++ v1.5 libraries.


2.3.2  Usage Notes
2.3.2.1  Application Stack Overflow

To prevent application stack overflow, it may be necessary to
compile using the /Gtn option to assign static data elements to
__far heap memory so that stacksize can be increased using the
/ST link option or the STACKSIZE definition file option.

2.3.2.2  RW4005 Resource Compiler Error

When getting this error for applications that will only be
run as a SINGLE instance, note that for Windows applications,
the INSTANCE flag in the definition file DATA section defaults
to MULTIPLE if not otherwise specified.  Set the SINGLE INSTANCE
flag in the module definition file's DATA section in
order to eliminate the error.

2.3.2.3  Modifications to Build and Run Sample Programs

 o UPDAT  - Remove the STACKSIZE option from the CL.DEF file or
            remove the /ST link option from the WINBLD.BAT file in
            order to prevent link warning L4089.

 o CLISAMP - Remove reference to db2ovl.def in the CLIBLD.BAT
             file in order to prevent link warning L4077.

2.3.2.4  ODBC vs DB2 Embedded SQL Applications

Visual C++ comes with an INCLUDE file called SQL.H that contains
the prototypes and constants for the core level of ODBC functions.
However, the SDK/DOS v1.2.0 product also comes with an INCLUDE
file called SQL.H, which is used for the development of DB2
applications containing embedded SQL.

When developing ODBC applications, the Visual C++ SQL.H file
must be used. When developing DB2 embedded SQL applications
using the SDK/DOS v1.2.0 product, however, the SDK/DOS v1.2
SQL.H file must be used.

To use the SDK/DOS v1.2.0 SQL.H file for a DB2 Client/Server
application with embedded SQL, ensure that the default
SDK/DOS v1.2.0 INCLUDE library (<drive>:\SQLLIB\INCLUDE by default)
precedes the Visual C++ INCLUDE library (<drive>:\MSVC\INCLUDE)
in the INCLUDE path.

2.3.2.5  DB2 Call Level Interface Applications

Note that if you are planning to develop DB2 Call Level
Interface applications under DOS, the SDK/DOS v1.2.0 INCLUDE
files SQLCLI.H and SQLCLI1.H are used instead of SQL.H.

2.3.2.6  Other Recommended Compiler and/or Link Options

Specify the /G3 compiler option instead of the /G2 compiler
option in order to generate 80386 instructions. In some cases,
this may be required for network compatibility. Please see the
Visual C++ README file.

For most applications it will probably be necessary to specify
the /ST option in order to increase stacksize available to the
application.

2.3.3  Changes to Documentation
2.3.3.1  Programming Guide

     o Replace all references to C:\C700 with C:\MSVC.

     o Replace all references to Microsoft(TM) C V7.00 with
       Microsoft(TM) Visual C++ v1.5 (Professional Edition)

2.4  Helpful hints for taking traces
2.4.1  Avoiding Zero (0) byte Trace files

If you generate a trace from a DB2 Client DOS workstation, but
the trace file is 0 bytes in size, you need to turn off the read-only
attribute for the trace file, and recreate the trace.

   To turn off the read-only attribute for the trace file, use
this DOS command (where filename.ext is the name of the trace file
as you would specify it in the AUTOEXEC.BAT,or elsewhere with an
environment variable)

  attrib -r filename.ext

   For example:  attrib -r db2dos.trc

This is a good thing to add to the AUTOEXEC.BAT, if you keep other
trace statements in there.


***********************************************************************
**                                                                   **
**  (c) COPYRIGHT INTERNATIONAL BUSINESS MACHINES CORPORATION 1995.  **
**                    ALL RIGHTS RESERVED.                           **
**                                                                   **
***********************************************************************

