
ns_register_proc GET  /NS/NewUser newuser
ns_register_proc POST /NS/AddNewUser addnewuser

ns_register_proc GET  /NS/DeleteUser deluserform
ns_register_proc POST  /NS/DeleteUser deluser
ns_register_proc POST  /NS/ReallyDelUser reallydeluser

proc newuser {conn ignore} {

    set db [ns_conn db $conn]
    set defgroupselect "<SELECT NAME=defgroup>"
    set row [ns_db select $db "select group_name from ns_groups order by group_name;"]
    while {[ns_db getrow $db $row]} {
	append defgroupselect "<OPTION>[ns_set get $row group_name]\n"
    }
    append defgroupselect "</SELECT>"
    ns_return $conn 200 text/html \
"<HTML><HEAD>
<TITLE>Add a New User</TITLE>
</HEAD><BODY><H1>Add a New User
</H1><HR><FORM ACTION=/NS/AddNewUser METHOD=\"POST\"><PRE>
<B>User Name          </B><INPUT TYPE=text NAME=username>
<B>User Password      </B><INPUT TYPE=password NAME=password>
<B>User Password (type it again)</B><INPUT TYPE=password NAME=confirmpassword>
<B>User Default Group </B>$defgroupselect
<B>User Full Name     </B><INPUT TYPE=text NAME=fullname>
<B>Create Home Directory and Home Page:</B> <INPUT TYPE=checkbox NAME=createhome>
<B><INPUT TYPE=\"submit\" VALUE=\"Add User\">  <INPUT 
TYPE=\"reset\" VALUE=\"Clear All\"></B>
</PRE></FORM></BODY></HTML>
"
}
proc addnewuser {conn context} {

    set form [ns_conn form $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Missing form data"
	return;
    }

    set username [ns_set get $form username]

    if {$username == ""} {
	ns_returnerror $conn 500 "Missing Username"
	return
    }

    if {[regexp {[^a-zA-Z0-9]} $username]} {
	ns_returnerror $conn 500 "Username can only contain letters and numbers"
	return
    }

    if {[UserExists [ns_conn db $conn] $username]} {
	ns_returnerror $conn 500 "User $username already exists, try another name."
	return
    }

    set password [ns_set get $form password]

    if {$password == ""} {
	ns_returnerror $conn 500 "Missing Password"
	return
    }

    set confirmpassword [ns_set get $form confirmpassword]

    if {$password != $confirmpassword} {
	ns_returnerror $conn 500 "Passwords did not match"
	return
    }

    if {[ns_config DbServices EncryptedPasswords] == 1} {
	set password [ns_crypt $password NU]
    }

    set defgroup [ns_set get $form defgroup]

    if {$defgroup == ""} {
	set defgroup "public"
    }

    set user_data1 [ns_set get $form user_data1]

    set fullname [ns_set get $form fullname]

    if [catch {
	ns_db dml [ns_conn db $conn] "insert into ns_users(user_name, user_passwd, user_fullname, user_defgroup) values ('$username','$password','$fullname','$defgroup');"
    } errMsg] {
	ns_returnerror $conn 500 "Could not add user: $errMsg"
	return
    }

    if {$fullname == ""} {
	set fullname $username
    }
 
    set createhome [ns_set get $form createhome]

    if {($createhome == "on") || ($createhome == "ON")} {
	set userdir [ns_config DbServices UserDir]
	if {$userdir == ""} {
	    set userdir "users"
	}

	set userurl /$userdir/[string index $username 0]/$username
	set userhome [ns_info pageroot]$userurl

	if [catch {
	    if {![file exists [ns_info pageroot]/$userdir]} {
		ns_mkdir [ns_info pageroot]/$userdir
	    }
	    if {![file exists [ns_info pageroot]/$userdir/[string index $username 0]]} {
		ns_mkdir [ns_info pageroot]/$userdir/[string index $username 0]
	    }
	    ns_mkdir $userhome
	} errMsg] {
	    ns_returnerror $conn 500 "User $username added, but could not create user directory: $errMsg"
	    return;
	}

	ns_db dml [ns_conn db $conn] "insert into ns_permissions(permission_method,permission_url,permission_user,permission_group,permission_user_ok,permission_group_ok,permission_world_ok) values ('PUT','$userurl','$username','$defgroup','t','f','f');"
	ns_db dml [ns_conn db $conn] "insert into ns_permissions(permission_method,permission_url,permission_user,permission_group,permission_user_ok,permission_group_ok,permission_world_ok) values ('GET','$userurl','$username','$defgroup','t','t','t');"

	ns_cp [ns_info tcllib]/ln_owl.gif $userhome/ln_owl.gif
	ns_cp [ns_info tcllib]/ln_look.gif $userhome/ln_look.gif
	ns_cp [ns_info tcllib]/ln_bow.gif $userhome/ln_bow.gif

        set statement [ns_set get $form statement]
        if {$statement == ""} {
	    set statement "
<H3>Hi! My name is $fullname, and welcome to my home page on the World Wide Web.</H3>  It's rather plain now,
but just you wait til I'm done with it!"
        }

	set homepage \
"<HTML><HEAD>
<TITLE>$fullname's Home Page</TITLE></HEAD><BODY>
<H1>$fullname's Home Page</H1>
$statement<P>
<IMG SRC=ln_owl.gif>
<H3>My thoughts on the World Wide Web
</H3><P>I love it!
<P><IMG SRC=ln_look.gif>
<H3>Some of my favorite places on the Web
</H3><UL><LI><A HREF=http://www.yahoo.com>Yahoo </A>
<LI><A HREF=http://www.navisoft.com/pub/surf.html>Surfing the World Wide
Web</A>
<LI></UL><P><IMG SRC=ln_bow.gif>
<ADDRESS>This page was created with
<A HREF=http://www.navisoft.com/traci/overview.htm>Navipress</A> and
<A HREF=http://www.navisoft.com/traci/nserv.htm>Naviserver</A> from
<A HREF=http://www.navisoft.com>Navisoft</A>.
</ADDRESS><P>
<P>
</BODY></HTML>
"
        set fp [open $userhome/index.htm w]
        puts $fp $homepage
        close $fp

        ns_return $conn 200 text/html \
"<HTML><HEAD>
<TITLE>$username successfully added.</title></HEAD><BODY>
<H1>User $username ($fullname) successfully added.</H1>
<A HREF=[ns_info location]$userurl/index.htm>Home page</A> sucessfully created.
</BODY></HTML>
"
    } else {
	ns_returnnotice $conn 200 "User $username successfully added."
    }
}


ns_register_proc GET /NS/ChangePassword changepwform

proc changepwform {conn ignore} {
    ns_return $conn 200 text/html \
"<HTML><HEAD>
<TITLE>Change User Password</TITLE>
</HEAD><BODY><H1>Change User Password
</H1><FORM ACTION=/NS/ChangePassword METHOD=\"POST\"><PRE>
<B>User Name          </B><INPUT TYPE=text NAME=username>
<B>Old User Password  </B><INPUT TYPE=password NAME=oldpw>
<B>New User Password  </B><INPUT TYPE=password NAME=newpw>
<B>New User Password (type it again)</B><INPUT TYPE=password NAME=confirmnewpw>
<B><INPUT TYPE=\"submit\" VALUE=\"Change Password\">  <INPUT 
TYPE=\"reset\" VALUE=\"Clear All\"></B>
</FORM></BODY></HTML>
"
}

ns_register_proc POST /NS/ChangePassword changepw

proc changepw {conn ignore} {

    set form [ns_conn form $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Missing form data"
	return;
    }

    set username [ns_set get $form username]

    if {$username == ""} {
	ns_returnerror $conn 500 "Missing username"
	return
    }

    if {![UserExists [ns_conn db $conn] $username]} {
	ns_returnerror $conn 500 "User $username does not exist"
	return
    }

    set oldpw [ns_set get $form oldpw]

    set newpw [ns_set get $form newpw]

    if {$newpw == ""} {
	ns_returnerror $conn 500 "Missing new password"
	return
    }

    set confirmnewpw [ns_set get $form confirmnewpw]

    if {$newpw != $confirmnewpw} {
	ns_returnerror $conn 500 "New passwords did not match"
	return
    }

    set realoldpw [GetPw [ns_conn db $conn] $username]

    if {[ns_config DbServices EncryptedPasswords] == 1} {
	set oldpw [ns_crypt $oldpw $realoldpw]
	set newpw [ns_crypt $newpw CU]
    }

    if {$oldpw != $realoldpw} {
	ns_returnerror $conn 500  "Incorrect old password"
	return
    }

    if [catch {
	ns_db dml [ns_conn db $conn] "update ns_users set user_passwd='$newpw' where user_name = '$username';"
    } errMsg] {
	ns_returnerror $conn 500 "Could not change password: $errMsg"
	return
    }

    ns_returnnotice $conn 200 "Password for $username changed."
}

proc GetPw {db username} {
    set row [ns_db 0or1row $db "select * from ns_users where user_name = '$username';"]
    if {$row == ""} {
	error "Could not find user $username"
    } else {
	set answer [ns_set get $row "user_passwd"]
	return $answer
    }
}

proc UserExists {db username} {
    set row [ns_db 0or1row $db "select * from ns_users where user_name = '$username';"]
    if {$row != ""} {
	return 1
    } else {
	return 0
    }
}

proc deluserform {conn ignore} {
    set db [ns_conn db $conn]
    set userselect "<SELECT NAME=username>"
    set row [ns_db select $db "select user_name from ns_users order by user_name;"]
    while {[ns_db getrow $db $row]} {
	append userselect "<OPTION>[ns_set get $row user_name]\n"
    }
    append userselect "</SELECT>"
    ns_return $conn 200 text/html \
"<HTML><HEAD>
<TITLE>Delete User</TITLE>
</HEAD><BODY><H1>Delete User
</H1><HR><FORM ACTION=/NS/DeleteUser METHOD=\"POST\"><PRE>
<B>User Name          </B>$userselect
</PRE>
<B>Note:</B> This command will remove:
<UL>
<LI>Any charges the user has accrued, 
<LI>Any permissions that the user owns,
<LI>Any user to group mappings for the user,
<LI>The user record itself
</UL>
This command will NOT remove any files that user may have created.
<BR><B><INPUT TYPE=\"submit\" VALUE=\"Delete User\"></B>
</FORM>
</BODY></HTML>
"
}

proc deluser {conn ignore} {

    set form [ns_conn form $conn]
    set db [ns_conn db $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Missing form data"
	return;
    }

    set username [ns_set get $form username]

    if {$username == ""} {
	ns_returnerror $conn 500 "Missing username"
	return
    }

    if {$username == "nsadmin"} {
	ns_returnerror $conn 500 "Cannot delete the nsadmin user"
	return
    }

    set userrow [ns_db 0or1row $db "select * from ns_users where user_name = '$username';"];
    if {$userrow == ""} {
	ns_returnerror $conn 500 "User $username does not exist"
	return
    }

    set output \
	    "<HTML><HEAD><TITLE>Verify User Deletion</TITLE></HEAD>
<H1>Verify User Deletion</H1><HR>
<B>Username:</B> [ns_set get $userrow user_name]<BR>
<B>User full name :</B> [ns_set get $userrow user_fullname]<BR>
<B>User's Total Charges:</B> "
    
    set row [ns_db 0or1row $db "select total_charge from ns_total_charges where total_user = '$username';"]
    if {$row == ""} {
	append output "None";
    } else {
	set result [ns_set get $row total_charge]
	if {$result == ""} {
	    append output "None";
	} else {
	    append output $result
	}
    }
    append output "<BR><B>User's owns permissions on:</B><PRE>"
    set row [ns_db select $db "select permission_method, permission_url from ns_permissions where permission_user = '$username';"]
    while {[ns_db getrow $db $row]} {
	append output "     [ns_set get $row permission_method] [ns_set get $row permission_url]<BR>"
    }

    append output "</PRE><B>User is a member of these groups:</B> [ns_set get $userrow user_defgroup]"
    set row [ns_db select $db "select group_name from ns_groups2users where user_name = '$username';"]
    while {[ns_db getrow $db $row]} {
	append output ", [ns_set get $row group_name]"
    }

    append output \
"<FORM ACTION=/NS/ReallyDelUser METHOD=\"POST\">
<INPUT TYPE=HIDDEN NAME=username VALUE=$username>
<INPUT TYPE=\"submit\" VALUE=\"Delete\">
</FORM></BODY></HTML>"

    ns_return $conn 200 text/html $output
}

proc reallydeluser {conn ignore} {
    set form [ns_conn form $conn]
    set db [ns_conn db $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Missing form data"
	return;
    }

    set username [ns_set get $form username]

    if {$username == ""} {
	ns_returnerror $conn 500 "Missing username"
	return
    }

    if {$username == "nsadmin"} {
	ns_returnerror $conn 500 "Cannot delete the nsadmin user"
	return
    }

    set userrow [ns_db 0or1row $db "select * from ns_users where user_name = '$username';"];
    if {$userrow == ""} {
	ns_returnerror $conn 500 "User $username does not exist"
	return
    }

    if [catch {
	ns_db dml $db "delete from ns_charges where charge_user = '$username';"
	ns_db dml $db "delete from ns_permissions where permission_user = '$username';"
	ns_db dml $db "delete from ns_groups2users where user_name = '$username';"
	ns_db dml $db "delete from ns_users where user_name = '$username';"
    } errMsg] {
	ns_returnerror $conn 500 "Could not remove user $username from database: $errMsg"
	return
    }
    ns_returnnotice $conn 200 "User $username removed"
}
