
ns_register_proc GET  /NS/SearchHelp searchhelpform
ns_register_proc POST /NS/SearchHelp searchhelp

proc searchhelpform {conn ignore} {
    ns_return $conn 200 text/html \
"<HTML><HEAD>
<TITLE>Search for Help</TITLE>
</HEAD><BODY><IMG SRC=/NS/Asset/catinhat.gif><H2>Search for Help</H2>
<FORM ACTION=/NS/SearchHelp METHOD=POST><B>Enter
a word or words that describe the topic you need help
on<B>:</B></B>
<INPUT TYPE=text NAME=query>
<P>
<INPUT TYPE=checkbox NAME=press VALUE=ON CHECKED>Search NaviPress on-line
documentation
<P>
<INPUT TYPE=checkbox NAME=server VALUE=ON>Search NaviServer on-line
documentation
<P>
<INPUT TYPE=\"submit\" VALUE=\"Go\">  <INPUT 
TYPE=\"reset\" VALUE=\"Clear All\"></FORM><P>
<P>
</BODY></HTML>
"
}

proc searchhelp {conn ignore} {

    set db [ns_conn db $conn]

# Verify arguments

    set form [ns_conn form $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Missing form data"
	return;
    }

    set query [ns_set get $form query]

    if {$query == ""} {
	ns_returnerror $conn 500 "Missing Query"
	return
    }

    set press [ns_set get $form press]
    set server [ns_set get $form server]

    if {$press == "" && $server == ""} {
	ns_returnerror $conn 500 "No documentation to search selected"
	return;
    }

# Build SQL

    regsub -all "'" $query "''" quoted_query

    set sql "select ns_url, ns_title, WeightContains('ns_pages_by_ns_body',ns_pages.ctid,OrTerms('$quoted_query')) as ns_body_weight from ns_pages where "

    if {$press == "" && $server == "ON"} {
	append sql "ns_url like '/servdoc/%' "
    } elseif {$press == "ON" && $server == ""} {
	append sql "ns_url like '/NaviPress/%' "
    } else {    
	append sql "(ns_url like '/servdoc/%' or ns_url like '/NaviPress/%') "
    }
    append sql "and ns_body_weight > 0 order by ns_body_weight desc;"

# Execute SQL

    if [catch {
	set row [ns_db select $db $sql]
    } errMsg] {
	ns_returnerror $conn 500 "Could not execute search: $errMsg"
	return
    }

# Print out results. Should generate Hilite URL's, not just URL's

    set output \
"<HTML><HEAD><TITLE>Search Results</TITLE></HEAD>
<BODY><IMG SRC=\"/NS/Asset/SearchResultsHeader.gif\"><BR>
You were looking for help on: \"$query\"<HR>"

    set i 1
    while {[ns_db getrow $db $row]} {
	set url [ns_set get $row ns_url]
	set title [ns_set get $row ns_title]
	if {$title == ""} {
	    set title $url
	}
	append output "<TT>[format "%2d" $i]. "
	if [string match /servdoc/* $url] {
	    append output "NaviServer: </TT>"
	} else {
	    append output "NaviPress : </TT>"
	}
	append output "<A HREF=$url>$title</A><BR>\n"
        incr i
    }
    append output "</BODY></HTML>"
    ns_return $conn 200 text/html $output
}
