
ns_register_proc GET  /NS/GetPermForm getpermform
ns_register_proc POST /NS/SetPerm setperm

ns_register_proc GET  /NS/GetPriceForm getpriceform
ns_register_proc POST /NS/SetPrice setprice

proc getpermform {conn ignore} {

    set form [ns_conn form $conn]
    set authuser [ns_conn authuser $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Request is missing form data."
	return
    }

    set url [ns_set get $form url]
    if {$url == ""} {
	ns_returnerror $conn 500 "Missing URL."
	return
    }

    # Normalize the path.
    set url [ns_normalizepath $url]

    if {$authuser == ""} {
	ns_returnnotice $conn 401 "Unauthorized"
	return
    }

    if {![ns_checkpasswd $authuser [ns_conn authpassword $conn]]} {
	ns_returnnotice $conn 401 "Unauthorized"
	return
    }

    set db [ns_conn db $conn]

    set output \
"<HTML><HEAD>
<TITLE>Set Permissions</TITLE>
</HEAD><BODY><IMG SRC=/NS/Asset/naviserv.gif>
<H3>Set Permissions</H3>Use this form to set the permissions for the URL
<CODE>$url</CODE>. Note that the default permissions in the form are not 
necessarily the current permissions.
<PRE><FORM METHOD=POST ACTION=/NS/SetPerm><B><HR>
URL:          $url      <INPUT NAME=url    TYPE=hidden VALUE=$url>
Method:       <SELECT NAME=method><OPTION>GET<OPTION>PUT<OPTION>POST</SELECT>
Owner:        "

    if {$authuser == "nsadmin"} {
	append output "<SELECT NAME=owner>"
	set row [ns_db select $db "select user_name from ns_users
		 		   order by user_name;"]
	while {[ns_db getrow $db $row]} {
	    append output "<OPTION>[ns_set value $row 0]\n"
	}
	append output "</SELECT>\n"
    } else {
	append output "$authuser <INPUT NAME=owner TYPE=hidden VALUE=$authuser>\n"
    }

    append output \
"Group:        <SELECT NAME=group>"

    if {$authuser == "nsadmin"} {
	set row [ns_db select $db "select group_name from ns_groups 
				   order by group_name;"]
	while {[ns_db getrow $db $row]} {
	    append output "<OPTION>[ns_set value $row 0]\n"
	}
    } else {
	set row [ns_db 1row $db "select user_defgroup from ns_users 
				 where user_name = '$authuser';"]
	set defgroup [ns_set value $row 0]
	append output "<OPTION SELECTED>$defgroup\n"
	set row [ns_db select $db "select group_name from ns_groups2users 
				   where user_name = '$authuser'
				   and group_name <> '$defgroup'
				   order by group_name;"]
	while {[ns_db getrow $db $row]} {
	    append output "<OPTION>[ns_set value $row 0]\n"
	}
    }

    append output "</SELECT>"

    append output \
{<HR>
User OK:     <INPUT NAME="user_ok" TYPE="radio" VALUE="t" CHECKED> True
             <INPUT NAME="user_ok" TYPE="radio" VALUE="f"> False
<HR>
Group OK:    <INPUT NAME="group_ok" TYPE="radio" VALUE="t"> True
             <INPUT NAME="group_ok" TYPE="radio" VALUE="f" CHECKED> False
<HR>
World OK:    <INPUT NAME="world_ok" TYPE="radio" VALUE="t"> True
             <INPUT NAME="world_ok" TYPE="radio" VALUE="f" CHECKED> False
<HR>
<INPUT TYPE="submit" VALUE="Set Permissions">  <INPUT TYPE="reset" VALUE="Clear All">
<HR>
</B></FORM></PRE></BODY></HTML>}

    ns_return $conn 200 text/html $output
}

proc setperm {conn ignore} {

    set form [ns_conn form $conn]
    set authuser [ns_conn authuser $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Invalid request" \
		"Request is missing form data"
	return
    }

    set url [ns_set get $form url]
    set method [ns_set get $form method]
    set owner [ns_set get $form owner]
    set group [ns_set get $form group]
    set user_ok [ns_set get $form user_ok]
    set group_ok [ns_set get $form group_ok]
    set world_ok [ns_set get $form world_ok]

    if {$url == "" || $method == "" || $owner == "" ||
	$group == "" || $user_ok == "" || $group_ok == "" || $world_ok == ""} {
	ns_returnerror $conn 500 "Missing form data"
	return
    }

    # Normalize the path.
    set url [ns_normalizepath $url]

    set db [ns_conn db $conn]

    if [catch {
	set currentowner [ns_urlowner $method $url]
    } errMsg] {
	ns_returnerror $conn 500 "$url does not have a $method owner"
	return
    }

    if {![ns_checkpasswd $authuser [ns_conn authpassword $conn]]} {
	ns_returnnotice $conn 401 "Unauthorized"
	return
    }

    if {$authuser != "nsadmin"} {
	if {$currentowner != $owner} {
	    ns_returnerror $conn 500 "Could not change $method owner\
		    of $url from $currentowner to $owner"
	    return
	}
	if {$owner != $authuser} {
	    ns_returnnotice $conn 401 "Unauthorized"
	    return
	}
    }

    ns_db dml $db "
delete from ns_permissions where permission_url = '$url'
	and permission_method='$method';

insert into ns_permissions (
	permission_url, permission_method, permission_user, permission_group, 
	permission_user_ok, permission_group_ok, permission_world_ok
) values(
	'$url','$method','$owner','$group', '$user_ok','$group_ok','$world_ok'
);"

   ns_returnnotice $conn 200 "Permissions set"
}

proc getpriceform {conn ignore} {

    set form [ns_conn form $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Request is missing form data"
	return
    }

    set url [ns_set get $form url]

    if {$url == ""} {
	ns_returnerror $conn 500 "Missing URL"
	return
    }

    # Normalize the path.
    set url [ns_normalizepath $url]

    ns_return $conn 200 text/html \
"<HTML><HEAD>
<TITLE>Set Price</TITLE>
</HEAD><BODY><IMG SRC=/NS/Asset/naviserv.gif>
<PRE><H3>Set Price</H3><FORM METHOD=POST ACTION=/NS/SetPrice><B><HR>URL:          $url      <INPUT NAME=url    TYPE=hidden VALUE=$url>
Method:       <SELECT NAME=method><OPTION>GET<OPTION>PUT<OPTION>POST</SELECT>
Amount (must be a whole number): <INPUT NAME=amount SIZE=10>
<HR>
<INPUT TYPE=\"submit\" VALUE=\"Set Price\">  <INPUT TYPE=\"reset\" VALUE=\"Clear All\">
<HR>
</B></FORM></PRE></BODY></HTML>"
}

proc setprice {conn ignore} {

    set form [ns_conn form $conn]
    set authuser [ns_conn authuser $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Invalid request" \
		"Request is missing form data."
	return
    }

    set url [ns_set get $form url]
    set method [ns_set get $form method]
    set amount [ns_set get $form amount]

    if {[scan $amount "%d" intamount] != 1 || $amount != $intamount} {
	ns_returnerror $conn 500 \
		"Amount $amount is not a whole number."
	return
    }

    # Normalize the path.
    set url [ns_normalizepath $url]

    if {$url == "" || $method == "" || $amount == ""} {
	ns_returnerror $conn 500 "Missing form data"
	return
    }

    set db [ns_conn db $conn]

    ns_db dml $db "
delete from ns_prices where price_url = '$url' and price_method='$method';

insert into ns_prices (
	price_url, price_method, price_amount
) values(
	'$url','$method','$amount'
);"

   ns_returnnotice $conn 200 "Price set"
}
