// WINPOS.PRG -->German version
//
// Position und Gre des aktuellen Fensters holen.
// Kann benutzt werden, um Benutzereinstellungen zu speichern

// Windows-Funktionen deklarieren.
declare pfunc GetWindowRect returning integer in dll user.exe

set window type to 1+16+32+4096+8192
create window 'Test' from 2,2 to 20,50

wait

// handle des aktuellen Fensters holen
hWnd = HWND()

// Eine Variable erzeugen, die die Bytegre der RECT-Struktur besitzt.
// Die Gre ist 8 Bytes, da es 4 Punkte gibt und jeder Punkt
// (Koordinate) durch einen Integerwert von 2 Bytes darstellt wird.
lprc = space(8)

// Variablen einer DLL-Funktion men IMMER typisiert an die Funktion 
// bergebenwerden. 'lprc' wird nicht typisiert, da die Adresse der 
// Variablen mit dem '@'-Symbol bergeben wird
GetWindowRect(toint(hWnd), @lprc)

// Die einzelnen Korordinaten aus der Struktur filtern.
// Alle Koordinaten sind in Pixel. UL: Oben links, LR: unten rechts

// links
iWndULX =  getint(@lprc,1)
// oben
iWndULY =  getint(@lprc,2)
// rechts
iWndLRX =  getint(@lprc,3)
// unten
iWndLRY =  getint(@lprc,4)

close window 'Test'

set window type to 1+16+32+4096+8192

// Es men noch Anpassungen durchgefhrt werden, die je nach Fenster-
// typ die Titelzeile und Rahmen(bei in der Gre vernderbaren 
// Fenstern) bercksichtigen.

create window 'Test' at point iWndULY-19,iWndULX to iWndLRY-55,iWndLRX-4

wait
