// SHOWWIN.PRG -->German version
//
// Kontrolliert ein Fenster:
// vergrern, verkleinern, wieder herstellen
// Icons anordnen und feststellen, ob ein Fenster verkleinert o. 
// vergrert ist. Ein Child-Window 'on Top' bringen
// Ein Fenster bewegen und in der Gre verndern
//
// Hinweis: um die verkleinerten Fenster anordnen zu knnen, mu
//    das Child-Window-Attribut gesetzt sein

// Windows API function calls
declare pfunc ShowWindow returning integer in dll user.exe
declare pfunc ArrangeIconicWindows returning integer in dll user.exe
declare pfunc IsIconic returning integer in dll user.exe
declare pfunc IsZoomed returning integer in dll user.exe
declare pfunc BringWindowToTop returning integer in dll user.exe
declare pfunc FindWindow returning integer in dll user.exe
declare pfunc SetFocus returning integer in dll user.exe
declare pfunc MoveWindow returning integer in dll user.exe

// Aktionen, die per ShowWindow fr ein Fenster ausgefhrt 
// werden knnen.
#define SW_HIDE					0
#define SW_SHOW					5
#define SW_MAXIMIZE				3
#define SW_MINIMIZE				6	
#define SW_RESTORE				9	

// Window-handle des CONSOLE-Fenster holen
hConsoleWin = HWND()

// Window-handle fr CA-dBFast selbst holen.
// 'CA-dBFast' mu bei gelinkten Apps durch den Namen der App ersetzt 
// werden. Mit 'tolong(0)' wird NULL an die Funktion durchgereicht.

hdBFast = FindWindow(tolong(0), 'CA-dBFast')

set window type to 8192+4096+32+1+512+16
create window 'Window 1' from 0,40 to 10,70
hWnd1 =  HWND()
? 'Hier klicken,'
wait 'um zu verkleinern...'

ShowWindow(toint(hWnd1), toint(SW_MINIMIZE))

select window 'CONSOLE'
set window type to 8192+4096+32+1+512+16
create window 'Window 2' from 7,45 to 17,75
hWnd2 =  HWND()
?'Hier klicken,'
wait 'um zu verkleinern...'

ShowWindow(toint(hWnd2), toint(SW_MINIMIZE))
select window 'CONSOLE'
wait 'Jetzt Icons umherbewegen, dann ein Klick...'

// Icons der verkleinerten Child-Windows anordnen
select window 'CONSOLE'
// Der Rckgabewert ist die Hhe einer Reihe von Icons, wenn die 
// Funktion erfolgreich war. Andernfalls ist er 0.
?
? ArrangeIconicWindows(toint(hConsoleWin))
wait 'Icons angeordnet.  Klick...'

// IsIcon gibt einen Wert <>0 zurck, wenn das Fenster verkleinert
// (minimized) ist, anderfalls 0.
if (IsIconic(toint(hwnd2)))
	? 'Window 2 ist "minimized"'
else
	? 'Window 2 ist nicht "minimized"'
endif

// IsZoomed gibt einen Wert <>0, wenn das Fenster vergrert
// (maximized) dargestellt wird, andernfalls 0.
if (IsZoomed(toint(hwnd1)))
	? 'Window 1 ist "maximized"'
else
	? 'Window 1 ist nicht "maximized"'
endif

wait 'Status der Fenster festgestellt.  Klick...'

// Beide Fenster wieder herstellen
ShowWindow(toint(hWnd1), toint(SW_RESTORE))
ShowWindow(toint(hWnd2), toint(SW_RESTORE))

wait 'Beide Fenster wieder hergestellt.  Klick...'

// Window 1 on Top bringen
BringWindowToTop(toint(hWnd1))
// Das Fenster zum aktiven Fenster machen
SetFocus(toint(hWnd1))

wait 'Window 1 on Top gebracht.  Klick...'

// Position und Gre eines Fensters ndern
// Alle Koordinaten sind in Pixel
// Parms: window handle, left, top, width, height, repaint
MoveWindow(toint(hWnd1), toint(100), toint(50), toint(300), toint(100), .T.)
SetFocus(toint(hWnd1))

wait 'Window 1 bewegt und Gre verndert.  Fertig.'