// SCROLL.PRG -->German version
//
| Scrollbar Demo-Programm

set procedure to scroll
|Umrahmung aus einfacher Linie & Titelzeile 
|+ Gre nderbar + Vertikale Bildlaufleiste(scroll)
set window type to 1+16+64		
create window "scroll" from 7,20 to 20,60
set window title to "Scroll Bar Demo"
|Vertikale Scrollbar auf Anfang setzen
setscroll(1,1)					
|auf 1. Zeile setzen
nline=0							
|Ausgabe
drawwin(nline)					
|Event-Schleife
do while .t.					
	nevent=getevent()
	naction=translateevent(nevent)
	perform(naction)
enddo
return

|Zeilen ausgeben, beginnend mit der Zeile, die als Parameter bergeben 
|wurde. Rckgabewert ist der Wert, der bergeben wurde.
function drawwin()
parameter nline
private ncline

	ncline=1
	clear
	?? "Line "+str(nline)
	do while ncline<=wrow()-1
		? "Line "+str(nline+ncline)
		inc ncline
	enddo
return(nline)

| Auf einen Event warten und den entspr. chkevent()-Wert zurckliefern
function getevent()
private nevent

	nevent=chkevent()
	do while nevent=-1
		nevent=chkevent()
	enddo
return(nevent)

| Die Events in ausfhrbare Befehle wandeln. Hauptaufgabe ist, die 
| Tastatur entsprechend zu untersttzen. Ist ein Event nicht 
| untersttzt, wird cNull zurckgegeben.
function translateevent()
parameter nevent

	do case
	case nevent=1			|Tastatur-Event
		do case
		case lastkey()=cnPgUp
			return(cPgUp)
		case lastkey()=cnPgDn
			return(cPgDn)
		case lastkey()=cnArUp
			return(cArUp)
		case lastkey()=cnArDn
			return(cArDn)
		otherwise
			message("Nicht untersttzte Taste gedrckt","")
			return(cNull)
		endcase
	case nevent=7		|Scrollbar-Event
		if hmenu()=0
			message("Horizontale Scrollbar nicht untersttzt","")
		endif
		do case
		case vmenu()=1	|Pfeilsymbol der Laufleiste oben angeklickt
			return(cArUp)
		case vmenu()=2	|Pfeilsymbol der Laufleiste unten angeklickt
			return(cArDn)
		case vmenu()=3
			return(cPgUp)
		case vmenu()=4
			return(cPgDn)
		case vmenu()=5
			return(cDrag)
		endcase
	endcase
return(cNull)

| Auf die Befehle, die TRANSLATEEVENT()schickt, reagieren. Liefert .t., 
| wenn eine Aktion ausgefhrt werden kann, sonst .f.
function perform()
parameter naction
private nline,nadjust

	if naction=cNull	|keine Aktion
		return(.f.)
	endif
	do case
	
|1 Zeile nach oben
	case naction=cArUp
		|aktuelle pos-1 holen
		nline=getscroll(1)-(1000/(cnLines-(wrow()-1)))	
		|nicht unter Position=1 gehen
		if nline<1										
			nadjust=1
		else
			nadjust=nline
		endif
		|Update der Scrollposition.
		setscroll(1,nadjust)								
		|in Zeilen wandeln.
		nline=round(nadjust/(1000/(cnLines-(wrow()-1))),0)	
		|Ausgabe
		drawwin(nline)										
		
|1 Zeile nach unten
	case naction=cArDn
		|aktuelle pos+1 holen
		nline=getscroll(1)+(1000/(cnLines-(wrow()-1)))	
		|nicht ber Position=1000 gehen
		if nline>1000									
			nadjust=1000
		else
			nadjust=nline
		endif
		|Update der Scrollposition.
		setscroll(1,nadjust)							
		|in Zeilen wandeln
		nline=round(nadjust/(1000/(cnLines-(wrow()-1))),0)
		|Ausgabe
		drawwin(nline)									
		
|1 Seite nach oben
	case naction=cPgUp
		|akt. Position holen - Anzahl Zeilen
		nline=getscroll(1)-(1000*(wrow()-1)/(cnLines-(wrow()-1)))
		|nicht unter 1 scrollen							
		if nline<1					
			nadjust=1
		else
			nadjust=nline
		endif
		|Update der Scrollposition
		setscroll(1,nadjust)							
		|In Zeilen wandeln
		nline=round(nadjust/(1000/(cnLines-(wrow()-1))),0)
		|Ausgabe
		drawwin(nline)									
		
|1 Seite nach unten
	case naction=cPgDn
		|akt. Position + Anzahl Zeilen
		nline=getscroll(1)+(1000*(wrow()-1)/(cnLines-(wrow()-1)))
		|nicht ber 1000 scrollen						
		if nline>1000			
			nadjust=1000
		else
			nadjust=nline
		endif
		|Update der Scrollposition
		setscroll(1,nadjust)							
		|In Zeilen wandeln
		nline=round(nadjust/(1000/(cnLines-(wrow()-1))),0)
		|Ausgabe
		drawwin(nline)									

|Laufleiste verschoben
	case naction=cDrag
		|Position des 'Reglers' holen
		nline=mrow()			
		|Update der Position
		setscroll(1,mrow())		
		|In Zeilen wandeln
		nline=round(nline/(1000/(cnLines-(wrow()-1))),0)
		|nicht unter 1 scrollen
		if nline<1				
			nline=1
		|nicht ber 1000 scrollen
		elseif nline>cnLines-(wrow()-1)
								
			nline=cnLines-(wrow()-1)
		endif
		|Ausgabe
		drawwin(nline)			
	endcase
return(.t.)						|Aktion ausgefhrt