// SCRL.PRG -->German version
//
// Beispiel, wie der Standardbereich von 0-1000 von
// CREATE CONTROL SCROLLBAR berschrieben wird

// Konstanten festlegen
// Hinweis: die Differenz zwischen MIN und MAX darf 
// 32767 nicht berschreiten.
#define MAXRANGE1		10		// Maximum-Wert fr Scrollbar1
#define MINRANGE1		2		// Minimum-Wert fr Scrollbar1  
#define MAXRANGE2		500		// Maximum-Wert fr Scrollbar2
#define MINRANGE2		-150	// Minimum-Wert fr Scrollbar2  
#define SB_CTL 			2		// Scrollbar-Flag fr DLL-Funktion

set procedure to scrl

// Deklaration der Funktionen aus der Windows-DLL USER.EXE
declare pfunc SetScrollRange returning integer in dll user.exe
declare pfunc SetScrollPos returning integer in dll user.exe

// Position des Scrollbar-'Reglers', anfangs auf die Minimum-Werte 
// gesetzt.
nScrlVal1 = MINRANGE1
nScrlVal2 = MINRANGE2

// Scrollbars erzeugen
@ 1,30 say 'Scroll Bar 1'
create control scrollbar 'Scroll1' at 2,30 size 1,20 save to nScrlVal1 horizontal step 2 valid ScrlValid1()
@ 4,33 say 'Scroll Bar 2'
create control scrollbar 'Scroll2' at 4,30 size 20,2 save to nScrlVal2 step 50 valid ScrlValid2()

// handles der Scrollbars holen
hScroll1 = hwnd('Scroll1')
hScroll2 = hwnd('Scroll2')

// Scrollbar-Bereich setzen; darauf achten, da die Parameter 
// per TOINT() bergeben werden!
SetScrollRange (toint(hScroll1), toint(SB_CTL), toint(MINRANGE1), toint(MAXRANGE1), .F.)
SetScrollRange (toint(hScroll2), toint(SB_CTL), toint(MINRANGE2), toint(MAXRANGE2), .F.)

// Anfangsposition setzen,
// wichtig, wenn der Min-Wert negativ ist.
SetScrollPos (toint(hScroll1), toint(SB_CTL), toint(MINRANGE1), .T.)
SetScrollPos (toint(hScroll2), toint(SB_CTL), toint(MINRANGE2), .T.)

// Anfangswerte ausgeben
@ 0,0
@ 1,1 say 'Scrollbar 1: ' + alltrim(str(nScrlVal1))
@ 2,1 say 'Scrollbar 2: ' + alltrim(str(nScrlVal2))

// Check Event Loop: ESC beendet dies Progrmmelchen
do while lastkey() <> 27
	myevent = chkevent()
	do while myevent = -1
		myevent = chkevent()
	enddo
enddo

// valid function fr scrollbar1
function ScrlValid1()
	// prfen, ob der Benutzer ber den Maximumwert gehen wollte
	if nScrlVal1 > MAXRANGE1
		nScrlVal1 = MAXRANGE1
	endif
		
	// prfen, ob der Benutzer unter den Minimumwert gehen wollte
	if nScrlVal1 < MINRANGE1
		nScrlVal1 = MINRANGE1
	endif
	
	// Position setzen
	SetScrollPos (toint(hScroll1), toint(SB_CTL), toint(nScrlVal1), .T.)
	
	@ 1,1 clear to 1,20
	@ 1,1 say 'Scrollbar 1: ' + alltrim(str(nScrlVal1))
return .t.

// valid function fr scrollbar2
function ScrlValid2()
	// prfen, ob der Benutzer ber den Maximumwert gehen wollte
	if nScrlVal2 > MAXRANGE2
		nScrlVal2 = MAXRANGE2
	endif
		
	// prfen, ob der Benutzer unter den Minimumwert gehen wollte
	if nScrlVal2 < MINRANGE2
		nScrlVal2 = MINRANGE2
	endif
	
	// Position setzen
	SetScrollPos (toint(hScroll2), toint(SB_CTL), toint(nScrlVal2), .T.)

	@ 2,1 clear to 2,20
	@ 2,1 say 'Scrollbar 2: ' + alltrim(str(nScrlVal2))
return .t.
