*:*****************************************************************************
*:
*: Procedure file: C:\DBFAST20\PRUEF.PRG
*:
*:         System: Clipper Source Code Examiner
*:         Author: Ed Chyzowski
*:      Copyright (c) 1992, Computer Associates
*:  Last modified: 12/10/92     
*:
*:  Procs & Fncts: EXAMINE_GETEVENT()
*:               : EXAMINE_TRANSLATE()
*:               : EXAMINE_ACTION
*:               : CHECK()
*:               : STANDARDCHECK()
*:               : NONSTANDARDCHECK()
*:               : CHECKFUNCTIONS()
*:               : CHECKCOMMANDS()
*:               : MULTDECLARE()
*:               : CHECKINCLUDE()
*:
*:          Calls: DBFMENU()          (function  in DBFNRUN.EXE)
*:               : WARNING()          (function  in DBFNRUN.EXE)
*:               : EXAMINE_GETEVENT() (function  in PRUEF.PRG)
*:               : EXAMINE_TRANSLATE()(function  in PRUEF.PRG)
*:               : EXAMINE_ACTION     (procedure in PRUEF.PRG)
*:               : STANDARDCHECK()    (function  in PRUEF.PRG)
*:               : NONSTANDARDCHECK() (function  in PRUEF.PRG)
*:               : MULTDECLARE()      (function  in PRUEF.PRG)
*:               : CHECKINCLUDE()     (function  in PRUEF.PRG)
*:               : CHECKFUNCTIONS()   (function  in PRUEF.PRG)
*:               : CHECKCOMMANDS()    (function  in PRUEF.PRG)
*:
*:    Other Files: INFILENAME
*:               : OUTFILENAME
*:
*:  
*:*****************************************************************************




SET PROCEDURE TO PRUEF
SET EVENTMSK TO 159


set erase video to 112
ERASE

SET WINDOW TITLE TO "Clipper-Quellcode-Prfer"

PUBLIC nCurrentLine
PUBLIC Message
PUBLIC ProblemLine
PUBLIC MultLineComment
PUBLIC CRLF

STORE 0  TO nTheMenu, nTheOption, nTheKey
STORE '' TO sTheWindow, sTheButton
SVAR            = SPACE(25)
CRLF            = CHR(13)+CHR(10)
Message         = ""
MultLineComment = .F.
ProblemLine     = .F.
sCurrentline    = Space(255)
ncurrentline    = 0
nReadBytes      = 1
cCheckLine      = "CA-dBFast 2.0 Konvertierungsmeldung:  Untere Zeile prfen "


CREATE CONTROL GROUPBOX "Group1" AT 0,0 SIZE 12,55 TEXT "Dateistatus"
CREATE BUTTON "Abbrechen" AT 1,57 SIZE 2,18
CREATE CONTROL TEXT "Text4" AT 2,12 TEXT "Programmname" COLOR 117 FONT 0
CREATE CONTROL TEXT "Proz" AT 3,12 TEXT  " Fortschritt" COLOR 117 FONT 0
CREATE CONTROL TEXT "Text5" AT 4,10 TEXT "Aktuelle Zeile" COLOR 117 FONT 0
CREATE CONTROL TEXT "TextB" AT 5,7 TEXT "   Gesamte Zeilen" COLOR 117 FONT 0
CREATE BUTTON "Neue Datei" AT 4,57 SIZE 2,18 PLAIN
CREATE BUTTON "Beenden" at 8,57 SIZE 1,18 PLAIN

CREATE CONTROL TEXT "Text6" AT 7,15 TEXT "Zieldatei" COLOR 126 FONT 0
CREATE CONTROL TEXT "Schreiben" AT 9,4 TEXT "     Aktuelle Aktion" COLOR 117 FONT 0
CREATE CONTROL TEXT "Text1" AT 13,1 TEXT "Ergebnisse der Prfung" COLOR 112 FONT 0
CREATE CONTROL EDITBOX "Edit1" AT 14,0 SIZE 12,78 SAVE TO M->MESSAGE COLOR 240

UPDATE CONTROL ALL

sAction = '?'

SET CURSOR TO ARROW
CheckingFiles = .t.
DISABLE BUTTON 'Neue Datei'

DoTheRightThing = About()
If .not. DoTheRightThing
    Return
Endif


DO WHILE CheckingFiles
      
   Message = ""
   infilename = DBFMENU("Programmdateien,*.PRG","Programm eingeben, das geprft werden soll",1)
   
   if Empty(inFileName)
      Exit
   Endif
   
   ninhandle = FOPEN(infilename)
   If ninhandle = -1
      Warning("Weitere Ausfhrung nicht mglich","Dateifehler",3)
      Exit
   ENDIF
   
   Set SAY VIDEO to 112

   TotalFileBytes = FILESIZE(infilename)
   CurrentFileBytes = 0

   outfilename = SUBSTR(infilename,1,AT(".",infilename)-1)+".D20"
   Message = "Neue Datei wird erstellt: "+outfilename
   nOuthandle = FCREATE(outFilename)
   IF nOutHandle = -1
      Warning("Weitere Ausfhrung nicht mglich","Externe Datei kann nicht erstellt werden",3)
      Exit
   ENDIF
   
   set say video to 112
   if len(infilename)>25
            @ 2,26 SAY substr(infilename,len(infilename)-24,25)    
                @ 7,26 SAY substr(outfilename,len(outfilename)-24,25) 
   else
                @ 2,26 say infilename
                @ 7,26 say outfilenamd
   endif
   
   DO WHILE .NOT. EMPTY(sAction) .and. nReadBytes > 0
      
      nEvent  = EXAMINE_GetEvent()
      
          * UPDATE CONTROL 'Edit1'
          
      If nEvent <> -1
         
         sAction = EXAMINE_Translate(nEvent)
         DO EXAMINE_Action
         
      Else
         
         @ 9,26 say "Lesen........."
         nReadBytes = FGETS(@sCurrentLine,250,ninHandle)
         
         @ 5,26 say Transform(nReadBytes,"999,999")
         
         If nReadBytes > 0
            
            CurrentFileBytes = CurrentFileBytes+nReadBytes+2
            @ 3,26 say Transform((CurrentFileBytes/TotalFileBytes)*100,"999.9")+" %"
            
            Inc nCurrentLine
            * Removed this line due to length bug in Dec version of 2.0
            * Message = Message+CRLF+"Zeile "+Transform(nCurrentLine,"9999")
            @ 4,26 SAY Transform(nCurrentLine,"999,999")
            
            If SubStr(sCurrentLine,1,1) <> "*"
               
               nOffset = 0
               
               sCurrentLine = StandardCheck(sCurrentLine)
               
               sCurrentLine = NonStandardCheck(sCurrentLine)
               
               sCurrentLine = MultDeclare(SCurrentLine)
               
               sCurrentLine = CheckInclude(sCurrentLine)
               
               sCurrentLine = CheckFunctions(sCurrentLine)
               
               sCurrentLine = CheckCommands(sCurrentLine)
               
               
            Else
               
               * Kommentarzeile (berspringen)
               
            Endif
            
            @ 9,26 say "Schreiben........."
            
            If MultLineComment
               nBytesWritten = FPUTS("* "+sCurrentLine,nOutHandle)
            else
               If ProblemLine
                  nBytesWritten = FPUTS("*:DB20?  "+sCurrentLine,nOutHandle)
               else
                  nBytesWritten = FPUTS(sCurrentLine,nOuthandle)
               Endif
            Endif
            
            * Setzt ProblemLine nach jedem Schreibzugriff auf .F.
            ProblemLine = .F.
            
            If nBytesWritten < 1
               Message("Schreibfehler","in "+OutFile)
            endif
            
         Endif
         
         If nReadBytes = 0 .and. ( FERROR() <> 39 .and. FERROR() <> 83 )
            nBytesWritten = FPUTS("",nOutHandle)
            nReadBytes = 1
         endif
         
         
         
      ENDIF
      
      
      sAction = '?'
      
      
   ENDDO
   
   Message = Message+CRLF+"Dateien werden geschlossen"

   FClose(nInHandle)
   FClose(nOuthandle)
   @ 3,26 say Transform(100,"999.9")+" %"
   @ 9,26 say "fertig............"
   UPDATE CONTROL 'Edit1'
        
   Warning("SCHLIESSEN","Prfung beendet"+inFilename,388)
   
   ENABLE BUTTON 'Neue Datei'
   DISABLE BUTTON 'Abbrechen'
   
   Do While .T.
          nEvent = -1
      nEvent = Chkevent()
      If nEvent = 6
         If Button() = 'Beenden'
            CheckingFiles = .F.
            Exit
         endif
         If Button() = 'Neue Datei'
            CheckingFiles = .t.
            nReadBytes=1
            Exit
         Endif
      endif
   enddo      
   
      
ENDDO


QUIT




*!*****************************************************************************
*!
*!       Function: EXAMINE_GETEVENT()
*!
*!      Called by: PRUEF.PRG                       
*!
*!          Calls: CHKEVENT()         (function  in ?)
*!               : HMENU()            (function  in ?)
*!               : VMENU()            (function  in ?)
*!               : BUTTON()           (function  in ?)
*!
*!*****************************************************************************
FUNCTION EXAMINE_GetEvent()
   
   PRIVATE nTheEvent
   
   nTheEvent = CHKEVENT()
   nTheRow    = MROW()
   nTheCol    = MCOL()
   nTheMenu   = HMENU()
   nTheOption = VMENU()
   nTheKey    = LASTKEY()
   sTheButton = BUTTON()
   RETURN(nTheEvent)



*!*****************************************************************************
*!
*!       Function: EXAMINE_TRANSLATE()
*!
*!      Called by: PRUEF.PRG                       
*!
*!*****************************************************************************
FUNCTION EXAMINE_Translate()
   
   PARAMETER nTheEvent
   PRIVATE sTheAction
   
   sTheAction = ' '
   DO CASE
   CASE nTheEvent = eClose
      sTheAction = 'SCHLIESSEN'
      
      
   CASE nTheEvent = eButton
      DO CASE
      CASE sTheButton = 'Abbrechen'
         sTheAction = 'Abbrechen'
      CASE sTheButton = 'Weiter'
         sTheAction = 'Weiter'
      ENDCASE
      
   OTHERWISE
      sTheAction = '?'
   ENDCASE
   RETURN(sTheAction)



*!*****************************************************************************
*!
*!      Procedure: EXAMINE_ACTION
*!
*!      Called by: PRUEF.PRG                       
*!
*!          Calls: WARNING()          (function  in ?)
*!
*!*****************************************************************************
PROCEDURE EXAMINE_Action
   
   
   DO CASE
   CASE sAction = 'SCHLIESSEN'
      sAction = ''
      
   CASE sAction = 'Abbrechen'
      nRetVal = Warning("Sie haben ABBRECHEN gewhlt","Sind Sie sicher?",3)
      If nRetVal = 1
         * OK wurde gewhlt
         sAction = ''
      Endif
      
   ENDCASE
   RETURN




*!*****************************************************************************
*!
*!       Function: CHECK()
*!
*!      Called by: STANDARDCHECK()    (function  in PRUEF.PRG)
*!               : NONSTANDARDCHECK() (function  in PRUEF.PRG)
*!               : CHECKFUNCTIONS()   (function  in PRUEF.PRG)
*!               : CHECKCOMMANDS()    (function  in PRUEF.PRG)
*!               : MULTDECLARE()      (function  in PRUEF.PRG)
*!               : CHECKINCLUDE()     (function  in PRUEF.PRG)
*!
*!*****************************************************************************
FUNCTION Check
   Parameters ForWhat, InWhat
   RETURN( AT(UPPER(ForWhat),UPPER(InWhat)) )


*!*****************************************************************************
*!
*!       Function: STANDARDCHECK()
*!
*!      Called by: PRUEF.PRG                       
*!
*!          Calls: CHECK()            (function  in PRUEF.PRG)
*!
*!*****************************************************************************
FUNCTION StandardCheck
   PARAMETERS InStr
   @ 9,26 say "Standard-Prfung.."
   
   
   ChByte = Check("ErrorLevel(",InStr)
   If chbyte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"ERRORLEVEL konvertiert bei Byte "+Transform(chbyte,"999")
      InStr = STRTRAN(inStr,SUBSTR(InStr,Chbyte,Len("ErrorLevel(")),"Error(")
   endif
   
   ChByte = Check("!=",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von != in <> bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,"!=","<>")
   Endif
   
   ChByte = Check("SELECT 0",InStr)
   if ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Programmierhinweis: Arbeitsbereiche an dieser Zeile prfen"
      cPrLine = "* CA-dBFast-2.0-Konvertierungsmeldung:  Untere Zeile prfen"+CRLF
      cAfLine = CRLF+"* Obere Zeile prfen"
      InStr = cPrLine+InStr+cAfLine
   Endif
   
   ChByte = Check("!",InStr)
   If ChByte > 0
      OK2Change = .T.
      For ExamineByte = Iif(ChByte-3 < 1,1,ChByte-3) to iif(chByte+3 > Len(InStr),Len(InStr),ChByte+3 )
         If SubStr(InStr,ExamineByte,1) = "'" .or.;
               SubStr(InStr,ExamineByte,1) = '"'
            Ok2Change = .F.
         Endif
      NEXT
      if OK2Change
         Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von ! in .NOT. bei Byte "+Transform(chByte,"999")
         InStr = STRTRAN(inStr,"!=","<>")
      Endif
   Endif
   
   ChByte = Check("==",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von == in = bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,"==","=")
   Endif
   
   ChByte = Check("End",InStr)
   if ChByte > 0      
      If AllTrim(upper(InStr)) = "END"
            Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Programmierhinweis: Prfen Sie END auf ENDDO/ENDIF bei dieser Zeile"
            cPrLine = "*:DB20? Konvertierungsmeldung:  Untere Zeile auf ENDIF/ENDDO prfen"+CRLF
            cAfLine = CRLF+"*:DB20? Obere Zeile prfen"
            InStr = cPrLine+InStr+cAfLine
            Release cPrLine
            Release cAfLine
         Endif
      Endif
      
   
   ChByte = Check("While",InStr)
   If chbyte > 0
      SecondCheck = Check("DO WHILE",InStr)
      If SecondCheck < 1        && Kein DO WHILE gefunden
         nNumQuotes = 0
         For ExamineByte = 1 to chByte
            if SubStr(InStr,ExamineByte,1) = "'" .or. ;
                  SubStr(InStr,ExamineByte,1) = '"'
               Inc nNumQUotes
            endif
         NEXT
         If ((nNumQuotes/2 = Int(nNumQuotes/2)) .or. nNumQuotes = 0) .and. ;
            LEFT(UPPER(INSTR),5) <> "WHILE"
            Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von WHILE in DO WHILE bei Byte "+Transform(chbyte,"999")
            cPrLine = "*:DB20? Konvertierungsmeldung:  Untere Zeile auf DO WHILE prfen"+CRLF
            cAfLine = CRLF+"*:DB20? Prfen Sie die obere Zeilenkonvertierung"
            InStr = cPrLine+STRTRAN(upper(instr),"WHILE","DO"+" "+"WHILE")+cAfLine
         Endif
         
      Endif
      Release SecondCheck
   endif
   
   ChByte = Check(":=",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konv. von := in = bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,":=","=")
   Endif
   
   ChByte = Check("*/",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von */ in * bei Byte "+Transform(chByte,"999")
      MultLineComment = .F.
      InStr = STRTRAN(inStr,"*/","*")
   Endif

   ChByte = Check("/*",InStr)
   If ChByte > 0
        MultLineComment = .T.
        Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von /* in * bei Byte "+Transform(chByte,"999")
        InStr = STRTRAN(inStr,"/*","*")
   Endif

   
   ChByte = Check("//",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von // in "+CHR(38)+CHR(38)+" bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,"//",CHR(38)+CHR(38))
   Endif
   
   ChByte = Check("**",InStr)
   If ChByte > 0
      IF ASC(SubStr(InStr,ChByte+3,1)) < 48 .and. ASC(SubStr(inStr,ChByte+3,1)) > 57
         Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von ** in ^ bei Byte "+Transform(chByte,"999")
         InStr = STRTRAN(inStr,"**","^")
      Endif
   Endif
   
   ChByte = Check("%",InStr)
   If ChByte > 0
      IF ASC(SubStr(InStr,ChByte+1,1)) >= 48 .and. ASC(SubStr(inStr,ChByte+1,1)) <= 57
         Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von % in \ bei Byte "+Transform(chByte,"999")
         InStr = STRTRAN(inStr,"%","\")
      Endif
   Endif
   return(InStr)

*!*****************************************************************************
*!
*!       Function: NONSTANDARDCHECK()
*!
*!      Called by: PRUEF.PRG                       
*!
*!          Calls: CHECK()            (function  in PRUEF.PRG)
*!
*!*****************************************************************************
FUNCTION NonStandardCheck
   Parameters InStr
   @ 9,26 say "Kein Standard....."
   
   
   
   ChByte = Check("Replace Field_Name",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von FIELD_NAME bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,SubStr(InStr,ChByte,Len("Replace Field_name")),"* Replace Field_Name")
   Endif
   
   
   ChByte = Check("Replace Field_Type",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von FIELD_TYPE bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,SubStr(InStr,ChByte,Len("Replace Field_Type")),"* Replace Field_Type")
   Endif
   
   
   ChByte = Check("Replace Field_Len",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von FIELD_LEN  bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,SubStr(InStr,ChByte,Len("Replace Field_LEN")),"* Replace Field_Len")
   Endif
   
   
   ChByte = Check("Replace Field_Dec",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von FIELD_DEC bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,SubStr(InStr,ChByte,Len("Replace Field_Dec")),"* Replace Field_Dec")
   Endif
   
   
   ChByte = Check("#DEFINE",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Prfung der DEFINE-Anweisungen"
      LineOK = .T.
      FOR ExamineByte = 7 to Len(InStr)-1
         tst=UPPER(SubStr(InStr,ExamineByte,1))
         nVal = AT(tst,"ABCDEFGHIJKLMNOPQRSTUVWXYZ")
         If nVal > 0
            TestVal = "["+SubStr(inStr,ExamineByte-1,3)+"]"
            If SubStr(InStr,ExamineByte-1,1)$" "+CHR(8) .and. ;
                  SubStr(InStr,ExamineByte+1,1)$" "+CHR(8)
               LineOK = .F.
               Exit
            Endif
            
         Endif
      NEXT
      If .not. LineOK
         Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung der #DEFINE-Zeile bei Byte "+Transform(chByte,"999")
         InStr="*:DB20? Prfen Sie die untere #DEFINE-Zeile auf reservierte Buchstaben"+CRLF+inStr
      Endif
      Release LineOK
   Endif
   
   
   
   ChByte = Check("Type(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung der TYPE()-Funktion bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Warnung: TYPE()-Funktionen mssen der Variablen einen Wert bergeben."+CRLF+InStr
   Endif
   
   Return(InStr)





*!*****************************************************************************
*!
*!       Function: CHECKFUNCTIONS()
*!
*!      Called by: PRUEF.PRG                       
*!
*!          Calls: CHECK()            (function  in PRUEF.PRG)
*!
*!*****************************************************************************
FUNCTION CheckFunctions
   Parameters InStr
   
   @ 9,26 say "Funktionen......."
   
   
   ChByte = Check("ACHOICE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("ADEL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("AINS(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("ALIAS(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("ALTD(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("ASORT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("BIN2L(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("BIN2W(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("DBEDIT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar.  Use CREATE OBJECT BROWSE"+CRLF+InStr
   Endif
   
   ChByte = Check("DBFILTER(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("DBRELATION(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("DBRSELECT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("HEADER(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("I2BIN(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("IF(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar. Use IFF()/IFN()/IFC()"+CRLF+InStr
   Endif
   
   ChByte = Check("ISPRINTER(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar. Use PRNTSTAT()"+CRLF+InStr
   Endif
   
   ChByte = Check("L2BIN(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("MLPOS(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("PCOUNT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("RESTSCREEN(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("SAVESCREEN(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("SCROLL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("SETCANCEL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("SETCOLOR(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? SETCOLOR() nicht zulssig. Verwenden Sie SET SAYVIDEO usw... "+CRLF+InStr
   Endif
   
   ChByte = Check("ADIR(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Funktionssyntax."+CRLF+;
         "*:DB20? Verwenden Sie ADIR(ExpC [@Array1])"+CRLF+InStr
   Endif
   
   
   ChByte = Check("FWRITE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Funktionssyntax."+CRLF+;
         "*:DB20? Verwenden Sie FWRITE(expN1, @varC, expN2)"+CRLF+InStr
   Endif
   
   ChByte = Check("LEN(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Funktionssyntax. LEN() untersttzt keine Arrays"+CRLF+;
         "*:DB20? Verwenden Sie LEN(ExpC)"+CRLF+InStr
   Endif
   
   ChByte = Check("MEMOEDIT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Funktionssyntax."+CRLF+;
         "*:DB20? Verwenden Sie MEMOEDIT(expC [,expN1, expN2, expN3, expN4 [,expL1]])"+CRLF+InStr
   Endif
   
   ChByte = Check("MEMOLINE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Funktionssyntax."+CRLF+;
         "*:DB20? Verwenden Sie MEMOLINE(expC ,expN1, expN2)"+CRLF+InStr
   Endif
   
   ChByte = Check("MEMORY(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Funktionssyntax."+CRLF+;
         "*:DB20? Verwenden Sie MEMORY() statt MEMORY(<expN>)"+CRLF+InStr
   Endif
   
   ChByte = Check("MLCOUNT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Funktionssyntax."+CRLF+;
         "*:DB20? Verwenden Sie MLCOUNT(expC ,expN1)"+CRLF+InStr
   Endif
   
   ChByte = Check("SELECT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Funktionssyntax."+CRLF+;
         "*:DB20? Verwenden Sie SELECT([<expN>]) ohne den Aliasnamen"+CRLF+InStr
   Endif
   
   ChByte = Check("CURDIR(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von CURDIR() bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(UPPER(inStr),"CURDIR(","CURRENTDIR(")
   Endif
   
   ChByte = Check("ERRORLEVEL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von ERRORLEVEL() bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(UPPER(inStr),"ERRORLEVEL(","ERROR(")
   Endif
   
   ChByte = Check("GETE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Konvertierung von GETE() bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(UPPER(inStr),"GETE(","GETENV(")
   Endif
   
   
   ChByte = Check("AADD(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("ACLONE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("AEVAL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Code-Blocks werden noch nicht untersttzt."+CRLF+InStr
   Endif
   
   
   ChByte = Check("ARRAY(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("ASIZE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("BROWSE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Verwenden Sie CREATE OBJECT BROWSE statt BROWSE(). "+CRLF+InStr
   Endif
   
   ChByte = Check("DBCREATE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("DBEVAL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Code-Blocks werden noch nicht untersttzt."+CRLF+InStr
   Endif
   
   ChByte = Check("DBSTRUCT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("DEVICEPOS(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("DIRECTORY(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("ERRORBLOCK(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Code-Blocks werden noch nicht untersttzt."+CRLF+InStr
   Endif
   
   ChByte = Check("EVAL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Code-Blocks werden noch nicht untersttzt."+CRLF+InStr
   Endif
   
   ChByte = Check("FERASE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("FKLABEL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("FKMAX(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("FRENAME(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Verwenden Sie RENAME FILE statt FRENAME()"+CRLF+InStr
   Endif
   
   ChByte = Check("ISDIGIT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("MAXCOL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktionsnderung MAXCOL() > BOTCOL()"+CRLF+STRTRAN(UPPER(InStr),"MAXCOL(","BOTCOL(")
   Endif
   
   ChByte = Check("MAXROW(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Funktionsnderung MAXROW() > BOTROW()"+CRLF+STRTRAN(UPPER(InStr),"MAXROW(","BOTROW(")
   Endif
   
   ChByte = Check("PAD(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion wird nicht untersttzt"+CRLF+InStr
   Endif
   
   ChByte = Check("QOUT(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion wird nicht untersttzt"+CRLF+InStr
   Endif
   
   ChByte = Check("READMODAL(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion wird nicht untersttzt"+CRLF+InStr
   Endif
   
   ChByte = Check("SET(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion wird nicht untersttzt"+CRLF+InStr
   Endif
   
   ChByte = Check("SETCURSOR(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion wird nicht untersttzt"+CRLF+InStr
   Endif
   
   ChByte = Check("SETKEY(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion wird nicht untersttzt"+CRLF+InStr
   Endif
   
   
   ChByte = Check("SETPOS(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion wird nicht untersttzt"+CRLF+InStr
   Endif
   
   ChByte = Check("VALTYPE(",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Clipper-5.01-Funktion wird nicht untersttzt"+CRLF+InStr
   Endif
   
   Return(InStr)



*!*****************************************************************************
*!
*!       Function: CHECKCOMMANDS()
*!
*!      Called by: PRUEF.PRG                       
*!
*!          Calls: CHECK()            (function  in PRUEF.PRG)
*!
*!*****************************************************************************
FUNCTION CheckCommands
   Parameters InStr
   @ 9,26 say "Befehle........"
   
   
   ChByte = Check("LOCAL",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"LOCAL bei Byte "+Transform(chByte,"999")
      InStr = STRTRAN(inStr,SubStr(InStr,ChByte,Len("LOCAL")),"* LOCAL")
   Endif
   
   ChByte = Check("STATIC",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"STATIC bei Byte "+Transform(chByte,"999")
      * ndert due in 'bug'
      ntemp1 = SubStr(Instr,ChByte,6)
      ntemp2 = "*STATIC"
      InStr = STRTRAN(inStr, ntemp1, ntemp2 )
      release ntemp
   Endif
   
   ChByte = Check("SET MESSAGE TO",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? nderung der Befehlssyntax."+CRLF+;
         "*:DB20? Verwenden Sie SET MESSAGE TO expC "+CRLF+InStr
   Endif
   
   ChByte = Check(" CALL ",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Befehl ist nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("CLEAR TYPEAHEAD",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Befehl ist nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("EXTERNAL ",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Befehl ist nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("SET FUNCTION ",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Befehl ist nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("SET KEY ",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Befehl ist nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("SET SCOREBOARD ",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Befehl ist nicht verfgbar."+CRLF+InStr
   Endif
   
   ChByte = Check("SET TYPEAHEAD ",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Befehl ist nicht verfgbar."+CRLF+InStr
   Endif
   
   
   ChByte = Check("SET WRAP O",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Kommentar bei Byte "+Transform(chByte,"999")
      InStr = "*:DB20? Befehl ist nicht verfgbar."+CRLF+InStr
   Endif
   
   
   Return(InStr)


*!*****************************************************************************
*!
*!       Function: MULTDECLARE()
*!
*!      Called by: PRUEF.PRG                       
*!
*!          Calls: CHECK()            (function  in PRUEF.PRG)
*!
*!*****************************************************************************
FUNCTION MultDeclare
   Parameters InStr
   @ 9,26 say "Zuweisungen........"
   
   ChByte = Check("DECLARE",InStr)
   If ChByte > 0
      
      CommaLoc = AT(",",InStr)
      If CommaLoc > 0
         NewDec = SubStr(InStr,1,CommaLoc-1)+CRLF
         LastPos = CommaLoc+1
         FOR CPos = CommaLoc+1 to Len(InStr)
            If SubStr(InStr,CPos,1) = ","
               NewDec = NewDec+"DECLARE "+SubStr(InStr,LastPos,CPos-LastPos)
               LastPos = CPos+1
            Endif
         NEXT
      ENDIF
   Endif
   Return(InStr)

*!*****************************************************************************
*!
*!       Function: CHECKINCLUDE()
*!
*!      Called by: PRUEF.PRG                       
*!
*!          Calls: CHECK()            (function  in PRUEF.PRG)
*!
*!*****************************************************************************
FUNCTION CheckInclude
   Parameters InStr
   @ 9,26 say "Includes........"
   
   ChByte = Check("#Include",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von #Include bei Byte "+Transform(chByte,"999")
      ProblemLine = .T.
   Endif
   
   ChByte = Check("#Ifdef",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von #Ifdef bei Byte "+Transform(chByte,"999")
      ProblemLine = .T.
   Endif
   
   ChByte = Check("#Ifndef",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von #Ifndef at byte "+Transform(chByte,"999")
      ProblemLine = .T.
   Endif
   
   ChByte = Check("#undef",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von #Undef at byte "+Transform(chByte,"999")
      ProblemLine = .T.
   Endif
   
   ChByte = Check("#Command",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von #Command at byte "+Transform(chByte,"999")
      ProblemLine = .T.
   Endif
   
   ChByte = Check("#Translate",InStr)
   If ChByte > 0
      Message=Message+CRLF+"Zeile "+Transform(nCurrentLine,"99999")+":  "++"Markierung von #Translate at byte "+Transform(chByte,"999")
      ProblemLine = .T.
   Endif
   Return(InStr)


Function About()
SET WINDOW TYPE TO 49
CREATE WINDOW "INTRO" AT 3,4 TO 24,75
SELECT WINDOW "INTRO" VIEW
SET WINDOW TITLE TO "ber das Prfprogramm"

set erase video to 144
ERASE
SET CURSOR TO WAIT

*: Deklariert PUBLIC-Variablen und initialisiert 
*: Speichervariablen.
PUBLIC nTheMenu, nTheOption, nTheKey, sTheWindow, sTheButton

*: Erstellt Steuerungselemente (Buttons usw.)
CREATE CONTROL RECTANGLE "BX1" AT 1,8 SIZE 6,56 COLOR 154 WIDTH 1
SET Font 15 To "Arial",16,"BAV"
CREATE CONTROL TEXT "Intro1" AT 2,15 TEXT "CA-Clipper Source-Code-Prfer" COLOR 159 FONT 15
CREATE CONTROL TEXT "Intro2" AT 4,31 TEXT "Version 1.0" COLOR 159 FONT 0
CREATE CONTROL TEXT "Intro3" AT 5,26 TEXT "Geschrieben von Ed Chyzowski" COLOR 159 FONT 0

CREATE CONTROL TEXT "Intro4" AT 7,5 TEXT "Diese Anwendung liest Clipper-Source-Code und macht" COLOR 156 FONT 0
CREATE CONTROL TEXT "Intro5" AT 8,7 TEXT "Vorschlge fr eine vereinfachte bertragung des" COLOR 156 FONT 0
CREATE CONTROL TEXT "Intro6" AT 9,11 TEXT "Quellcodes in die CA-dBFast-Umgebung." COLOR 156 FONT 0

SET Font 15 To "Arial",12,"BAV"
CREATE CONTROL TEXT "Intro7" AT 11,1 TEXT "Kein Programm zur Konvertierung von Clipper- in dBFast-Code" COLOR 158 FONT 15

CREATE CONTROL TEXT "Intro8" AT 13,4 TEXT "Das Programm soll dem Entwickler helfen, seine Anwendung" COLOR 157 FONT 0
CREATE CONTROL TEXT "Intro9" AT 14,13 TEXT "an CA-dBFast 2.0 anzupassen" COLOR 157 FONT 0
CREATE CONTROL TEXT "Intro10" AT 15,5 TEXT "Diese Anwendung wird ohne Garantie ausgeliefert." COLOR 159 FONT 0

CREATE BUTTON "Weiter" AT 18,19 SIZE 1,10
CREATE BUTTON "Beenden" AT 18,35 SIZE 1,10 PLAIN

UPDATE CONTROL ALL
SET CURSOR TO ARROW
WAIT ""
CLOSE WINDOW 'INTRO'
If Button() = 'Beenden'
   Return(.f.)
 else
   Return(.t.)
Endif
*: EOF: PRUEF.PRG
