*Programm GENERIC.PRG
*GENERIC.PRG war ursprnglich ein dBASE-Programm. Hinzugefgt 
*wurden eine Event-Schleife, ein Kontrollfeld und einige
*Steuerungselemente. Eine echte Windows-Anwendung wrde noch
*weitere Features aufweisen. Beachten Sie, da in diesem Programm
*eine VALID-Klausel besonderer Art enthalten ist. Das Befehlswort
*CHANGE bewirkt, da diese Klausel nur ausgewertet wird, wenn der 
*Benutzer die Daten tatschlich ndert. In diesem Fall wird CHANGE 
*benutzt, um den Index zu ndern. Wenn der Benutzer eine Personen-
*nummer eingibt, wird der entsprechende Index aktiviert. (PERS_NR 
*wird zum Schlsselfeld.) Wenn der Benutzer dagegen eine nderung 
*im Namensfeld vornimmt, wird der ursprngliche Index (Schlssel-
*feld NAME) reaktiviert.
*
*

#define ACTIVEGETS      1
#define READSAVE        2
#define WAITING         3
#define NORMAL          4

#define NO_EVENT               -1
#define KEYBD_EVENT             1
#define MENU_EVENT              2
#define SELECTWINDOW_EVENT      3
#define CLOSEWINDOW_EVENT       5
#define BUTTON_EVENT            6

#define OUREDIT         1
#define OURNEXT         2
#define OURPREV         3
#define OUREXIT         4
#define OURNEW          5
#define OURDELETE       6



SET PROCEDURE TO generic


set deleted on

PUBLIC begread, mode
STORE 1 TO begread
SET EXIT VIDEO TO 112

CREATE BUTTON ' Weiter ' AT 19,2
CREATE BUTTON ' Zurck ' AT 19,15
CREATE BUTTON 'Lschen' AT 19,28
CREATE BUTTON ' Neu  ' AT 19,40
CREATE BUTTON 'Abbrechen' AT 19,51
CREATE BUTTON ' Bearbeiten ' AT 19,64
mode = OUREDIT

DO PaintScreen
DO dispinfo

set exit video to sayvideo()

DO WHILE .T.
   ENABLE BUTTON ' Weiter '
   ENABLE BUTTON ' Zurck '
   ENABLE BUTTON 'Lschen'
   ENABLE BUTTON ' Neu  '
   ENABLE BUTTON 'Abbrechen'
   ENABLE BUTTON ' Bearbeiten '

   STORE name TO mname
   STORE pers_nr TO mpers_nr
   *Beachten Sie die CHANGE-Klauseln bei den folgenden
   *GET-Befehlen.
   @ 4,11 GET mname VALID chkname(mname) CHANGE MESSAGE ;
                'Gesuchter Name' ;
                        ERROR 'Name nicht gefunden'
   @ 4,58 GET mpers_nr VALID chkpers_nr(mpers_nr)        CHANGE MESSAGE ;
                'Gesuchte Kontonummer' ;
                ERROR 'Kontonummer nicht vorhanden'

   action = GetEvent(ACTIVEGETS,begread)
   action = TranslateEvent(action)

   IF .NOT. doevent(action,.F.)
      IF action = OUREXIT
         EXIT
      ENDIF
      LOOP
   ENDIF

   firstpass = .t.

   DO WHILE .T.
      IF action = OURNEW
         mode = OURNEW
         APPEND BLANK
         if firstpass
           @ 4,11 GET name
           @ 4,58 GET pers_nr
         endif
         DISABLE BUTTON ' Weiter '
         DISABLE BUTTON ' Zurck '
         DISABLE BUTTON 'Lschen'
         DISABLE BUTTON ' Neu  '
         DISABLE BUTTON ' Bearbeiten '
      ELSE
         DISABLE BUTTON ' Bearbeiten '
         DISABLE BUTTON ' Neu  '
         @ 4,11 SAY name
         @ 4,58 SAY pers_nr
         mode = OUREDIT
      ENDIF
        if firstpass
           @  8,14 GET strasse
           @  8,65 GET letzt_ktkt MESSAGE 'Datum des letzten Kontakts'
           @ 10,14 GET ort
           @ 12,14 GET land
           @ 12,38 GET plz
           @ 10,49 GET bemerkung editbox to 5,15
           @ 16,49 GET aktiv CHECKBOX 'Aktiv'
           @ 14,25 GET tel_firma PICTURE '(#####)#######'
           @ 16,25 GET tel_privat PICTURE '(#####)#######'
        endif

      action = GetEvent(READSAVE,0)
      action = TranslateEvent(action)
      IF doevent(action,.T.)
         EXIT
      ENDIF

      firstpass = .f.
      update gets
   ENDDO
   clear gets
ENDDO

RELEASE begread, mode
CLOSE ALL
RETURN

********************************************
PROCEDURE PaintScreen
********************************************

USE adrsbuch 
INDEX on pers_nr to tpers_nr
INDEX on name to tname
use adrsbuch index tname, tpers_nr

color = sayvideo()
*Hier wird die vom Benutzer eingestellte Farbe ermittelt, der
*Vordergrund ausgeblendet und schlielich 1 hinzugezhlt, um
*als Vordergrundfarbe blau zu aktivieren.
color = bitand(240,color) + 1
set say video to color
center('Erfassung von Kundendaten',1,0,78,10)
set color to

@  4,6  SAY 'Name'
@  4,43 SAY 'Kontonummer'
@  8,6  SAY 'Strae'
@ 10,6  SAY 'Ort'
@ 12,6  SAY 'Land'
@ 12,29 SAY 'Plz'
@ 14,6  SAY 'Tel. geschftlich'
@ 16,6  SAY 'Tel. privat'
@  8,49 SAY 'Letzter Kontakt'
@ 12,49 SAY 'Bemerkung'
@  7,4 TO 17,78
return


********************************************
FUNCTION chkname
********************************************
PARAMETER target

   SET INDEX TO tname
   SEEK TRIM(target)
   begread = 1
   IF .NOT. EOF()
      GETNO(30)
   ELSE
      GO BOTTOM
      RETURN(.F.)
   ENDIF
RETURN(.T.)


********************************************
FUNCTION chkpers_nr
********************************************
PARAMETER target

   SET INDEX TO tpers_nr
   SEEK TRIM(target)
   begread = 2
   IF .NOT. EOF()
      GETNO(30)
   ELSE
      GO BOTTOM
      RETURN(.F.)
   ENDIF
RETURN(.T.)


********************************************
FUNCTION doevent
********************************************
PARAMETER act, dflt

   DO CASE
      CASE act = OUREXIT
         IF mode = OUREDIT
            GOTO CURRENT
         ELSE
            UNPEND
         ENDIF
         RETURN(dflt)
      CASE act = 0                       |Falscher Eintrag
         RETURN(.F.)
      CASE act = OURNEXT
         SKIP
         IF EOF()
            SKIP -1
         ENDIF
         do dispinfo
         RETURN(.f.)
      CASE act = OURPREV
         SKIP -1
         IF BOF()
            SKIP
         ENDIF
         DO dispinfo
         RETURN(.F.)
      CASE act = OURDELETE
         DELETE
         SKIP
         IF EOF()
            SKIP -1
         ENDIF
         DO dispinfo
         RETURN(dflt)
   ENDCASE
RETURN(.T.)


********************************************
PROCEDURE dispinfo
********************************************

 @  8,14 SAY Strasse
 @ 10,14 SAY Ort
 @ 12,14 SAY Land
 @ 12,38 SAY Plz PICTURE '99999'
 @ 14,25 SAY Tel_firma PICTURE '(#####)#######'
 @ 16,25 SAY Tel_privat PICTURE '(#####)#######'
 @  8,65 SAY Letzt_ktkt 

RETURN


********************************************
function GetEvent
********************************************
parameter emode, getstart

  do case
    case emode = ACTIVEGETS
      if getstart > 0
        read starting with getstart
      else
        read
      endif
    case emode = READSAVE
      read save
    case emode = WAITING
      @ 0,0 say
      wait ""
    otherwise                                   |NORMAL
      return(chkevent())
   endcase
return(event())


********************************************
function TranslateEvent(ievent)
********************************************
parameter ievent

do case
  case ievent = KEYBD_EVENT
    key = LASTKEY()
    DO CASE
      CASE key = 27
        RETURN(OUREXIT)
      CASE key = 530
        RETURN(OURPREV)
      CASE key = 536
        RETURN(OURNEXT)
      OTHERWISE
        RETURN(OUREDIT)
    ENDCASE
  case ievent = BUTTON_EVENT            | Schaltflchen-Event
    STORE BUTTON() TO btext
    DO CASE
      CASE btext =  ' Weiter '
        RETURN(OURNEXT)
      CASE btext =  ' Zurck '
        RETURN(OURPREV)
      CASE btext =  'Lschen'
        RETURN(OURDELETE)
      CASE btext =  ' Neu  '
        RETURN(OURNEW)
      CASE btext =  'Abbrechen'
        RETURN(OUREXIT)
      CASE btext =  ' Bearbeiten '
    ENDCASE
 otherwise
   BEEP
   RETURN(0)
endcase
RETURN(OUREDIT)
