// EDITBOX.PRG -->German version
//
// Folgende Attribute knnen fr CREATE CONTROL EDITBOX gesetzt werden:
// 1) prfen, ob der Inhalt gendert wurde
// 2) Caret(Cursor) ein-/aus-schalten
// 3) die Editbox in ein Pawort-Eingabefeld wandeln
// 4) die Editbox READONLY setzen
// 5) nderungen wieder aufheben

// Windows API function calls
declare pfunc SendMessage returning integer in dll user.exe
declare pfunc HideCaret returning integer in dll user.exe
declare pfunc ShowCaret returning integer in dll user.exe

#define EM_GETMODIFY			1032
#define EM_UNDO					1047
#define EM_SETPASSWORDCHAR	1052
#define EM_SETREADONLY		1055

sSaveVar = ''

// Editbox anlegen
create control editbox 'Edit01' at 0,0 save to sSaveVar size 1,20

// window handle der Editbox holen
hWnd = HWND('Edit01')

@ 2,0 say
wait 

// Wurde der Inhalt der Editbox gendert?
// Der Rckgabewert ist ungleich 0, wenn der Inhalt gendert wurde
if (SendMessage(toint(hWnd), toint(EM_GETMODIFY), toint(0), tolong(0)))
	wait 'Inhalt wurde gendert'
else
	wait 'Inhalt wurde nicht gndert'
endif

// Cursor verbergen.
// Hinweis: Der Cursor erscheint fr einen kurzen Augenblick, 
// da die Editbox (von CA-dBFast) MIT Cursor erzeugt wurde. 
// Danach schalten wir ihn jedoch sofort aus.

HideCaret(toint(hWnd))
wait 'Der Cursor ist verborgen'

// Cursor anzeigen
ShowCaret(toint(hWnd))
wait 'Der Cursor wird angezeigt'


// Pawort-Zeichen auf dez. 42, entspricht '*', setzen.
// Das Pawortzeichen kann auf fast jedes Zeichen gesetzt werden.
// Hinweis: Dies funktioniert nicht mit einer mehrzeiligen Editbox
SendMessage(toint(hWnd), toint(EM_SETPASSWORDCHAR), toint(42), tolong(0))
// Zeichen ndern sich nicht, bis die Editbox 'upgedatet' wird
update control 'Edit01'
wait 'Pawort-Zeichen gesetzt'

// Inhalt der Editbox anzeigen
? sSaveVar
wait 'Inhalt der Editbox'

// Pawort-Zeichen ausschalten
SendMessage(toint(hWnd), toint(EM_SETPASSWORDCHAR), toint(0), tolong(0))
// Die Sterne werden solange angezeigt, bis die Editbox wieder 
// 'upgedatet' wird.
update control 'Edit01'
wait 'Pawort-Zeichen entfernt'

// READONLY setzen
SendMessage(toint(hWnd), toint(EM_SETREADONLY), toint(1), tolong(0))
wait 'Editbox ist READONLY'

// READONLY aufheben
SendMessage(toint(hWnd), toint(EM_SETREADONLY), toint(0), tolong(0))
wait 'READONLY aufgehoben'

// nderungen zurcksetzen
SendMessage(toint(hWnd), toint(EM_UNDO), toint(0), tolong(0))
wait 'nderungen zurckgesetzt'