// CASCADE.PRG -->German version
//
// Men-System mit Unter-Mens(cascading menus)
// Auch: ein Men einem beliebigen Fenster zuweisen
// HINWEIS: CA-dBFast kann nicht feststellen, in welchem 
//  Fenster ein Meneintrag ausgewhlt wurde. Deshalb sollten 
//  Sie kein Mensytem ber mehrere Fenster erstellen oder aber
//  sicher stellen , da die ID-Nummern unterschiedlich sind.
// Weitere Informationen finden Sie im Windows-SDK.

// Windows API function calls
declare pfunc CreateMenu returning integer in dll user.exe
declare pfunc CreatePopupMenu returning integer in dll user.exe
declare pfunc AppendMenu returning integer in dll user.exe
declare pfunc SetMenu returning integer in dll user.exe
declare pfunc FindWindow returning integer in dll user.exe
// DestroyMenu mu verwendet werden, wenn das Men an ein 
// CREATE WINDOW gebunden wurde, da sonst System-Ressourcen 
// verloren gehen !
declare pfunc DestroyMenu returning integer in dll user.exe
declare pfunc ModifyMenu returning integer in dll user.exe
declare pfunc DeleteMenu returning integer in dll user.exe

#define MF_STRING		0
#define MF_POPUP		16
#define MF_SEPARATOR	2048

// Einstellungen fr Meneintrge, die mit ModifyMenu 
// vorgenommen werden knnen.
// HINWEIS: MF_ENABLED und MF_UNCHECKED sind beide Null(0).
//  Deshalb, mu ein "checked" Eintrag, der ge-"grayed" ist, 
//  wieder ge-"checked" werden, wenn er "enabled" wird. 
#define MF_ENABLED		0
#define MF_GRAYED		1
#define MF_UNCHECKED	0
#define MF_CHECKED		8

// IDs fr die Men-Eintrge
#define IDM_FILE			100
#define IDM_OPEN			101
#define IDM_NEW				102
#define IDM_SAVE			103
#define IDM_SAVEFILE		150
#define IDM_SAVEPREFS		151

#define IDM_EXIT			104

#define IDM_EDIT			201


// Den Window-Handle fr CA-dBFast selbst holen.
// Fr gelinkte Applikationen 'CA-dBFast' durch den 
// App-Window-Namen ersetzen.
// 'tolong(0)' wird benutzt, um NULL an die function zu bergeben.
// Gleiches gilt fr alle anderen.
hWnd = FindWindow(tolong(0), 'CA-dBFast')

// OPTION: Window erzeugen. Bitte "HINWEIS" am Anfang dieser 
// Datei beachten.
// create window 'Window 1' from 2,2 to 20,40
// Get window handle of 'Window 1'
// hWnd = HWND()

// handle des popup 
hPopup = CreatePopupMenu()

// Meneintrge dem popup hinzufgen
// HINWEIS: das Zeichen "&" erzeugt den Unterstrich fr den Meneintrag
//  Es mu separat in Anfhrungszeichen gesetzt sein, andernfall wrde 
//  CA-dBFast es als Makro interpretieren. 
//  Benutzen Sie auch chr(9) als TAB, fr die Ausrichtung 
// der Accelerators.
AppendMenu(toint(hPopup), toint(MF_STRING), toint(IDM_OPEN), ""+"&"+"ffnen"+chr(9)+"Ctrl+F")

// handle fr das Untermen (cascaded popup)
hPopup2 = CreatePopupMenu()

// Eintrge dem Untermen anfgen
AppendMenu(toint(hPopup2), toint(MF_STRING), toint(IDM_SAVEFILE), "Speichern "+"&"+"Datei")
AppendMenu(toint(hPopup2), toint(MF_STRING), toint(IDM_SAVEPREFS), "Speichern "+"&"+"Standardeinstellungen")

// handle fr das Hauptmen
hMenu = CreateMenu()

// Haupmen aufbauen
AppendMenu(toint(hMenu), toint(MF_POPUP), toint(hPopup), "&"+"Datei")
AppendMenu(toint(hPopup), toint(MF_STRING), toint(IDM_NEW), "&"+"Neu")
AppendMenu(toint(hPopup), toint(MF_SEPARATOR), toint(0), tolong(0))
AppendMenu(toint(hPopup), toint(MF_POPUP), toint(hPopup2), "&"+"Speichern")
AppendMenu(toint(hPopup), toint(MF_SEPARATOR), toint(0), tolong(0))
AppendMenu(toint(hPopup), toint(MF_STRING), toint(IDM_EXIT), "E"+"&"+"xit")
AppendMenu(toint(hMenu), toint(MF_STRING), toint(IDM_EDIT), "&"+"Edit")

// Das Men dem Window zuordnen
SetMenu(toint(hWnd), toint(hMenu))

// durchlaufen bis Benutzer ESC drckt
do while lastkey() <> 27
	nEvent = chkevent()
	do while nEvent = -1
		nEvent = chkevent()
	enddo
	
	// wenn Benutzer-Event = Menzugriff...
	if (nEvent = 2)
		// hmenu() liefert den horizontalen Wert selektierten Mens
		? 'Horiz. Men-Eintrag (HMENU()): '
		?? HMENU()
		// vmenu() liefert die letzten beiden Ziffern der Men-ID
		? 'vertikaler Men-Eintrag (VMENU()): '
		?? VMENU()
	endif
enddo

// Check/uncheck, enable/disable ndert die "Darstellung" eines 
// Meneintrages.
// ModifyMenu gibt 0 zurck, wenn Fehler
// Parameter: menu handle, item ID, nderung, item ID, 
// ggf. neuer Item-Text.
? ModifyMenu(toint(hMenu), toint(IDM_EXIT), toint(MF_CHECKED), toint(IDM_EXIT), "E"+"&"+"xit jetzt geChecked")
wait

// Meneintrag lschen
DeleteMenu(toint(hMenu), toint(IDM_OPEN), toint(0))

wait

// Wird nur bentigt, wenn das Men einem CREATE WINDOW folgte
// DestroyMenu(toint(hMenu))