*************************************************
* BANKER2.PRG - CA dBFast CREATE CONTROL version
*************************************************

*: Definition von Konstanten fr Events
#DEFINE eKybd      1
#DEFINE eClose     5
#DEFINE eButton    6

*: Definition von Konstanten fr Aktionen
#DEFINE aNone      -1
#DEFINE aDone      1

*: Definition von Konstanten fr Schaltflchennamen
#DEFINE bDone      " Fertig "
#DEFINE bAdd       " Hinzufgen "

*: Definition von Konstanten fr Tastennamen
#DEFINE kESC       27

SET PROCEDURE TO BANKER2

USE BANKER2
INDEX ON NAME TO BANKER2

STORE '' TO sTheButton, sTheKey
nKundRec = 0

CREATE BUTTON bAdd  AT 23,23 SIZE 1,14 PLAIN ;
	VALID ADDLOAN()
CREATE BUTTON bDone AT 23,41 SIZE 1,14 PLAIN

CENTER('Beispiel-Anwendung',1,0,80,10)

CENTER('Kundenkonten',3,0,80,10)

SET SAY VIDEO TO 112

CREATE CONTROL FIELD NAME ;
	PICTURE REPLICATE('X',20) ;
	COLOR SAYVIDEO()

CREATE CONTROL BROWSE 'KundBrowse' AT 6,1 ;
	SIZE 15,76 ;
	TITLE 'Information ber Kreditkunden;Name des Kunden;' + ;
		'Konto#;Datum;AnfBetrag;Saldo;Kat' ;
	STYLE TITLE + VIEW ;
	SAVE TO nKundRec

  
* Initialisiert nAction

nAction = 0

* Solange nicht "Fertig" gewhlt wurde

DO WHILE nAction <> aDone
	* Event-Verarbeitung
	nEvent = GETEVENT()
	* Event wird in eine Aktion transformiert
	nAction = TRANSLATEEVENT(nEvent)
	* Aktion wird ausgefhrt
	DO PROCESSACTION WITH nAction
ENDDO

RETURN


*******************
FUNCTION GETEVENT()
*******************
PRIVATE nTheEvent

STORE '' TO sTheButton, sTheKey
nTheEvent = -1

* Event-Verarbeitung
DO WHILE nTheEvent = -1
	nTheEvent = MODALEVENT(.F.)
ENDDO

* Setzt globale Variablen
sTheButton = BUTTON()
sTheKey    = LASTKEY()
RETURN(nTheEvent)


*************************
FUNCTION TRANSLATEEVENT()
*************************
PARAMETER nTheEvent
PRIVATE nTheAction

nTheAction = aNone

DO CASE
	CASE nTheEvent = eKybd
		IF LASTKEY() = kESC
			nTheAction = aDone
		ENDIF
      
	CASE nTheEvent = eClose
		nTheAction = aDone
      
	CASE nTheEvent = eButton
		IF sTheButton = bDone
			nTheAction = aDone
		ENDIF
      
ENDCASE
RETURN(nTheAction)


***********************
PROCEDURE PROCESSACTION
***********************
PARAMETER nTheAction

DO CASE
	CASE nTheAction = aDone
		*: Wurde oben bereits in der DO WHILE-Schleife ausgefhrt
ENDCASE
RETURN


******************
FUNCTION ADDLOAN()
******************

STORE '' TO sName, sKonto_Nr, sKategorie
STORE DTOC(DATE()) TO sEroeff_Dat
STORE '0.00' TO sAnf_Betrag

CREATE WINDOW 'Neuer Kredit' FROM 5,8 TO 18,72 ;
	STYLE HIDDEN
 
CREATE BUTTON 'OK'     AT 0,52 SIZE 1,10
CREATE BUTTON 'Abbrechen' AT 2,52 SIZE 1,10 PLAIN

@ 2,2 SAY "Name des Kunden:"
CREATE CONTROL EDITBOX 'EB.Name' AT 2,20 SIZE 1,30 ;
	SAVE TO sName

@ 4,2 SAY "Kontonummer:"
CREATE CONTROL EDITBOX 'EB.AcctNum' AT 4,31 ;
	SIZE 1,14 SAVE TO sKonto_Nr

@ 6,2 SAY "Datum der Kreditaufnahme:"
CREATE CONTROL EDITBOX 'EB.DateOpen' AT 6,31 ;
	SIZE 1,8 SAVE TO sEroeff_Dat

@ 8,2 SAY "Hhe des Kredits:"
CREATE CONTROL EDITBOX 'EB.BegAmt' AT 8,31 ;
	SIZE 1,14 SAVE TO sAnf_Betrag

@ 10,2 SAY "Grund des Kredits:"
CREATE CONTROL EDITBOX 'EB.Category' AT 10,31 ;
	SIZE 1,10 SAVE TO sKategorie

SHOW WINDOW 'Neuer Kredit'
SELECT CONTROL 'EB.Name'
  
DO WHILE .T.    
	nEvent = GetEvent()
	IF nEvent = eButton 
		IF BUTTON() = 'OK'
			APPEND BLANK
		    REPLACE Name WITH sName
		    REPLACE Konto_Nr WITH sKonto_Nr
		    REPLACE Eroeff_Dat WITH CTOD(sEroeff_Dat)
		    REPLACE Anf_Betrag WITH VAL(sAnf_Betrag)
		    REPLACE Saldo WITH 0.00
		    REPLACE Kategorie WITH sKategorie
			COMMIT
		ENDIF
		EXIT
	ENDIF
ENDDO

CLOSE WINDOW 'Neuer Kredit'
RETURN(.F.)
