DECLARE FUNCTION HexToInt% (strng$)
'****************************************************************
'*               ----- bc7exam.bas -----                        *
'*                                                              *
'*      Willies' Computer Software Company                      *
'*      Copyright (C) Egberto Willies, 1988-1992                *
'*      All rights reserved.                                    *
'*                                                              *
'*Author-                                                       *
'*      12-DEC-1989 by Egberto Willies                          *
'*                                                              *
'*Description-                                                  *
'*      Example showing how to use QuickBasic with libraries.   *
'*      This is a dumb terminal emulator.                       *
'*                                                              *
'****************************************************************

'************************************************
'* Include QUICKBASIC COMMDRV Include file.     *
'************************************************
'$INCLUDE: 'bc7comm.bas'

'************************************************
'* Make all letters a-z integers by default     *
'************************************************
DEFINT A-Z

'************************************************
'* This defines a user type that contains all   *
'* the serial port characteristics.             *
'************************************************
DIM pcb AS portparam

'************************************************
'* Define the communications buffer.            *
'* We are defining 256 bytes for input and      *
'* 256 bytes for output.                        *
'************************************************
DIM buf AS STRING * 514

DIM ch AS STRING * 1


'************************************************
'* Enter port number, UART address, and IRQ.    *
'************************************************
CLS : LOCATE 1, 1
INPUT "Enter the port number           ==>"; pnum
INPUT "Enter the UART address(HEX)     ==>"; tmp$
INPUT "Enter the IRQ number            ==>"; irqnum
puart = HexToInt%(tmp$)
PRINT
PRINT "Type <Control> Z to exit when done"
PRINT

'************************************************
'* Get port default characteristics. This       *
'* should always be to ensure future            *
'* compatibility.                               *
'************************************************
stat = ser.rs232.getport(pnum, pcb)

'************************************************
'* Initialize the port to the desired           *
'* parameters                                   *
'************************************************
pcb.serrs232base = puart
pcb.irq = irqnum
pcb.baud = BAUD9600
pcb.parity = PARITYNONE
pcb.lngth = LENGTH8
pcb.stopbit = STOPBIT1
pcb.brk = BREAKOFF
pcb.protocol = PROTNONNON
pcb.block = CHR$(0) + CHR$(0)
pcb.hblock = CHR$(0) + CHR$(0)
pcb.inbuflow = 256 / 4
pcb.inbufhigh = 256 / 2
pcb.bufferseg = VARSEG(buf)
pcb.bufferoff = VARPTR(buf)
pcb.inbuflen = 256
pcb.outbuflen = 256
pcb.cardtype = CARDNORMAL

'************************************************
'* Open the serial port.                        *
'************************************************
stat = ser.rs232.setup(pnum, pcb)

IF stat <> RS232ERRNONE THEN
	CLS
	PRINT "Error #"; stat; " opening serial port"
	SYSTEM
END IF

DO
	'************************************************
	'* Make string the exact size of the read.      *
	'************************************************
	ch = " "

	'************************************************
	'* Attempt to get a byte from the serial port.  *
	'************************************************
	stat = ser.rs232.getbyte(pnum, VARPTR(ch) + VARSEG(ch) * 65536)
 
	'********************************************************
	'* If character read from serial port, output it        *
	'* otherwise if a serial error other than buffer        *
	'* empty, then exit in error.                           *
	'********************************************************
	IF stat = RS232ERRNONE THEN
		PRINT ch;
	ELSEIF stat <> RS232ERRRCVBUF THEN
		PRINT "Error #"; stat; " reading from serial port"
		EXIT DO
	END IF

	'************************************************
	'* Attempt to get byte from the keyboard.       *
	'************************************************
	a$ = INKEY$

	'************************************************
	'* Attempt to get byte from the keyboard.       *
	'* If control Z is hit then we exit.            *
	'************************************************
	IF a$ <> "" THEN
		IF a$ = CHR$(26) THEN
			EXIT DO
		END IF
		ch = a$

		'************************************************
		'* Attempt to output byte over serial port.     *
		'************************************************
		stat = ser.rs232.putbyte(pnum, VARPTR(ch) + VARSEG(ch) * 65536)
		IF stat <> RS232ERRNONE THEN
			PRINT "Error #"; stat; " writing to serial port"
			EXIT DO
		END IF
	END IF
LOOP WHILE ch = ch

'************************************************
'* Attempt to cleanup vectors and so forth.     *
'************************************************
stat = ser.rs232.cleanup(pnum)
IF stat <> RS232ERRNONE THEN
	PRINT "Error #"; stat; " cleaning serial port"
END IF
SYSTEM
'********************************************************
'********************************************************

'********************************************************
FUNCTION HexToInt% (strng$)
hexval% = 0
strlen% = LEN(strng$)

FOR i% = 1 TO strlen%
	strchar$ = MID$(strng$, i%, 1)
	IF strchar$ <= "9" AND strchar$ >= "0" THEN
		strch% = ASC(strchar$) - ASC("0")
	ELSEIF strchar$ <= "F" AND strchar$ >= "A" THEN
		strch% = ASC(strchar$) - ASC("A") + 10
	ELSEIF strchar$ <= "f" AND strchar$ >= "a" THEN
		strch% = ASC(strchar$) - ASC("a") + 10
	END IF

	hexval% = 16 * hexval% + strch%
NEXT i%
HexToInt% = hexval%
END FUNCTION

