@echo off
rem UPDATE.BAT version 1.02X

rem **** This UPDATE.BAT file will copy and install the Baseball '94
rem **** version 1.02 patch and Legends and Stadiums expansion disk
rem **** to the specified hard drive and game directory.  If no
rem **** parameters are specified, it will first check for the patch
rem **** files already in the current directory.  If they are not there,
rem **** it will attempt to install using the default drives and
rem **** directory, i.e., installing from A: to C:\SIERRA\BASEBALL.

cls
echo This batch file will install the Legends and Stadiums expansion
echo data as well as update FPS: Baseball '94 versions 1.00W and 1.01 to
echo version 1.02.  The proper syntax for using this installation
echo procedure is:
echo.
echo   UPDATE [source drive] [destination drive] [destination directory]
echo.
echo   Example:  UPDATE A: C: \SIERRA\BASEBALL
echo.
echo If the patch and expansion files are already in the game directory
echo you may start the installation process by simply typing:
echo.
echo  UPDATE [ENTER]
echo.
pause

cls
echo Before patching Baseball to the new version, all saved games must
echo be completed or deleted.  If you continue with this installation,
echo the saved games will be deleted for you.  If you do not want them
echo deleted, press CTRL+C now to exit the installation script and finish
echo the saved games before continuing with the patching process, or
pause

rem **** check to see if there are no parameters specified
if "%1"=="" goto noparms1
if "%2"=="" goto noparms1
if "%3"=="" goto noparms1

rem **** check the status of the 1st parameter and set F variable
:chkfd
if exist %1\48teams.res goto tyrone
if exist %1:\48teams.res goto tyrone
if exist %1\patcha.rtp SET F=%1
if exist %1:\patcha.rtp SET F=%1:
if exist %F%\patcha.rtp goto chkhd
goto needparm

rem **** check the status of the 2nd parameter and set H variable
:chkhd
if exist %2\.. goto needparm
if exist %2\nul SET H=%2
if exist %2:\nul SET H=%2:
if exist %H%nul goto chkdr
goto needparm

rem **** check the status of the 3rd parameter and set D variable
:chkdr
if exist %H%%3shell.exe goto notrail
if exist %H%\%3\shell.exe SET D=\%3
if exist %H%%3\shell.exe SET D=%3
if not exist %H%%D%\shell.exe goto needparm

rem **** copy all files from disk 1 to game directory
%H%
cd %D%
cls
echo Copying patch files . . .
copy %F%\*.*

rem **** Check for disk 2 and then copy files from disk 2 to game directory
:dsk2
cls
if not exist %F%\xpanstad.res goto needdsk2
copy %F%\*.*

cls
echo Now ready to begin applying the patch files . . .
pause

rem **** patch version 1.00W/1.01 to 1.02
:patchit
chk4game -y
patch patcha.rtp
patch patchb.rtp
patch patchc.rtp
patch patchd.rtp assn
patch patche.rtp stadia

rem **** Check results of patch application.
cls
echo Now checking results of patching . . .
bbcheck
pause

rem **** unchunk the new teams and stadia
:expandit
cls
echo Now adding expansion disk data . . .
unchunk xpanstad.res .
unchunk xpanteam.res .
patch patchg.rtp
patch patchh.rtp
patch patchi.rtp assn
pause

rem **** check the results of the expansion
:checkit
cls
echo Now checking results of expansion . . .
bbcheck
goto end
        
rem **** prompt and pause for inputing disk 2
:needdsk2
echo Please insert the Legends and Stadiums disk #2.
pause
goto dsk2

rem **** If no parameters are specified, first check to see if the
rem **** files are in the game directory.  If they are, go directly to
rem **** patchit section, if not check the default drives and directory
rem **** of A: C: \SIERRA\BASEBALL.  If they aren't there, goto needparm.
:noparms1
if not exist .\patch.exe goto nope
if not exist .\patcha.rtp goto nope
if not exist .\patchb.rtp goto nope
if not exist .\patchc.rtp goto nope
if not exist .\patchd.rtp goto nope
if not exist .\patche.rtp goto nope
if not exist .\shell.exe goto nope
if not exist .\chk4game.exe goto nope
if not exist .\xpanstad.res goto nope
if not exist .\xpanteam.res goto nope
if not exist .\48teams.res goto nope
if not exist .\unchunk.exe goto nope
goto patchit

:nope
cls
echo Now checking for existence of patch disk in drive A: and game in
echo C:\SIERRA\BASEBALL.  If there is no disk in drive A:, you will
echo receive an "Abort, Retry, Fail" message on this step.  To clear
echo the message if it appears, either insert a formatted floppy disk
echo in drive A: and press "R" to "Retry" or press "F" to "Fail" the
echo check.
echo.
if not exist a:nul goto needparm
if not exist a:\patcha.rtp goto needparm
if not exist c:\sierra\baseball\shell.exe goto needparm

cls

echo Before patching Baseball to the new version, all saved games must
echo be completed or deleted.  If you continue with this installation,
echo the saved games will be deleted for you.  If you do not want them
echo deleted, press CTRL+C now to exit the installation script and finish
echo the saved games before continuing with the patching process, or
pause

cls
echo Prepared to install the Baseball '94 Legends and Stadiums
echo expansion disk and version 1.02 patch from floppy disk in
echo drive A: to C:\SIERRA\BASEBALL.
echo.
echo If this is NOT correct, press CTRL+C now to terminate
echo execution of the install batch file, otherwise,
pause

cls
echo Now copying patch files from C:\SIERRA\BASEBALL . . .

rem **** Actual execution of the default copy process
c:
cd \sierra\baseball
copy a:\*.*

rem **** check for disk 2 in drive and copy files to game directory
:noparms2
cls
if not exist a:\xpanstad.res goto putdsk2n
echo Now copying patch and expansion files from disk #2 to C:\SIERRA\BASEBALL...
copy a:\*.*
echo.
echo Done copying files from drive A: to C:\SIERRA\BASEBALL...
goto patchit

rem **** prompting procedure for disk 2 for default install
:putdsk2n
echo Please insert the Legends and Stadiums disk #2 into the A: drive.
pause
goto noparms2

rem **** Error prompt if the user is trying to start from disk 2
:tyrone
cls
echo This is disk #2, please insert disk #1.
pause
goto chkfd

rem **** Extra prompt for telling user not to put a trailing backslash on dir
:notrail
echo Don't use a trailing backslash on the directory name.

rem **** Bad or missing parameters procedure
:needparm
pause
cls
echo You did not specify the proper source and destination paths and/or
ech drives.  The proper syntax for the installation is:
echo.
echo        UPDATE A: C: \SIERRA\BASEBALL
echo.
echo Replace the "A:" with the letter of the floppy drive with the patch
echo disk.  Replace the "C:" with the letter of the hard drive where
echo Baseball is installed.  Replace "\SIERRA\BASEBALL" with the directory
echo where Baseball is installed.
echo.
echo Note that you may specify the drives with or without the colon (both
echo A and A: are acceptable) and the directory with or without the
echo leading backslash (both \SIERRA\BASEBALL and SIERRA\BASEBALL are
echo acceptable).  The directory name cannot have a trailing backslash.
echo.
echo If no parameters are specified, the default drives and directory (as
echo shown in the above example) will be tried before providing this
echo prompt screen.
echo.
echo Please try again.
pause

rem **** Clean everything up by deleting the patch files and
rem **** clearing the variables.
:end
if exist %H%%D%\shell.exe del %H%%D%\patch*.*
if exist %H%%D%\shell.exe del %H%%D%\xpan*.res
SET F=
SET H=
SET D=
