@echo off
rem /***********************************************************************/
rem /* This batch file is an example of how to back up a cc:Mail post office */
rem /***********************************************************************/ 

rem /* Shut down the post office with NPODOWN */ 
echo ** Running NPODOWN **
NPODOWN /N"po_name" /Ppswd /Dm:\ccdata /DISCONNECT /LOCKNOW /MINUTES/5 /BATCH
if errorlevel 3 goto NPERR
if errorlevel 2 goto ESC
if errorlevel 1 goto NPERR

rem /* Run ANALYZE on the post office */
echo ** Running ANALYZE **
ANALYZE /Dm:\ccdata /DIAGNOSTICS /BATCH  > backup.txt
if errorlevel 3 goto ANERR1
if errorlevel 2 goto ESC
if errorlevel 1 goto ANERR1

rem /* Run CCSAVE on the post office */
echo ** Running CCSAVE **
CCSAVE /Dm:\ccdata /TARGET/m:\ccdata\back /BATCH >> backup.txt
if errorlevel 3 goto SAVERR
if errorlevel 2 goto ESC
if errorlevel 1 goto SAVERR

rem /* reopen the post office with NPODOWN */ 
echo ** Running NPODOWN, reopening post office **
NPODOWN /N"po_name" /Ppswd /Dm:\ccdata /ENABLE /BATCH

echo ** Backup process successful **
goto END

:ANERR1
echo ** ANALYZE reported errors - process ended **
goto END

:NPERR
echo ** NPODOWN reported errors - process ended **
goto END

:SAVERR
echo ** CCSAVE reported errors - process ended **   
goto END

:ESC
echo ** Escape was pressed - process ended **

:END


