@echo off
cls
cd\
REM -- VersaCAD NETWORK installation. Enter A:INSTALL or B:INSTALL USER1 USER2
REM -- This batch expects the hard disk as the current drive, VersaCAD is
REM -- installed on it and the VCAD386.BAT or VCAD80.BAT exists on the root.
REM -- The first through X parameters may be set (%1 %2 %3) for any users 
REM -- directory (ex. BOB STEVE U:\VCAD\USER1) up to the line character limit.
REM -- Directories will be made for users with a custom (path-altered) Enviro
REM -- under the VCAD386 or VCAD80 directory during one install.
GOTO SETUP

:SETUP
set diskxyz=.
set pathzyx=..........
set pathdrv=..
set VNU_ID=....................
if %VNU_ID% == .................... goto SETUP1
goto NOSPACE

:SETUP1
if %0. == A:INSTALL. set diskxyz=A
if %0. == a:install. set diskxyz=A
if %0. == A:\INSTALL. set diskxyz=A
if %0. == a:\install. set diskxyz=A

if %0. == b:install. set diskxyz=B
if %0. == B:INSTALL. set diskxyz=B
if %0. == b:\install. set diskxyz=B
if %0. == B:\INSTALL. set diskxyz=B
if %diskxyz%. == . goto BADPARAM
if %1. == . goto CHECK
if exist %1\vcad386\*.*  goto BADPARAM
if exist %1\vcad80\*.*   goto BADPARAM

:CHECK
REM -- Don't try to install the system on the master diskette.
if not exist GETCH.EXE    goto VALDISK
if not exist INSTALL.BAT  goto VALDISK
if not exist VENV.EXE     goto VALDISK
if not exist NETMENU2     goto VALDISK
if not exist NETMENU3     goto VALDISK
if not exist NETMESS2     goto VALDISK
if not exist NETUTILS.CMD goto VALDISK
if not exist VRUN.BAT     goto VALDISK
if not exist VFRUN.BAT    goto VALDISK
if not exist NEWVCAD.BAT  goto VALDISK
goto ABORT
REM -- this must be the master disk.  DO NOT TRY TO INSTALL ON THE MASTER DISK!

:VALDISK
cls
echo 
echo                 INSTALLATION FOR VersaCAD NETWORKING SOFTWARE
echo 
echo      This installation requires the following:
echo      1 MB of hard disk space free.
echo 
echo      It will change your V2D.MNU, V2D.MES, VRUN.BAT, VFRUN.BAT and
echo      VCAD*.BAT files and add other files to your system.
echo 
echo      If you wish to install for multiple users with a shared version of
echo      VersaCAD on a network drive, see the installation documentation.
echo 
echo      [F1]  Install into VersaCAD/386 Version 8.0E.
echo 
echo      [F2]  Install into VersaCAD Design Version 8.0E.
echo 
echo      [F3]  Exit to Operating system.
echo 

:GETCH
%diskxyz%:\GETCH
if errorlevel 131 goto GETCH
if errorlevel 130 goto EXIT
if errorlevel 129 goto VDES
if errorlevel 128 goto V386
if errorlevel 1 goto GETCH

:V386
%diskxyz%:vpath \vcad386\utils\vcledit.com pathdrv pathzyx
call vpaths.bat
del vpaths.bat
if %pathzyx%. == NO80. goto NO2D
cd \vcad386\v2d
cls
echo 
echo      Please wait while Networking software is added to VersaCAD/386.
echo 
goto FINISH

:VDES
%diskxyz%:vpath \vcad80\utils\vcledit.com pathdrv pathzyx
call vpaths.bat
del vpaths.bat
if %pathzyx%. == NO80. goto NO2D
cd \vcad80\v2d
cls
echo 
echo      Please wait while Networking software is added to VersaCAD Design.
echo 
goto FINISH

:FINISH
if not exist v2d.mnu GOTO NO2D
copy v2d.mnu v2dold.mnu > NUL
if not exist v2dold.mnu goto NOROOM1
echo 
echo      Please wait while the VersaCAD 2D menu is uncrunched.
echo 
crunch v2d.mnu /u /m > menu1
if not exist menu1 goto NOMENU1

copy %diskxyz%:\netmenu2 menu2 > NUL
if not exist menu2 goto NOROOM2
copy %diskxyz%:\netmenu3 menu3 > NUL
if not exist menu3 goto NOROOM3
echo 
crunch menu v2d.mnu /m
del menu3 > NUL
del menu2 > NUL
del menu1 > NUL

@echo off
if not exist v2d.mes goto NO2D
copy v2d.mes v2dold.mes > NUL
if not exist v2dold.mes goto NOROOM2
cls
echo 
echo 
echo      Please wait while the VersaCAD 2D message file is uncrunched.
echo 
crunch v2d.mes /u > mes1
if not exist mes1 goto NOMES1

copy %diskxyz%:\netmess2 mes2 > NUL
if not exist mes2 goto NOROOM4
echo 
crunch mes v2d.mes
del mes2 > NUL
del mes1 > NUL

@echo off
copy %diskxyz%:\netutils.cmd  custom\netutils.cmd > NUL
if not exist custom\netutils.cmd goto NOROOM5
cd ..

copy VRUN.BAT                 VRUNOLD.BAT > NUL
if not exist VRUNOLD.BAT goto NOROOM5
copy %diskxyz%:\VRUN.BAT         VRUN.BAT > NUL

copy VFRUN.BAT               VFRUNOLD.BAT > NUL
if not exist VFRUNOLD.BAT goto NOROOM6
copy %diskxyz%:\VFRUN.BAT       VFRUN.BAT > NUL

copy %diskxyz%:\pthvcad.BAT   pthvcad.BAT > NUL
if not exist pthvcad.BAT goto NOROOM8

copy %diskxyz%:\newvcad.BAT   newvcad.BAT > NUL
if not exist newvcad.BAT goto NOROOM8

set VNU_ID=%1
call pthvcad.bat %pathzyx%
if %VNU_ID%. == NOBAT. goto EXIT
if %1. == . goto AOK

:NEWUSER
@echo off
set VNU_ID=%1

copy %diskxyz%:\pthvcad.BAT   pthvcad.BAT > NUL
if not exist pthvcad.BAT goto NOROOM8

copy %diskxyz%:\newvcad.BAT newvcad.BAT > NUL
if not exist newvcad.BAT goto NOROOM8

copy %diskxyz%:\VENV.EXE         VENV.EXE > NUL
if not exist VENV.EXE goto NOROOM8

if not exist %1\*.*     md %1          > NUL
copy enviro.env %1\enviro.env          > NUL
if not exist %1\enviro.env goto NOPATH

set VNU_ID=%1
call pthvcad.bat %pathzyx%

if not exist %pathzyx%\%1\enviro.env  goto ENVDISK
venv /e%pathzyx%\%1 /p%pathzyx%\%1 /2A /2B /2C /2F /2H /BC
venv /e%pathzyx%\%1 /p%pathzyx%\%1 /3A /3B /3C /3D /3E /3F /3H /3V /RC /RR
goto USERCHK

:ENVDISK
venv /e%1 /p%1 /2A /2B /2C /2F /2H /BC
venv /e%1 /p%1 /3A /3B /3C /3D /3E /3F /3H /3V /RC /RR

:USERCHK
shift
if %1. == . goto AOK
GOTO NEWUSER

:AOK
cls
echo 
echo      VersaCAD Network software was installed.
echo 
echo      PLEASE SEE YOUR DOCUMENTATION ON THE PROPER USE OF THIS PACKAGE
echo 
echo      If this is a local or standalone installation of VersaCAD and you
echo      typed  a:install  for installation.  Add to  SET VNU_ID=   in your 
echo      VCAD386.BAT or VCAD80.BAT a unique user name.
echo      Example:  SET VNU_ID=VCAD1
echo 
goto EXIT

:NOSPACE
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo There was not enough DOS environment space found.  SET could not be
echo performed.  Please increase DOS environment space or remove any
echo unnecessary DOS environment variables.  Then try to install again.
goto EXIT

:NO2D
@echo off
cls
cd ..
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo VersaCAD 8.0 2D was not found.  Be sure you are on the root of the disk
echo drive in which the VersaCAD programs lie.  Then try to install again.
goto EXIT

:NOROOM1
@echo off
cls
cd ..
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Check to see if there is room on the hard disk and start again when the
echo system prompt appears.
goto EXIT

:NOROOM2
@echo off
cd v2d
copy v2dold.mnu v2d.mnu
del v2dold.mnu
cd ..
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Check to see if there is room on the hard disk and start again when the
echo system prompt appears.
goto EXIT

:NOROOM3
@echo off
cls
cd v2d
copy v2dold.mnu v2d.mnu
del v2dold.mnu
del menu2
cd ..
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Check to see if there is room on the hard disk and start again when the
echo system prompt appears.
goto EXIT

:NOROOM4
@echo off
cls
cd v2d
copy v2dold.mnu v2d.mnu
copy v2dold.mes v2d.mes
del v2dold.mes
del v2dold.mnu
del menu1
cd ..
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Check to see if there is room on the hard disk and start again when the
echo system prompt appears.
goto EXIT

:NOROOM5
@echo off
cls
cd v2d
copy v2dold.mnu v2d.mnu
copy v2dold.mes v2d.mes
del v2dold.mes
del v2dold.mnu
cd ..
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Check to see if there is room on the hard disk and start again when the
echo system prompt appears.
goto EXIT

:NOROOM6
@echo off
cls
cd v2d
copy v2dold.mnu v2d.mnu
copy v2dold.mes v2d.mes
del v2dold.mes
del v2dold.mnu
cd ..
copy vrunold.bat vrun.bat
del vrunold.bat
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Check to see if there is room on the hard disk and start again when the
echo system prompt appears.
goto EXIT

:NOROOM8
@echo off
cls
cd v2d
copy v2dold.mnu v2d.mnu
copy v2dold.mes v2d.mes
del v2dold.mes
del v2dold.mnu
cd ..
copy vrunold.bat vrun.bat
copy vfrunold.bat vfrun.bat
del vrunold.bat
del vfrunold.bat
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Check to see if there is room on the hard disk and start again when the
echo system prompt appears.
goto EXIT

:NOPATH
@echo off
cls
cd v2d
copy v2dold.mnu v2d.mnu
copy v2dold.mes v2d.mes
del v2dold.mes
del v2dold.mnu
cd ..
copy vrunold.bat vrun.bat
copy vfrunold.bat vfrun.bat
del vrunold.bat
del vfrunold.bat
del newvcad.bat
del pthvcad.bat
del venv.exe
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Check to see if there is room on the hard disk or the user specified
echo has a valid path and start again when the system prompt appears.
goto EXIT

:NOMENU1
@echo off
cls
copy v2dold.mnu v2d.mnu
del v2dold.mnu
cd ..
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Unable to uncrunch the existing menu file.
echo Check to see that the Versacad Crunch utility is in your path.
goto EXIT

:NOMES1
@echo off
cls
copy v2dold.mnu v2d.mnu
copy v2dold.mes v2d.mes
del v2dold.mnu
del v2dold.mes
cd ..
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo Unable to uncrunch the existing message file.
echo Check to see that the Versacad Crunch utility is in your path.
goto EXIT

:ABORT
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo The master disk is the root directory which indicates you may be
echo copying the Network software to drive %diskxyz%:.  To install on 
echo drive C:, type  C: [enter]  to make drive C: the current directory,
echo then type %diskxyz%:INSTALL or %diskxyz%:INSTALL USER1 USER2 [enter] 
echo to begin again.
goto EXIT

:BADPARAM
cls
echo  
echo VERSACAD NETWORKING SOFTWARE was NOT installed successfully.
echo     To install the Network software from drive A: type
echo   a:install, A:INSTALL or A:INSTALL USER1 USER2 ... USER12
echo  
echo     To install the Network software from drive B: type
echo   b:install, B:INSTALL or B:INSTALL USER1 USER2 ... USER12
echo  
echo Be sure you are on the root of the drive that Versacad is installed on.
echo                   
goto EXIT

:EXIT
cd \
