;-----------------------------------------------------
;This universal sample program runs on the following
;processor types: PIC16C5X, PIC16CXX, and PIC17CXX.
;
;Execution starts at instruction 50.
;The loop routine executes seven times.  
;       The routines, ReduceA and DoubleB, 
;       each execute one time for each loop cycle.
;After the loop executes seven times, the instruction 
;at location 59 returns the program counter to start.
;
;
;Start initializes:     A = 255, (A decreases to  128)
;                       B =   1, (B increases to  128)
;                       C =   7, (C decrements to   0)
;                       w =   7
;                    wreg =   7
;           
;The sample program calculates values as follows:
;Cycle #    A (A=A-B)   B (B=B+B)    C (C=C-1)    
;  0           255           1           7
;  1           254           2           6
;  2           252           4           5
;  3           248           8           4
;  4           240          16           3
;  5           224          32           2  
;  6           192          64           1   
;  7           128         128           0  
;
;Caution:  Enter the device name printed on the probe 
;          connected to your pod before assembling 
;          this code.
;-----------------------------------------------------
;
        list p=16c64, f=inhx8m  ;Enter device name 
                                ;printed on the probe
                                ;connected to your pod.
;------------------------------------------------------
;Please define ScratchPadRam here:
;If you are using PIC16C5X define "ScratchPadRam equ 0x10" 
;else define "ScratchPadRam equ 0x20"
;-------------------------------------------------------
ScratchPadRam   equ     0x20
A       equ     ScratchPadRam+0
B       equ     ScratchPadRam+1
C       equ     ScratchPadRam+2
w       equ     0
;        
        org     0       ;start address 0
        goto    start
        org     0x50
;
start
        movlw   .255
        movwf   A       ;A=255 start
        movlw   .1
        movwf   B       ;B=1   start
        movlw   .7
        movwf   C       ;C=7   start
loop                    
        call    ReduceA ;run 7 loops
        decfsz  C       ;C=C-1
        goto    loop   
        goto    start   ;initialize
;
ReduceA                 
        swapf   B
        swapf   B,w
        swapf   B
        subwf   A       ;A=A-B
        call    DoubleB
        retlw   0
;
DoubleB                 
        swapf   B
        swapf   B,w
        swapf   B
        addwf   B       ;B=B+B
        retlw   0
;
        end



