
PROCEDURE IfChange
*----------------------------------------------------------------------------
* NAME
*   IfChange - Change Directory Dialog box for IDE and Form Painter
*
* DESCRIPTION
*   Allows the user to change the active directory.
*----------------------------------------------------------------------------

    PRIVATE cDir, ret, lVoid

    cDir = SET( "DIRECTORY" )
    
#include "ifchange.dfm"

    fChDir.efDir.Value = LEFT( m->cDir + SPACE(80), 80 )

    fChDir.Action = .F.

    DO BldDirs WITH fChDir.lbDir

    lVoid = fChdir.lbDir.SetFocus()
    ret = fChDir.READMODAL()

    IF .NOT. fChDir.Action
        cDir = fChDir.Revert
        SET DIRECTORY TO &cDir
    ENDIF

    lVoid = fChDir.RELEASE()
    RELEASE fChDir
    RELEASE a___Dir

RETURN

PROCEDURE OCChange
*----------------------------------------------------------------------------
* NAME
*   OCChange - OnClick event handler for pbChange pushbutton
*
*----------------------------------------------------------------------------
    PRIVATE cNewPath, lExact, cPath, oWhich, lUpdated

    *-----------------------------
    *-- Check to see who had focus
    *-----------------------------
    Form.Draw = .F.
    oWhich = Form.ActiveControl()
    lUpdated = .F.
    nError = 0
    DO CASE
        CASE m->oWhich = Form.lbDir
            cNewPath = Form.lbDir.Value
            DO CASE
                CASE m->cNewPath == "\"
                    cPath = LEFT( SET( "DIRECTORY" ), 2 ) + "\"
                    SET DIRECTORY TO &cPath
            
                CASE m->cNewPath == ".."
                    ON ERROR nError = ERROR()
                    SET DIRECTORY TO ..
                    ON ERROR
                    IF m->nError > 0
                        lUpdated = .F.
                    ENDIF

                OTHERWISE
                    cPath = SET( "DIRECTORY" )
                    IF RIGHT( m->cPath, 1 ) <> "\"
                        cPath = m->cPath + "\"
                    ENDIF
                    cPath = m->cPath + TRIM( m->cNewPath )
                    SET DIRECTORY TO &cPath
            ENDCASE
            lUpdated = .T.

        CASE m->oWhich = Form.efDir
            cNewPath = Form.efDir.Value
            ON ERROR nError = ERROR()
            SET DIRECTORY TO &cNewPath
            ON ERROR
            IF m->nError > 0
                This.Value = This.StartValue
            ENDIF
            lUpdated = .T.
    ENDCASE

    IF m->lUpdated
        Form.Draw = .F.
        Form.efDir.Value = LEFT( SET( "DIRECTORY" ) + SPACE( 80 ), 80 )
        Form.efDir.Width = 31

        DO BldDirs WITH fChDir.lbDir
        Form.Draw = .T.
    ENDIF
    Form.Draw = .T.
RETURN
*-- EOP: OCChange


FUNCTION VAefDir
*----------------------------------------------------------------------------
* NAME
*   VAefDir - Valid event handler for efDir EntryField
*
*----------------------------------------------------------------------------
    PRIVATE cNewPath, nError

    cNewPath = TRIM( This.Value )
    nError = 0
    ON ERROR nError = ERROR()
    SET DIRECTORY TO &cNewPath
    ON ERROR
    IF m->nError > 0
        This.Value = This.StartValue
        RETURN .F.
    ENDIF

    This.Value = LEFT( SET( "DIRECTORY" ) + SPACE( 80 ), 80 )
    This.Width = 31

    DO BldDirs WITH fChDir.lbDir

RETURN  .T.
*-- EOP: VAefDir WITH 

PROCEDURE OGefDir
*----------------------------------------------------------------------------
* NAME
*   OGefDir - OnGotFocus event handler for efDir EntryField
*
*----------------------------------------------------------------------------
    This.StartValue = This.Value
    Form.pbOk.Default = .T.

RETURN
*-- EOP: OGefDir

PROCEDURE OLefDir
*----------------------------------------------------------------------------
* NAME
*   OLefDir - 
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
    Form.pbChange.Default = .T.


RETURN
*-- EOP: OLefDir


PROCEDURE OCRevert
*----------------------------------------------------------------------------
* NAME
*   OCRevert - OnClick event handler for pbRevert PushButton
*
*----------------------------------------------------------------------------
    PRIVATE cDir

    Form.Draw = .F.
    cDir = Form.Revert

    SET DIRECTORY TO &cDir

    Form.efDir.Value = LEFT( SET( "DIRECTORY" ) + SPACE( 80 ), 80 )
    Form.efDir.Width = 31

    DO BldDirs WITH fChDir.lbDir

    Form.Draw = .T.
RETURN
*-- EOP: OCRevert 

PROCEDURE DirOk
*----------------------------------------------------------------------------
* NAME
*   DirOk - 
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
    PRIVATE cNewPath, nError, lVoid

    cNewPath = TRIM( Form.efDir.Value )
    nError = 0
    ON ERROR nError = ERROR()
    SET DIRECTORY TO &cNewPath
    ON ERROR
    IF m->nError > 0
        DO ErrorMsg WITH MESSAGE()
    ELSE
        lVoid = Form.Close()
        Form.Action = .T.
    ENDIF


RETURN
*-- EOP: DirOk
*'---------------------------------------------------------------------------
*' $Log:   /cms/dav.v/src/ide/ifchange.prg,v  $ 
*'
*'   Rev 1.11   22 Jul 1994 20:26:02   dveale
*'*' PTR 72644 Prevent flickering using .Draw [dveale]
*'
*'   Rev 1.10   20 Jul 1994 18:24:04   bramos
*'*'  72583   Don't allow selection of .. from root directory.
*'
*'   Rev 1.9   30 Jun 1994 19:20:52   bramos
*'*'  99999   Final code clean up and internationalization [bramos]
*'
*'   Rev 1.8   27 Jun 1994 15:57:14   bramos
*'*'  99999   Add variable reference from DFM to after the include. [bramos]
*'
*'   Rev 1.7   08 Jun 1994 19:07:32   bramos
*'*'  99999   When focus is on Dir Name, Change should use the entryfield
*'*'          value and not the listbox. [bramos]
*'*'  99999   Add m-> prefix to memvars.
*'
*'   Rev 1.6   02 Jun 1994 21:03:58   bramos
*'*'  71372   Make sure that ON ERROR is set before doing the 
*'*'          change directory. [bramos]
*'*'  99999   Make OK the default when entryfield has focus.
*'
*'   Rev 1.5   27 May 1994 15:37:48   bramos
*'*'  71079   Remove code to call help the old way. [bramos]
*'
*'   Rev 1.4   23 May 1994 19:05:28   bramos
*'*'  99999   Remove talk code correctly.
*'
*'   Rev 1.3   23 May 1994 19:26:34   bramos
*'  70935   Privatize memvars. [bramos]
*'
*'   Rev 1.2   22 Apr 1994 19:26:34   bramos
*'*'  69970   Have focus be in the list box on start-up. [bramos]
*'
*'   Rev 1.1   18 Mar 1994 11:52:10   bramos
*'*'  DEV     Break dialog box code out to .DFM [bramos]
*'
*'   Rev 1.0   01 Mar 1994 19:47:12   danm
*'*'   DEV    Initial version for IDE prototype. [bramos, dveale]
*'
*'---------------------------------------------------------------------------

