* Program............: goods.FRG
* Date...............: 8-13-94
* Versions...........: dBASE 5.0, Report
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap, ll_heading, ll_temp, ll_toprint
ll_heading = .F.
ll_toprint = (SET("PRINTER") = "ON")

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 3 + 1) + (_pspacing + 1) + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing

*-- Initialize group footer field variables
r_foot1=.F.

*-- Initialize calculated variables.
inv_cost=0

*-- Set up procedure for page break
gn_atline=_plength - (_pspacing + 1)
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

*-- Initialize group break vars.
r_mvar4=VENDOR_ID

*-- Initialize summary variables.
r_msum1=0
r_msum2=0

*-- Assign initial values to calculated variables.
inv_cost=QTY_ONHAND*COST

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

DO Rintro

DO Grphead

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   DO CASE
   CASE VENDOR_ID <> r_mvar4
      gn_level=4
   OTHERWISE
      gn_level=0
   ENDCASE
   *-- test whether an expression didn't match
   IF gn_level <> 0
      DO Grpfoot WITH 100-gn_level
      DO Grpinit
   ENDIF
   *-- Repeat group intros
   IF gn_level <> 0
      DO Grphead
   ENDIF
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
   gn_level=3
   DO Grpfoot WITH 97
   DO Rsumm
   IF _plineno <= gn_atline
      EJECT PAGE
   ENDIF
ELSE
   gn_level=3
   DO Rsumm
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: goods.FRG

*-- Determine height of group bands and detail band for widow checking
FUNCTION Gheight
PARAMETER Group_Band
retval=0              && return value
IF Group_Band <= 4
   retval = retval + 2 * gn_pspace
ENDIF
*-- add height of detail band
retval = retval + 10 * gn_pspace
RETURN retval
* EOP: Gheight

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
inv_cost=QTY_ONHAND*COST
r_foot1=Vendor_id
*-- Sum
r_msum1=r_msum1+INV_COST
*-- Sum
r_msum2=r_msum2+INV_COST
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

*-- Reset group break variables.  Reinit summary
*-- fields with reset set to a particular group band.
PROCEDURE Grpinit
IF gn_level <= 4
   r_msum1=0
ENDIF
IF gn_level <= 4
   r_mvar4=VENDOR_ID
ENDIF
RETURN
* EOP: Grpinit

*-- Process Group Intro bands during group breaks
PROCEDURE Grphead
IF EOF()
   RETURN
ENDIF
PRIVATE _pspacing
_pspacing=gn_pspace
IF gn_level = 0
   gn_level=50
ENDIF
IF gn_level = 4
   IF 2 * gn_pspace  < gn_atline
      IF (gl_widow .AND. _plineno+Gheight(4) > gn_atline + 1) ;
      .OR. (gl_widow .AND. _plineno+2 * gn_pspace > gn_atline)
         EJECT PAGE
      ENDIF
   ENDIF
ENDIF
IF gn_level <= 4
   DO Head4
ENDIF
gn_level=0
RETURN
* EOP: Grphead.PRG

*-- Process Group Summary bands during group breaks
PROCEDURE Grpfoot
PARAMETER ln_level
IF ln_level >= 96
   DO Foot96
ENDIF
RETURN
* EOP: Grpfoot.PRG

PROCEDURE Pghead
PRIVATE ll_heading, ln_width
ll_heading = .T.
ln_width = _rmargin - _lmargin
?
*-- Print HEADING parameter - if it doesn't fit on line one
*-- Value added to gn_length is the last column on line one times two
IF .NOT. gl_plain .AND. gn_length + 160 > ln_width
   ?? gc_heading FUNCTION "I;V"+LTRIM(STR(ln_width))
   ?
   ll_heading = .F.
ENDIF

?? IIF(gl_plain,'',gd_date) AT 0,;
 IIF(gl_plain,'' , "PAGE  " ) AT 70,;
 IIF(gl_plain,'',_pageno) PICTURE "999" 

*-- Print HEADING parameter - if it fits on line one
IF .NOT. gl_plain .AND. gn_length > 0 .AND. ll_heading
   ?? " "
   ?? gc_heading FUNCTION "I;V"+LTRIM(STR(ln_width-(_pcolno*2)))
ENDIF
?
?
RETURN
* EOP: Pghead

PROCEDURE Rintro
?
DEFINE BOX FROM 27 TO 56 HEIGHT 4 DOUBLE
?
?? "A-T FURNITURE INDUSTRIES" AT 30
?
?? "INVENTORY REPORT" AT 34
?
?
?
?
RETURN
* EOP: Rintro

PROCEDURE Head4
IF gn_level=1
   RETURN
ENDIF
?? ;
"";
+ "";
AT 0
?
?? "VENDOR ID: " STYLE "BU" AT 0,;
 Vendor_id FUNCTION "T" STYLE "BU" 
?
RETURN

PROCEDURE __Detail
IF 10 * gn_pspace < gn_atline - (_pspacing * 3 + 1)
   IF gl_widow .AND. _plineno+10 * gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?? ;
"";
+ "";
AT 0
?
?? "PART I.D.: " AT 3,;
 Part_id FUNCTION "T" ,;
 "NAME: " AT 27,;
 Part_name FUNCTION "T" AT 40
?
?? "DESCRIPTION: " AT 27,;
 Descript FUNCTION "T" 
?
?? "QUANTITY ON HAND:   " AT 27,;
 Qty_onhand PICTURE "9,999" ,;
 "SALES PRICE: $ " AT 55,;
 Price PICTURE "99,999.99" 
?
?? "COST: $ " AT 27,;
 "  " AT 41,;
 Cost PICTURE "99,999.99" ,;
 "ORDER QTY(min):    " AT 55,;
 Qty_2order PICTURE "9,999" 
?
?? " ==========" AT 41,;
 "DATE ORDERED:   " AT 55,;
 Date_order 
?
?? "INVENT. COST:$" AT 27,;
 inv_cost PICTURE "999,999.99" AT 42,;
 "DISCONTINUED: " AT 55,;
 Discontinu PICTURE "Y" 
?
?? "COMMENTS: " AT 27,;
 Comments FUNCTION "T" 
?
?
?
RETURN
* EOP: __Detail

PROCEDURE Foot96
?
?? "INVENTORY COST FOR VENDOR " AT 0,;
 r_foot1 FUNCTION "T" ,;
 ": $ " ,;
 r_msum1 PICTURE "999,999.99" ,;
 " " 
?
RETURN

PROCEDURE Rsumm
?
?? ;
"";
+ "";
AT 0
?
?? "TOTAL INVENTORY COST: " AT 0,;
 "$ " AT 32,;
 r_msum2 PICTURE "999,999.99" 
?
?? ;
"";
+ "";
AT 0
gl_fandl=.F.        && last page finished
?
RETURN
* EOP: Rsumm

PROCEDURE Pgfoot
PRIVATE _box, _pspacing
gl_widow=.F.         && disable widow checking
_pspacing=1
?
IF .NOT. gl_plain
   _pspacing=gn_pspace
   ?? "REPORT PREPARED BY FINANCIAL DEPARTMENT" AT 24
ENDIF
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

