**************************************************************
* Vndrentr.prg
*  A data entry program that uses UI objects and the sample
*  database Client.dbf. It accompanies Chapter 23 of the
*  "Programmer's Guide."
**************************************************************
*
*-------------------------------------------------------------
* FORM dClient
* Client data entry form window. Its event handlers open the 
* database and set the evironment. Three custom properties, 
* TalkSet, EchoSet, and CUASet, save the TALK, ECHO, and 
* CUAENTER settings so they can be set to those same values 
* when the program exits.
*-------------------------------------------------------------

USE CLIENT           && Temporary until EDITOR DataSource works with 
                     && USE done in OnOpen event.
DEFINE FORM dClient FROM 1,4 TO 20,76 ;
   PROPERTY ;
      Text "Enter customer data", ;
      OnOpen FormOpen, ;
      OnClose FormClose ;

dClient.TalkSet = SET("TALK")   && Save setting of TALK.
dClient.EchoSet = SET("ECHO")   && Save setting of ECHO.
dClient.CUASet = SET("CUAENTER")&& Save setting of CUAENTER.

DEFINE TEXT t1 OF dClient AT 1,2  ;
   PROPERTY  Text "Client identifier"

DEFINE ENTRYFIELD ef1 OF dClient AT 2,5;
   PROPERTY ;
      Width 6, Datalink "CLIENT_ID", ;
      StatusMessage "Enter unique client id (format A12345)." 

DEFINE TEXT t2 OF dClient AT 3,2  ;
   PROPERTY  Text "Company"

DEFINE ENTRYFIELD ef2 OF dClient AT 4,5 ;
   PROPERTY ;
      Width 30, Datalink "CLIENT", ;
      StatusMessage "Enter company name." 

DEFINE TEXT t3 OF dClient AT 5,2 ;
   PROPERTY Text "First name"

DEFINE ENTRYFIELD ef3 OF dClient AT 6,5 ;
   PROPERTY ;
     Width 15, Datalink "FIRSTNAME", ;
      StatusMessage "Enter first name of contact." 

DEFINE TEXT t4 OF dClient AT 7,2  ;
   PROPERTY Text "Last name"

DEFINE ENTRYFIELD ef4 OF dClient AT 8,5 ;
   PROPERTY ;
      Width 15, Datalink "LASTNAME", ;
      StatusMessage "Enter last name of contact." 

DEFINE TEXT t5 OF dClient AT 9,2  ;
   PROPERTY Text "Address"

DEFINE ENTRYFIELD ef5 OF dClient AT 10,5 ;
   PROPERTY ;
      Width 30, Datalink "ADDRESS", ;
      StatusMessage "Enter company address." 

DEFINE TEXT t6 OF dClient AT 11,2  ;
   PROPERTY Text "City"

DEFINE ENTRYFIELD ef6 OF dClient AT 12,5 ;
   PROPERTY ;
      Width 20, Datalink "City", ;
      StatusMessage "Enter city where company is located." 

DEFINE TEXT t7 OF dClient AT 11,30  ;
   PROPERTY Text "State"

DEFINE ENTRYFIELD ef7 OF dClient AT 12,33 ;
   PROPERTY ;
      Width 2, Datalink "STATE", ;
      StatusMessage "Enter state where company is located." 

DEFINE TEXT t8 OF dClient AT 13,2  ;
   PROPERTY Text "Zip code"

DEFINE ENTRYFIELD ef8 OF dClient AT 14,5;
   PROPERTY ;
      Width 10, Datalink "ZIP", ;
      StatusMessage "Enter zip code where company is located." 

DEFINE TEXT t9 OF dClient AT 13,19  ;
   PROPERTY Text "Phone number"

DEFINE ENTRYFIELD ef9 OF dClient AT 14,22;
   PROPERTY ;
      Width 13, Datalink "PHONE", PICTURE "(999)999-9999", ;
      StatusMessage "Enter phone number of company contact, area code first." 

DEFINE TEXT t10 OF dClient AT 1,46 ;
   PROPERTY Text "Client history" 

DEFINE EDITOR ed1 OF dClient ;
   FROM 2,38 TO 14,68 ;
   PROPERTY ;
      Datasource "MEMO CLIEN_HIST", ;
      StatusMessage "Enter notes about customer and account.", ;
      WordWrap .T.

DEFINE PUSHBUTTON pb1 OF dClient AT 16,30 ;
   PROPERTY ;
       OnClick Previous, Text "&<<", Width 6, ;
      StatusMessage "Go to previous record." 

DEFINE PUSHBUTTON pb2 OF dClient AT 16,37 ;
   PROPERTY ;
      OnClick Next, Text ">&>", Width 6, Default .T., ;
      StatusMessage "Go to next record."

lVoid = dClient.Open()             && Open the form window.

PROCEDURE FormOpen                 && OnOpen event handler for form window dClient.
   USE CLIENT IN 1                 && Open Client database.
   CLEAR
   SET TALK OFF
   SET ECHO OFF
   SET CUAENTER ON
   lVoid = dClient.ef1.SetFocus()  && Give focus to first entry field on form.
RETURN

PROCEDURE FormClose        && OnClose event handler for form window dClient.
   USE IN 1                && Close Client database.
   IF this.TalkSet = "ON"  && If TALK was on before starting,
      SET TALK ON          && set it back on. 
   ENDIF
   IF this.EchoSet = "ON"  && If ECHO was on before starting, 
      SET ECHO ON          && set it back on.
   ENDIF
   IF this.CUASet = "OFF"  && If CUAENTER was off before starting, 
      SET CUAENTER OFF     && turn it back off.
   ENDIF
RETURN

PROCEDURE Next                    && OnClick event handler for pushbutton pb1.
   lVoid = dClient.Submit()       && Write current contents of form to database.

   IF EOF()                       && If at EOF, can't move to next record.
      APPEND BLANK                && Append new, blank record to end of database.
   ELSE 
      SKIP                        && Not at EOF, so skip to next record.
      lVoid = dClient.Refresh()   && Display record contents in form.
   ENDIF

   lVoid = dClient.ef1.SetFocus() && Give focus again to first entry field.
RETURN

PROCEDURE Previous                && OnClick event handler for pushbutton pb2.
   lVoid = dClient.Submit()       && Write current contents of form to database.

   IF BOF()                       && If at beginning, cannot move back one.
*     do nothing
   ELSE
      SKIP -1                     && Not at beginning, so move back one record.
      lVoid = dClient.Refresh()   && Display record contents in form.   
   ENDIF
   lVoid = dClient.ef1.SetFocus() && Give focus to first entry field.
RETURN
