
*.............................................................................
*
*   Program Name: MDSKIP.PRG          Copyright: Borland International
*   Date Created:  7 Apr 94            Language: dBASE 5.0
*   Time Created: 21:40:11               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

*.................................................................
* Procedure Name:   MDSkip
* Parameters:       None
* Ext Memvars:      None
* Description:      Skips the number of records the user requests
*.................................................................
PROCEDURE MDSkip
    PRIVATE lVoid, nRec, oForm

    #include "TalkOff.hdb"
    
    oForm = This.Form
    IF .NOT. SubmitFm( m->oForm )
        #include "talkon.hdb"
        RETURN
    ENDIF
    
    IF .NOT. ISBLANK(ALIAS())
        IF RECCOUNT() > 1
            #include "MDSKIP.DFM"
            
            MDSkip.sbName2.RangeMin = (RECCOUNT() - 1) * (-1)
            MDSkip.sbName2.RangeMax = RECCOUNT() - 1
            lVoid = MDSkip.sbName2.SetFocus()
            lVoid = MDSkip.ReadModal()
            
            IF MDSkip.Action
                ON ERROR DO SkError
                nRec = RECNO()
                SKIP MDSkip.sbName2.Value
                ON ERROR
            ENDIF
            
            IF TYPE("oForm.ClassName") = "C"
                IF oForm.ClassName = "FORM"
                   lVoid = oForm.Refresh()
                    DO UpLook WITH m->oForm
                    lVoid = oForm.Refresh()
                    *------------------------------------------
                    *-- Check for need to update Detail regions
                    *------------------------------------------
                    IF TYPE( "Form.DetExist" ) = "L" .AND. Form.DetExist
                        DO UpDetail WITH m->Form
                    ENDIF
                ENDIF
            ENDIF
            
            lVoid = MDSkip.Release()
            RELEASE MDSkip
        ENDIF
    ENDIF
    
    #include "TalkOff.hdb"
    
RETURN


*...........................................................................
* Procedure Name:   SkError
* Parameters:       Last record number
* Ext Memvars:      None
* Description:      Displays an error message if the record is out of range
*...........................................................................
PROCEDURE SkError
PARAMETERS nRec
    PRIVATE lVoid, cIntlM1, cIntlM2

    cIntlM1 = [Cannot skip past end of file]
    cIntlM2 = [Cannot skip past beginning of file]
    
    IF MDSkip.sbName2.Value > 0
        DO ErrorMsg WITH m->cIntlM1
    ELSE
        DO ErrorMsg WITH m->cIntlM2
    ENDIF
       
    MDSkip.sbName2.Value = 0

    IF TYPE("m->nRec") = "N"
	    GOTO m->nRec
	ENDIF	    
RETURN    
                
