
*.............................................................................
*
*   Program Name: MDORDER.PRG         Copyright: Borland International
*   Date Created: 10 Apr 94            Language: dBASE 5.0
*   Time Created: 18:28:23               Author: Borland dBASE R&D
*.............................................................................

#define ALLTRIM(kStr)  LTRIM(RTRIM(kStr))

*..........................................................................
* Procedure Name:   MDOrder
* Parameters:       None
* Ext Memvars:      None
* Description:      Display a list of index tags for the user to pick from
*                   and changes the current order to that tag.
*..........................................................................
PROCEDURE MDOrder
    PRIVATE lVoid, cStr, nCnt, i, oForm, cIntlMsg1, cIntlMsg2, nSel
    
    #include "TALKOFF.HDB"

    cIntlMsg1 = [<Natural>]
    cIntlMsg2 = [Put table in natural order (no active index)]
    
    DECLARE aTag[1], aKey[1]
    
    oForm = This.Form

    IF .NOT. ISBLANK( NDX() )           && Display tags for MDX files only
        nCnt = 0                        && Assume no tags if .NDX active
    ELSE
        nCnt = TAGCOUNT()
    ENDIF

    IF .NOT. ISBLANK(ALIAS())
        aTag[1] = m->cIntlMsg1
        aKey[1] = m->cIntlMsg2

        IF m->nCnt > 0
            FOR i = 1 TO m->nCnt
                lVoid = AGROW(aTag,1)
                lVoid = AGROW(aKey,1)
                aTag[m->i+1] = UPPER(TAG(m->i))
                aKey[m->i+1] = KEY(m->i)
            ENDFOR
        ENDIF
        
        #include "MDORDER.DFM"
        
        MDOrder.TagList.DataSource = "ARRAY aTag"
        lVoid = MDOrder.TagList.SetFocus()
        lVoid = MDOrder.ReadModal()
        
        IF MDOrder.Action
            nSel = MDOrder.TagList.CurSel
            IF m->nSel = 1
                SET ORDER TO            && Clear both the MDX
                SET INDEX TO            && and NDX index files
            ELSE
                SET ORDER TO TAG(m->nSel - 1)
            ENDIF
            
        ENDIF
        
        lVoid = MDOrder.Release()
    ENDIF

    #include "TALKON.HDB"

RETURN                


*...................................................................
* Procedure Name:   SayKey
* Parameters:       None
* Ext Memvars:      None
* Description:      Displays a status message showing the index key
*                   for the selected tag
*...................................................................
PROCEDURE SayKey
    This.StatusMessage = aKey[This.CurSel]
RETURN    

