*****************************************************************
* FILE: MARY.PRG
* Shows how to use the OnMove and OnSize properties of a form
* window to control another form window. Accompanies Chapter 22
* of the "Programmer's Guide."
*****************************************************************
DEFINE FORM Mary ;
   PROPERTY ;
      Sizeable .T., ;
      Left 2, Width 25, Top 2, Height 10, ;
      OnOpen MaryOpen, ;
      OnMove MaryMove, ;
      OnSize MaryMove, ;
      OnClose MaryClose
      
DEFINE FORM LittleLamb ;
   PROPERTY ;
      Top Mary.Top + 5, ;
      Width 20, ;
      Left Mary.Left + Mary.Width + 2, ;
      Height 5, ;
      Text " ", ;
      Moveable .F.

DEFINE TEXT Text1 OF LittleLamb ;
   AT 0,3 ;
   PROPERTY ;
      Text "little lamb", ;
      ColorNormal "W+/B"

lVoid = Mary.Open()           && Open form window Mary.

PROCEDURE MaryOpen            && OnOpen event handler for form window Mary.
   SET TALK OFF
   SET ECHO OFF
   lVoid = LittleLamb.Open()  && Open attached form window.
   lVoid = Mary.SetFocus()    && Give focus back to form window Mary.
RETURN

*----------------------------------------------------------------------------
* MaryMove
* OnMove event handler for form window Mary. Changes Top, Height, Width,
* and Left properties of LittleLamb form window so it changes size and 
* position along with Mary. Tries to center Text1 obj. in LittleLamb as well.
*-----------------------------------------------------------------------------
PROCEDURE MaryMove
   LittleLamb.Top = this.Top + INT(this.height / 1.5)
   LittleLamb.Height = INT(this.height / 2.5) 
   LittleLamb.Width = INT(this.width / 1.35)  
   LittleLamb.Text1.Left = INT(this.width / 2 - 11)
   LittleLamb.Left = this.Left + this.Width + 2 
RETURN

PROCEDURE MaryClose           && OnClose event handler for form window Mary
   lVoid = LittleLamb.Release()  && Release attached form window from memory
   RELEASE LittleLamb            && and delete its now null object reference var.
   SET TALK ON
   SET ECHO ON
RETURN
