
FUNCTION FileDrv
PARAMETER pc_fname
*--------------------------------------------------------------------
* NAME
*   FileDrv - returns the drive letter from a DOS filename
*
* SYNOPSIS
*   FileDrv( pc_fname )
*
* DESCRIPTION
*   FileDrv() determines the drive letter, if any,
*   contained in the file specification pc_fname
*   and returns just the drive letter.
*
*   No upper or lower case conversion is performed.
*   If the filespec contains no drive letter, a
*   null string ("") will be returned.
*
* PARAMETER
*   pc_fname - A character DOS filespec
*
* EXAMPLES
*   lc_drive = FileDrv( "C:\TEST\FOO.PRG" )
*     ( lc_drive will equal "C" )
*
*   lc_drive = FileDrv( "FOO.PRG" )
*     ( lc_drive will equal "" )
*
* SEE ALSO
*   _FILEPATH(), _FILEROOT(), _FILETYPE()
*
*--------------------------------------------------------------------
RETURN( IIF( AT( ":", m->pc_fname ) = 2, ;
             LEFT( m->pc_fname, 1 ), "" ) )
*-- EOF: FileDrv( pc_fname )

