PROCEDURE DefValue
*----------------------------------------------------------------------------
* NAME
*   DefValue - Scans the objects looking for the custom DefValue property.
*              If found and the type matches the Value of the object, then
*              replace the Value with the DefValue.
*
*              This routine is used by SkipHand and MDAdd when adding 
*              new records
*----------------------------------------------------------------------------
    PRIVATE oF, oC

    *------------------------------------------------------------
    *-- Set the Value property with the DefValue if it exists and
    *-- the types match.  
    *------------------------------------------------------------
    oF = Form.First                     && Get the first object
    oC = m->oF                          && Intialize the current object
    DO WHILE .T.
        *----------------------------------------
        *-- Do the Value and DefValue types match
        *----------------------------------------
        IF TYPE( "oC.Value" ) # "U" .AND. ;
           TYPE( "oC.Value" ) = TYPE( "oC.DefValue" )
            oc.Value = oC.DefValue      && Make the default assignment
        ENDIF
        oC = oC.After                   && Get the next object
        IF oC = m->oF                   && If we are at the first, then
            EXIT                        && all objects were processed.
        ENDIF
    ENDDO

RETURN
*-- EOP: DefValue
