****************************************************************
* FILE CMBCHG.PRG
* Shows how to use the OnChange property of a Style 3 combo box
* and the Valid property of a Style 2 combo box to register
* changes to their entry fields. Accompanies Chapter 22 of the
* "Programmer's Guide."
****************************************************************
DEFINE FORM f FROM 9,10 TO 21,62 PROPERTY Text "Choose an item"

DEFINE TEXT t1 of f AT 1,2 PROPERTY Text "Item selected"

DEFINE TEXT t2 of f AT 2,5 ;
   PROPERTY Text "Nothing selected", ColorNormal "RG/G", Label .F.

DEFINE TEXT t3 of f AT 1,28 PROPERTY Text "Category selected", Label .F.
   
DEFINE TEXT tcmb1 OF f AT 4,2 ;
   PROPERTY Text "Choose or enter item:"

*------------------------------------------------------------------------
* Combo box cmb1 prompts user for items from the category picked in cmb2.
* The user can also enter any item they want. When they tab out of the
* combo box, Valid is triggered. Its event handler, cmb1Val, displays
* the user selection in the text object (t2) above the combo box.
*------------------------------------------------------------------------
DEFINE COMBOBOX cmb1 OF f AT 5,5 ;
   PROPERTY ;
      Datasource "STRING apple banana grape kiwi kumquat mango orange pineapple", ;
      ValidRequired .T., ;
      Valid cmb1Val
   
DEFINE TEXT tcmb2 OF f AT 4,28 ;
   PROPERTY Text "Pick a category:"

*-----------------------------------------------------------------------
* Combo box cmb2 prompts user for categories from which to choose items 
* in cmb1. The user must pick from the list--they cannot type one in. 
* When they make selection, OnChange is triggered. Its event handler, 
* cmb2Chg, displays the user selection in the text object (t4) above 
* this combo box and changes the selection in the other combo box.
*-----------------------------------------------------------------------
DEFINE COMBOBOX cmb2 OF f AT 5,31 ;
   PROPERTY ;
      Datasource "STRING fruit vegetables flowers ", ;
      Style 3, ;
      OnChange cmb2Chg

DEFINE TEXT t4 of f AT 2,31  ;
   PROPERTY Text f.cmb2.Value, ColorNormal "RG/G", Label .F.

lvoid = f.Open()          && Open the form window.
lvoid = f.cmb1.SetFocus() && Give first combo box focus.

FUNCTION cmb1Val          && Valid event handler for cmb1.
   lRtnVal = .T.          && Does not check validity of entry (normally it would).
   f.t2.Text = this.Value && Set text object above cmb1 to 
RETURN  lRtnval           && value in cmb1's entry field.

PROCEDURE cmb2Chg         && OnChange event handler for cmb1.
   f.t4.Text = this.Value && Set text obj. above cmb2 to the selected value.
   DO CASE                && Set item list displayed in cmb1's list box.
      CASE this.Value = "fruit"
         f.cmb1.Datasource = ;
            "STRING apple banana grape kiwi kumquat mango orange pineapple"
      CASE this.Value = "vegetables"
         f.cmb1.Datasource = ;
            "STRING broccoli celery cucumber jalapeno kale potato tomato" 
      CASE this.Value = "flowers"
         f.cmb1.Datasource = ;
            "STRING carnations marigolds petunias poppies roses tulips"
   ENDCASE         
RETURN
