
PROCEDURE CanHand
*----------------------------------------------------------------------------
* NAME
*   OKHand - Generic Cancel Button handler
*
* DESCRIPTION
*   Closes the form and sets the form's Action custom property value .F.
*----------------------------------------------------------------------------
#include "talkoff.hdb"

    PRIVATE lVoid

    *-------------------------------------------------------------------
    *-- For ReadModal() forms, force Action custom property value to .F.
    *-------------------------------------------------------------------
    Form.Action = .F.

    *---------------------
    *-- Shut down the form
    *---------------------
    lVoid = Form.Close()

#include "talkon.hdb"
RETURN
*-- EOP: CanHand


PROCEDURE HelpObj
*-----------------------------------------------------------
* NAME
*   HelpObj
*
* DESCRIPTION
*   Displays user-defined help, if any, for this button.
*
*-----------------------------------------------------------
    IF This.ClassName # "MENUITEM"
        DO HelpDspy WITH m->This
    ELSE
        IF TYPE("Form.ActiveControl()") = "O"
            DO HelpDspy WITH Form.ActiveControl()
        ENDIF
    ENDIF
RETURN

