
*.............................................................................
*
*   Program Name: CALC.PRG            Copyright: Borland International
*   Date Created: 12/12/93             Language: dBASE 5.0
*   Time Created: 15:02:45               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

#include "DKEYS.HDB"

#define kBell  CHR(7)
#define kPoint SET("POINT")

#define ALLTRIM(kStr)  LTRIM(RTRIM(kStr))

*.........................................................
* Procedure Name:   Calc
* Parameters:       None
* Ext Memvars:      None
* Description:      Main procedure for calculator program
*.........................................................
PROCEDURE Calc
    PRIVATE lVoid

    SET TALK OFF    

    IF TYPE( "_CmdWindow.dbCalc.Top" ) # "N"
        DO DefCalc
    ENDIF
    
    lVoid = _CmdWindow.dbCalc.bequal.SetFocus()
    lVoid = _CmdWindow.dbCalc.Open()    

RETURN


*...............................................
* Procedure Name:   DefCalc
* Parameters:       None
* Ext Memvars:      None
* Description:      Defines the calculator form
*...............................................
PROCEDURE DefCalc
    
    #include "DBCALC.DFM"
    
    dbCalc.bDec.Text = "~" + SET("POINT") + "~"
    
    _CmdWindow.dbCalc = m->dbCalc

RETURN


*.............................................
* Procedure Name:   BuMinus
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbCalc.e.Text
* Description:      processes "+/-" key
*.............................................
PROCEDURE BuMinus
    PRIVATE cStr, nVal
    
    cStr = ""
    nVal = 0.0
    
    cStr = CvtPoint(ALLTRIM(_CmdWindow.dbCalc.e.Text))
    nVal = VAL(m->cStr)
    nVal = m->nVal * (-1)
    cStr = MakeNum(m->nVal)
    
    _CmdWindow.dbCalc.e.Text = m->cStr

RETURN


*.......................................................
* Procedure Name:   BClear
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbCalc
* Description:      Clears the values in the calculator
*.......................................................
PROCEDURE BClear
    PRIVATE lVoid

    _CmdWindow.dbCalc.b1.Enabled      = .T.
    _Cmdwindow.dbCalc.b2.Enabled      = .T.
    _Cmdwindow.dbCalc.b3.Enabled      = .T.
    _Cmdwindow.dbCalc.b4.Enabled      = .T.
    _Cmdwindow.dbCalc.b5.Enabled      = .T.
    _Cmdwindow.dbCalc.b6.Enabled      = .T.
    _Cmdwindow.dbCalc.b7.Enabled      = .T.
    _Cmdwindow.dbCalc.b8.Enabled      = .T.
    _Cmdwindow.dbCalc.b9.Enabled      = .T.
    _Cmdwindow.dbCalc.b0.Enabled      = .T.
    _Cmdwindow.dbCalc.bplus.Enabled   = .T.
    _Cmdwindow.dbCalc.bequal.Enabled  = .T.
    _Cmdwindow.dbCalc.bminus.Enabled  = .T.
    _Cmdwindow.dbCalc.buminus.Enabled = .T.
    _Cmdwindow.dbCalc.btimes.Enabled  = .T.
    _Cmdwindow.dbCalc.bDec.Enabled    = .T.
    _Cmdwindow.dbCalc.bdivide.Enabled = .T.

    _CmdWindow.dbCalc.lastValue =  0
    _CmdWindow.dbCalc.lastKeyOp = .F.
    _CmdWindow.dbCalc.lastOp    = ""
    _CmdWindow.dbCalc.lDec      = .F.

    _CmdWindow.dbCalc.e.Text  =  SPACE(15) + "0"
RETURN


*...........................................
* Procedure Name:   PressOp
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbCalc
* Description:      Processes operator keys 
*...........................................
PROCEDURE PressOp
PARAMETER cKey    
    PRIVATE lVoid
    
    IF (_CmdWindow.dbCalc.lastKeyOp) .OR. ISBLANK(_CmdWindow.dbCalc.lastOp)
        _CmdWindow.dbCalc.lastValue = VAL(CvtPoint(ALLTRIM(_CmdWindow.dbCalc.e.Text)))
    ELSE
        DO CASE
            CASE _CmdWindow.dbCalc.lastOp = "+"
                _CmdWindow.dbCalc.lastValue = _CmdWindow.dbCalc.lastValue + VAL(CvtPoint(ALLTRIM(_CmdWindow.dbCalc.e.Text)))
                _CmdWindow.dbCalc.e.Text   = MakeNum(_CmdWindow.dbCalc.lastValue)
            CASE _CmdWindow.dbCalc.lastOp = "-"
                _CmdWindow.dbCalc.lastValue = _CmdWindow.dbCalc.lastValue - VAL(CvtPoint(ALLTRIM(_CmdWindow.dbCalc.e.Text)))
                _CmdWindow.dbCalc.e.Text   = MakeNum(_CmdWindow.dbCalc.lastValue)
            CASE _CmdWindow.dbCalc.lastOp = "*"
                _CmdWindow.dbCalc.lastValue = _CmdWindow.dbCalc.lastValue * VAL(CvtPoint(ALLTRIM(_CmdWindow.dbCalc.e.Text)))
                _CmdWindow.dbCalc.e.Text   = MakeNum(_CmdWindow.dbCalc.lastValue)
            CASE _CmdWindow.dbCalc.lastOp = "/"
                IF VAL(CvtPoint(ALLTRIM(_CmdWindow.dbCalc.e.Text))) # 0
                    _CmdWindow.dbCalc.lastValue = _CmdWindow.dbCalc.lastValue / VAL(CvtPoint(ALLTRIM(_CmdWindow.dbCalc.e.Text)))
                    _CmdWindow.dbCalc.e.Text   = MakeNum(_CmdWindow.dbCalc.lastValue)
                ELSE
                    ?? kBell
                    _CmdWindow.dbCalc.e.Text          = "E" + SPACE(15)
                    _CmdWindow.dbCalc.b1.Enabled      = .F.
                    _Cmdwindow.dbCalc.b2.Enabled      = .F.
                    _Cmdwindow.dbCalc.b3.Enabled      = .F.
                    _Cmdwindow.dbCalc.b4.Enabled      = .F.
                    _Cmdwindow.dbCalc.b5.Enabled      = .F.
                    _Cmdwindow.dbCalc.b6.Enabled      = .F.
                    _Cmdwindow.dbCalc.b7.Enabled      = .F.
                    _Cmdwindow.dbCalc.b8.Enabled      = .F.
                    _Cmdwindow.dbCalc.b9.Enabled      = .F.
                    _Cmdwindow.dbCalc.b0.Enabled      = .F.
                    _Cmdwindow.dbCalc.bplus.Enabled   = .F.
                    _Cmdwindow.dbCalc.bequal.Enabled  = .F.
                    _Cmdwindow.dbCalc.bminus.Enabled  = .F.
                    _Cmdwindow.dbCalc.buminus.Enabled = .F.
                    _Cmdwindow.dbCalc.btimes.Enabled  = .F.
                    _Cmdwindow.dbCalc.bDec.Enabled    = .F.
                    _Cmdwindow.dbCalc.bdivide.Enabled = .F.
                ENDIF
        ENDCASE
    ENDIF
    
    _CmdWindow.dbCalc.lastKeyOp = .T.
    
    IF TYPE("cKey") = "C"
        _CmdWindow.dbCalc.lastOp = m->cKey
    ELSE    
        _CmdWindow.dbCalc.lastOp = SUBSTR(ALLTRIM(This.Text), 2, 1)
    ENDIF    
    
    IF _CmdWindow.dbCalc.lastOp = "="
        _CmdWindow.dbCalc.lastOp = ""
    ENDIF
RETURN        


*.......................................................
* Procedure Name:   NumClick
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbCalc.e.Text
* Description:      Processes numbers in the calculator
*.......................................................
PROCEDURE NumClick
PARAMETERS cNum
    PRIVATE cNStr, lVoid
    
    IF TYPE("cNum") # "C"
        cNum = SUBSTR(This.Text, 2, 1)
    ENDIF
    
    cNum = ALLTRIM(m->cNum)     

    IF _CmdWindow.dbCalc.lastKeyOp
        IF m->cNum # kPoint
            _CmdWindow.dbCalc.e.Text = MakeNum(VAL(m->cNum))
            _CmdWindow.dbCalc.lDec      = .F.
        ELSE
            _CmdWindow.dbCalc.e.Text   = MakeNum(0)
            _CmdWindow.dbCalc.lDec      = .T.
        ENDIF
        _CmdWindow.dbCalc.lastKeyOp = .F.        
    ELSE
        IF m->cNum # kPoint
            cNStr = ALLTRIM(_CmdWindow.dbCalc.e.Text)

            IF (_CmdWindow.dbCalc.lDec) .AND. (.NOT.(kPoint $ m->cNStr)) .AND. (LEN(m->cNStr) < 16)
                cNStr = m->cNStr + kPoint
            ENDIF
            
            IF LEN(m->cNStr) < 16
                IF m->cNStr == "0"
                    cNStr = ""
                ENDIF    
                cNStr = m->cNStr + m->cNum
            ENDIF
            
            _CmdWindow.dbCalc.e.Text = SPACE(16 - LEN(m->cNStr)) + m->cNStr
        ELSE
            _CmdWindow.dbCalc.lDec = .T.
        ENDIF    
    ENDIF
RETURN


*......................................
* Procedure Name:   CalClose
* Parameters:       None
* Ext Memvars:      dbCalc
* Description:      Release Calculator
*......................................
PROCEDURE CalClose
    lVoid = _CmdWindow.dbCalc.Close()
    lVoid = _CmdWindow.dbCalc.Release()
    _CmdWindow.dbCalc = .F.
    RELEASE dbCalc
RETURN


*............................................................
* Procedure Name:   ClcAbout
* Parameters:       None
* Ext Memvars:      None
* Description:      Displays an about box for the calculator
*............................................................
PROCEDURE ClcAbout
    PRIVATE lVoid
    
    #include "CLCABOUT.DFM"
    
    lVoid = ClcAbout.ReadModal()
    lVoid = ClcAbout.Release()
    RELEASE ClcAbout
RETURN    

*.........................................................................
* Procedure Name:   bCopy
* Parameters:       None
* Ext Memvars:      _Clipboard
* Description:      Copies the current value of _CmdWindow.dbCalc.e to the Clipboard
*.........................................................................
PROCEDURE bCopy
    PRIVATE cNum
    
    cNum = ALLTRIM(_CmdWindow.dbCalc.e.Text)

    _Clipboard.InsertLine = m->cNum
    _Clipboard.ExtendSelection = .T.
    _Clipboard.Column = 1
    _Clipboard.ExtendSelection = .F.
RETURN
    

*............................................................................
* Function Name:    MakeNum
* Parameters:       nVal, a numeric
* Ext Memvars:      None
* Return Value:     string
* Description:      converts nVal to a padded string
*............................................................................
FUNCTION MakeNum
PARAMETERS nVal
    PRIVATE cStr
        
    cStr = ALLTRIM(STR(m->nVal, 16, 14))

    IF (kPoint $ m->cStr) .AND. (.NOT.("E" $ m->cStr))
        DO WHILE RIGHT(m->cStr,1) = "0"
            cStr = LEFT(m->cStr, LEN(m->cStr) - 1)
        ENDDO

        IF (RIGHT(m->cStr,1) = kPoint)
            cStr = LEFT(m->cStr, LEN(m->cStr) - 1)
        ENDIF
    ENDIF    
    
    cStr = SPACE(16 - LEN(m->cStr)) + m->cStr
RETURN m->cStr


*..........................................................................
* Function Name:    CvtPoint
* Parameters:       string of a number
* Ext Memvars:      None
* Return Value:     string, number with "." as decimal point
* Description:      Takes a numeric string and makes sure that the decimal
*                   point is a ".".  Helps the calculator work 
*                   internationally.
*..........................................................................
FUNCTION CvtPoint
PARAMETERS cStr
    PRIVATE cRet
    
    cRet = ""
        
    IF (kPoint $ m->cStr) .AND. (kPoint # ".")
        cRet = STUFF(m->cStr, AT(kPoint, m->cStr), 1, ".")
    ELSE
        cRet = m->cStr    
    ENDIF
    
RETURN m->cRet


*......................................................................
* Procedure Name:   IDEHelp
* Parameters:       None
* Ext Memvars:      None
* Description:      Calls the help system with current object's HelpID
*......................................................................
PROCEDURE IDEHelp
    PRIVATE lVoid
    
    _SysHelp.HelpID = This.HelpID
    lVoid = _SysHelp.ReadModal()
RETURN    


