
*......................................................................
*
*   Program Name: ASCII.PRG           Copyright: Borland International
*   Date Created: 01/21/94             Language: dBASE 5.0
*   Time Created: 10:38:14               Author: Borland dBASE R&D
*   /brief/library.src
*......................................................................

#define kMinWidth   22
#define kMaxWidth   72
#define kMinHeight  18

#define kListWidth  15

#define kNULL        0
#define kSpace      32
#define kMaxStrLen  80

#define kTop 1

#define ALLTRIM(kStr) LTRIM(RTRIM(kStr))

*.................................................................
* Procedure Name:  ASCII
* Parameters:      None
* Ext Memvars:     None
* Description:     Displays an ASCII table in a dBASE 5.0 form
*                  Codes are shown in decimal, hex, and character
*.................................................................
PROCEDURE ASCIIC
    PRIVATE lVoid
    
    #include "TALKOFF.HDB"

    IF TYPE("_CmdWindow.dbASCII.top") = "N"  && if another instance of dbASCII is active
        lVoid = _CmdWindow.dbASCII.lTable.Setfocus()
        lVoid = _CmdWindow.dbASCII.Open()
    ELSE
        DO DEFASCII    
    ENDIF
RETURN


*...............................................
* Procedure Name:   DEFASCII
* Parameters:       None
* Ext Memvars:      None
* Description:      Define the ASCII Chart form
*...............................................
PROCEDURE DEFASCII
    PRIVATE lVoid

    DECLARE aCodes[256]     && array of 256 rows to hold codes

    *.............................
    * define the ascii table form
    *.............................
    #include "ASCIIC.DFM"

    _CmdWindow.dbASCII = m->dbASCII

    DO InitCodes
    
    _CmdWindow.dbASCII.lTable.DataSource = "ARRAY aCodes"
    _CmdWindow.dbASCII.ASCMenu.mEdit.mMin.Enabled = .F.
    lVoid = _CmdWindow.dbASCII.lTable.Setfocus()
    lVoid = _CmdWindow.dbASCII.Open()

RETURN


*..............................................................
* Procedure Name:   Cpy2Entr
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbASCII.e1
* Description:      Copies character from chart to entry field
*..............................................................
PROCEDURE Cpy2Entr
    PRIVATE cValue, nSel, nTLen

    SET TALK OFF
    
    cValue = SPACE(kMaxStrLen + 1)
    nSel   = 0
    nTLen  = 0

    nSel = _CmdWindow.dbASCII.lTable.CurSel
    nSel = nSel - 1
    
    IF _CmdWindow.dbASCII.e1.nLen < kMaxStrLen
        DO CASE
            CASE nSel = kNULL
                RETURN
            CASE nSel = kSpace
                _CmdWindow.dbASCII.e1.nLen = _CmdWindow.dbASCII.e1.nLen + 1
            OTHERWISE
                cValue = RTRIM(_CmdWindow.dbASCII.e1.Value) + ""
                nTLen = LEN(m->cValue)
                DO WHILE m->nTLen < _CmdWindow.dbASCII.e1.nLen
                    cValue = m->cValue + " "
                    nTLen = LEN(m->cValue)
                ENDDO
                cValue = m->cValue + CHR(m->nSel)
                _CmdWindow.dbASCII.e1.nLen = _CmdWindow.dbASCII.e1.nLen + 1   
                cValue = m->cValue + SPACE(kMaxStrLen - LEN(m->cValue))
                _CmdWindow.dbASCII.e1.Value = m->cValue
        ENDCASE
    ENDIF
RETURN
 

*........................................................
* Procedure Name:   CopyChar
* Parameters:       None
* Ext Memvars:      None
* Description:      Copies character string to clipboard
*........................................................
PROCEDURE CopyChar
    PRIVATE cValue
        
    cValue = _CmdWindow.dbASCII.e1.Value
    
    cValue = ALLTRIM(m->cValue) + ""
    
    _Clipboard.InsertLine = m->cValue
    _Clipboard.ExtendSelection = .T.
    _Clipboard.Column = 1
    _Clipboard.ExtendSelection = .F.
RETURN


*.............................................................................
* Procedure Name:   ResetLen
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbASCII.e1
* Description:      Resets the value of _CmdWindow.dbASCII.e1.nLen to the current length
*                   of the string in _CmdWindow.dbASCII.e1.Value following a manual 
*                   edit by the user.
*.............................................................................
PROCEDURE ResetLen
    PRIVATE cValue, nTLen
    
    cValue = ""
    nTLen  = 0
    
    cValue = RTRIM(_CmdWindow.dbASCII.e1.Value) + ""
    nTLen  = LEN(m->cValue)
    
    _CmdWindow.dbASCII.e1.nLen  = m->nTLen
    _CmdWindow.dbASCII.e1.Value = m->cValue + SPACE(kMaxStrLen - m->nTLen)
RETURN


*...................................................................
* Procedure Name:   FixLen
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbASCII.e1
* Description:      Fixes the value of _CmdWindow.dbASCII.e1 to the current length
*                   of the string in _CmdWindow.dbASCII.e1.Value.nLen on a manual 
*                   edit by the user.
*.............................................................................
PROCEDURE FixLen
    PRIVATE cValue, nTLen
    
    cValue = ""
    nTLen  = 0
    
    cValue = RTRIM(_CmdWindow.dbASCII.e1.Value) + ""
    nTLen = LEN(m->cValue)
    DO WHILE nTLen < _CmdWindow.dbASCII.e1.nLen
        cValue = m->cValue + " "
        nTLen = LEN(m->cValue)
    ENDDO
    _CmdWindow.dbASCII.e1.Value = m->cValue + SPACE(kMaxStrLen - LEN(m->cValue))
RETURN
        

*.................................................................
* Procedure Name:   SetTalk
* Parameters:       None
* Ext Memvars:      This.lSTalk
* Description:      Saves the value of SET TALK and sets TALK OFF
*.................................................................
PROCEDURE SetTalk
    IF TYPE("_CmdWindow.dbASCII.lSTalk") = "L"
        _CmdWindow.dbASCII.lSTalk = SET("TALK") = "ON"
    ELSE
        dbASCII.lSTalk = SET("TALK") = "ON"            
    ENDIF    
    SET TALK OFF
RETURN


*............................................................................
* Procedure Name:   ResetTalk
* Parameters:       None
* Ext Memvars:      This.lSTalk
* Description:      Resets the value of SET TALK based on the value when the
*                   object got focus
*............................................................................
PROCEDURE ResetTalk
    IF _CmdWindow.dbASCII.lSTalk
        SET TALK ON
    ELSE
        SET TALK OFF
    ENDIF
RETURN


*....................................................
* Procedure Name:   InitCodes
* Parameters:       None
* Ext Memvars:      aCodes[]
* Description:      Initializes character code array
*....................................................
PROCEDURE InitCodes
    PRIVATE i, j, cIntlNull, cIntlSpace

    SET TALK OFF
    
    cIntlNull  = [NUL    0   00]
    cIntlSpace = [SPC   32   20]

    j = 0

    *........................
    * initialize codes array
    *........................
    FOR m->i = 0 TO 255
        j = m->i + 1
        DO CASE                         && Character
            CASE m->i = 0             
                aCodes[m->j] = m->cIntlNull
            CASE i = 32
                aCodes[m->j] = m->cIntlSpace
            OTHERWISE
                aCodes[m->j] = " " + CHR(m->i) + "    " + STR(m->i,3,0) + "   " +;
                    IIF(m->i > 15, Dec2Hex(m->i), "0" + Dec2Hex(m->i))
        ENDCASE
    ENDFOR
RETURN


*...................................
* Procedure Name:   FileExit
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbASCII
* Description:      Release _CmdWindow.dbASCII
*...................................
PROCEDURE FileExit
    PRIVATE lVoid
    
    lVoid = _CmdWindow.dbASCII.Close()
    lVoid = _CmdWindow.dbASCII.Release()
    _CmdWindow.dbASCII = .F.
    RELEASE dbASCII
RETURN


*...............................................................
* Procedure Name:   FixSize
* Parameters:       None
* Ext. Memvars:     _CmdWindow.dbASCII
* Description:      Adjusts all objects in _CmdWindow.dbASCII when resized
*...............................................................
PROCEDURE FixSize
    PRIVATE nHeight, nWidth, nTWidth, nLeft
    
    SET TALK OFF
    
    IF _CmdWindow.dbASCII.WindowState # 1

        nWidth  = 0     && form height
        nTWidth = 0     && list box width
        nLeft   = 0     && list box left

        * make sure the form was not made too small
        IF _CmdWindow.dbASCII.Height < kMinHeight
            _CmdWindow.dbASCII.Height = kMinHeight
        ENDIF
    
        IF _CmdWindow.dbASCII.Width < kMinWidth
            _CmdWindow.dbASCII.Width = kMinWidth
        ENDIF
    
        * make sure the form was not made too wide
        IF _CmdWindow.dbASCII.Width > kMaxWidth
            _CmdWindow.dbASCII.Width = kMaxWidth
        ENDIF        
    
        * save the new height and width
        nHeight = _CmdWindow.dbASCII.Height
        nWidth  = _CmdWindow.dbASCII.Width

        * adjust the button
        _CmdWindow.dbASCII.bAdd.Top  = m->nHeight - (8 - kTop)
        _CmdWindow.dbASCII.bAdd.Left = INT((m->nWidth / 2) - 6)
    
        * adjust the entry field
        _CmdWindow.dbASCII.e1.Top   = m->nHeight - (6 - kTop)
        _CmdWindow.dbASCII.e1.Width = m->nWidth - 6
    
        * adjust the list box
        _CmdWindow.dbASCII.lTable.Height = m->nHeight - 10

        DO CASE
            CASE m->nWidth < ((kMinWidth * 2) - 6)
                nTWidth                             =  kListWidth
                _CmdWindow.dbASCII.lTable.Width     =  m->nTWidth
                _CmdWindow.dbASCII.lTable.Column    =  1
                _CmdWindow.dbASCII.dbTitle2.Visible = .F.
                _CmdWindow.dbASCII.dbTitle3.Visible = .F.
                _CmdWindow.dbASCII.dbTitle4.Visible = .F.
            CASE (m->nWidth >= ((kMinWidth * 2) -  6)) .AND.; 
                 (m->nWidth <  ((kMinWidth * 3) - 11))        
                nTWidth                             = (kListWidth * 2) + 2
                _CmdWindow.dbASCII.lTable.Width     =  m->nTWidth
                _CmdWindow.dbASCII.lTable.Column    =  2
                _CmdWindow.dbASCII.dbTitle2.Visible = .T.
                _CmdWindow.dbASCII.dbTitle3.Visible = .F.
            CASE (m->nWidth >= ((kMinWidth * 3) - 11)) .AND. (m->nWidth < kMaxWidth)
                nTWidth                             = (kListWidth * 3) + 4
                _CmdWindow.dbASCII.lTable.Width     =  m->nTWidth
                _CmdWindow.dbASCII.lTable.Column    =  3
                _CmdWindow.dbASCII.dbTitle3.Visible = .T.
                _CmdWindow.dbASCII.dbTitle4.Visible = .F.
            CASE nWidth = kMaxWidth
                nTWidth                             = (kListWidth * 4) + 6
                _CmdWindow.dbASCII.lTable.Width     =  m->nTWidth
                _CmdWindow.dbASCII.lTable.Column    =  4
                _CmdWindow.dbASCII.dbTitle2.Visible = .T.
                _CmdWindow.dbASCII.dbTitle3.Visible = .T.
                _CmdWindow.dbASCII.dbTitle4.Visible = .T.
        ENDCASE        
    
        * get the left coordinate for the text
        nLeft = INT((m->nWidth / 2) - (m->nTWidth / 2) - 1)
        _CmdWindow.dbASCII.lTable.Left = m->nLeft

        * adjust the title text
        _CmdWindow.dbASCII.dbTitle1.Left = m->nLeft

        IF _CmdWindow.dbASCII.dbTitle2.Visible
            _CmdWindow.dbASCII.dbTitle2.Left = m->nLeft + 17
        ELSE
            _CmdWindow.dbASCII.dbTitle2.Left = 0
        ENDIF
    
        IF _CmdWindow.dbASCII.dbTitle3.Visible            
            _CmdWindow.dbASCII.dbTitle3.Left = m->nLeft + 34
        ELSE
            _CmdWindow.dbASCII.dbTitle3.Left = 0
        ENDIF
    
        IF _CmdWindow.dbASCII.dbTitle4.Visible        
            _CmdWindow.dbASCII.dbTitle4.Left = m->nLeft + 51
        ELSE
            _CmdWindow.dbASCII.dbTitle4.Left = 0
        ENDIF        
    
        IF (_CmdWindow.dbASCII.Width = kMinWidth) .AND. (_CmdWindow.dbASCII.Height = kMinHeight)
            _CmdWindow.dbASCII.ASCMenu.mEdit.mMin.Enabled = .F.
        ELSE
            _CmdWindow.dbASCII.ASCMenu.mEdit.mMin.Enabled = .T.
        ENDIF            

        IF (_CmdWindow.dbASCII.Width = kMaxWidth) .AND. (_CmdWindow.dbASCII.Height >= GetMaxHgt())
            _CmdWindow.dbASCII.ASCMenu.mEdit.mMax.Enabled = .F.
        ELSE
            _CmdWindow.dbASCII.ASCMenu.mEdit.mMax.Enabled = .T.
        ENDIF            
    ENDIF
RETURN


*...............................................................
* Procedure Name:   ASCMax
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbASCII
* Description:      Sets ASCII chart to maximum size for screen
*...............................................................
PROCEDURE ASCMax
    _CmdWindow.dbASCII.Height = GetMaxHgt()
    _CmdWindow.dbASCII.Top    = 0

    _CmdWindow.dbASCII.Width  = kMaxWidth

    IF _CmdWindow.dbASCII.Left > 6
        _CmdWindow.dbASCII.Left = 6
    ENDIF

    IF _CmdWindow.dbASCII.Left < 0
        _CmdWindow.dbASCII.Left = 0
    ENDIF
        
    DO FixSize

    _CmdWindow.dbASCII.dbTitle2.Visible = .T.
    _CmdWindow.dbASCII.dbTitle3.Visible = .T.
RETURN


*....................................................
* Procedure Name:   ASCMin
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbASCII
* Description:      Sets ASCII chart to minimum size
*....................................................
PROCEDURE ASCMin
    PRIVATE nMaxHgt
    
    nMaxHgt = GetMaxHgt()
    
    _CmdWindow.dbASCII.Width  = kMinWidth
    _CmdWindow.dbASCII.Height = kMinHeight

    IF _CmdWindow.dbASCII.Left > 56
        _CmdWindow.dbASCII.Left = 56
    ENDIF
    
    IF _CmdWindow.dbASCII.Left < 0
        _CmdWindow.dbASCII.Left = 0
    ENDIF    
    
    IF _CmdWindow.dbASCII.Top > (m->nMaxHgt - kMinHeight)
        _CmdWindow.dbASCII.Top = m->nMaxHgt - kMinHeight
    ENDIF

    DO FixSize

    _CmdWindow.dbASCII.dbTitle3.Visible = .F.
    _CmdWindow.dbASCII.dbTitle4.Visible = .F.
RETURN


*............................................................................
* Function Name:    GetMaxHgt()
* Parameters:       None
* Ext Memvars:      None
* Return Value:     numeric, maximum form height for screen
* Description:      compute the maximum form height for a form with a top
*                   of 0.  The current number of lines on the screen and the
*                   setting of SET STATUS are taken into account.
*............................................................................
FUNCTION GetMaxHgt
    PRIVATE nLines
        
    * get the number of lines by looking at the display mode
    nLines = VAL(RIGHT(RTRIM(SET("DISPLAY")), 2))
    
    IF m->nLines = 0       && if no number in display mode
        nLines = 25
    ENDIF
        
    IF SET("STATUS") = "ON"
        nLines = m->nLines - 5     && put form 2 lines above status
    ELSE                        && no status line
        nLines = m->nLines - 3     && put form 2 lines above bottom
    ENDIF
RETURN m->nLines            
    
*...............................................................
* Procedure Name:   AHAbout
* Parameters:       None
* Ext Memvars:      None
* Description:      Displays an "About" box for the ASCII chart
*...............................................................
PROCEDURE AHAbout
    PRIVATE lVoid
    
    lVoid = .T.

    #include "AHABOUT.DFM"
    
    lVoid = AHAbout.ReadModal()
    
    lVoid = AHAbout.Release()
    RELEASE AHAbout
RETURN


PROCEDURE HUsing
RETURN    


*..........................................
* Procedure Name:   PrAbout
* Parameters:       None
* Ext Memvars:      HAbout
* Description:      Closes the form HAbout
*..........................................
PROCEDURE PrAbout
    PRIVATE lVoid
    
    lVoid = AHAbout.Close()
RETURN    


*......................................................................
* Procedure Name:   IDEHelp
* Parameters:       None
* Ext Memvars:      None
* Description:      Calls the help system with current object's HelpID
*......................................................................
PROCEDURE IDEHelp
    PRIVATE lVoid
    
    _SysHelp.HelpID = This.HelpID
    lVoid = _SysHelp.ReadModal()
RETURN    


*.....................................................................
* The following functions are from the dUFLP library maintained by
* Ken Mayer of Team Borland.  These functions are in the public 
* domain.  The library may be downloaded from the Borland dBASE Forum
* on CompuServe.
*.....................................................................

       
FUNCTION Dec2Hex
*-----------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 72662,1302)
*-- Date........: 03/01/1992
*-- Notes.......: Converts an unsigned integer ( in decimal notation)
*--               to a hexadecimal string
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 03/01/1992
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Dec2Hex(<nDecimal>)
*-- Example.....: ? Dec2Hex( 118 )
*-- Returns.....: Character = Hexadecimal equivalent ( "F6" in example )
*-- Parameters..: nDecimal = number to convert
*-----------------------------------------------------------------------
   
   parameters nDecimal
   private nD, cH

   m->nD = int( m->nDecimal )
   m->cH= ""
   do while m->nD > 0
     m->cH = substr( "0123456789ABCDEF", mod( m->nD, 16 ) + 1 , 1 );
                          + m->cH
     m->nD = int( m->nD / 16 )
   enddo
   
RETURN iif( "" = m->cH, "0", m->cH )
*-- Eof: Dec2Hex()

