/* gdemo.c - Graphics demo program */

/************************************************************************/
/*	Copyright (C) 1986-1993 Phar Lap Software, Inc.			*/
/*	Unpublished - rights reserved under the Copyright Laws of the	*/
/*	United States.  Use, duplication, or disclosure by the 		*/
/*	Government is subject to restrictions as set forth in 		*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
/*	Computer Software clause at 252.227-7013.			*/
/*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <bgi32.h>


/*
 * Prototypes for routines in this file
 */

int randline(void);
short randx(void);
short randy(void);
void _gbuffmode(int);


/*

Global variables

*/

int MaxX;
int MaxY;


/*

main - Main routine

*/

int main()

{

	int GraphDriver;     	/* The Graphics device driver */
	int GraphMode;		/* The Graphics mode value */
	int ErrorCode;		/* Reports any graphics errors */
	int btime;		/* Execution time for buffered mode */
	int ubtime;		/* Execution time for unbuffered mode */

	/* Initialize the BGI graphics library */

  	GraphDriver = DETECT; 	    
  	initgraph( &GraphDriver, &GraphMode, "" );
  	ErrorCode = graphresult(); 
  	if(ErrorCode != grOk)
	{
    		printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
	    	return 1;
	}
  	MaxX = getmaxx();
  	MaxY = getmaxy();

	/* Run the demo first in buffered mode if protected mode */

	_gbuffmode(1);
	btime = randline();
	
	/* Run the demo again in unbuffered mode */

	_gbuffmode(0);
	ubtime = randline();

	/* Switch back to text mode */

	closegraph(); 	

	/* Print out the buffered and unbuffered execution times */

	printf("\n\n");
	printf("Buffered mode execution time = %i milliseconds.\n",
	       btime);
	printf("Unbuffered mode execution time = %i milliseconds.\n",
	       ubtime);

	/* Exit back to DOS */

	return 0;	

}


/*

randline - Random line demo

*/

int randline(void)
{
	int i;		/* Loop counter */
	clock_t stime;	/* Start type */
	clock_t etime;	/* End time */

	/* Reseed the random number generator to a constant 100 so that
	   we always generate the same random lines. */

	srand(100);

	/* Start the clock */

	stime = clock();

	/* The demo code clears the screen and randomly draws 1000 lines 
	   in random colors */

	cleardevice();
	for(i = 0; i < 1000; ++i)
	{
		setcolor((short) (rand() % 4));
		moveto(randx(), randy());
		lineto(randx(), randy());
	}

	/* Stop the clock */

	etime = clock();

	/* Return withe the elapse execution time in milliseconds */

	return (int)((1000L * (etime - stime)) / CLOCKS_PER_SEC);

}


/*

randx - Generate a random X coordinate value

*/

short randx(void)
{
	return (short) (rand() % MaxX);
}


/*

randy - Generate a random Y coordinate value

*/

short randy(void)
{
	return (short) (rand() % MaxY);
}
