#include "gfm.ch"
#include "setcurs.ch"

*******************
*******************
**
**  Purpose:  Provide a pop-up menu for the GrumpFish utilities
**
**   Syntax:  GFMUtils( <cProc>, <nLine>, <cVariable> )
**
**   Parameters:
**
**      Name        Description
**       
**      cProc       Calling procedure (ignored - from hot key)
**      nLine       Calling procedure line (ignored - from hot key)
**      nVariable   Calling procedure var (ignored - from hot key)
**
**  Returns:  .t.
**
**  Example:  set key -39 to GFMutils  && Set Alt-Keys
**
**    Files:  None.
**
** Overview:  Provides a menu of the GrumpFish product line utility functions
**
**    Notes:  popphone()
**            popcalc()
**            popdate()
**            popstop()
**            popnote() 
**                      "A"     ""                           "*.EXE"   
**            b_backup( <cDisk>, <cPath to start backup from>, <cTargets>,
**                      <lAutocheck>, <cUdf> )
**            b_restore( <cDisk>, <cPath to start backup from>, <cTargets>, 
**                      <lAutocheck>, <cUdf> 
**
**
** Category:  Menu Handling
**
** See Also:  
**
*******************
*******************
FUNCTION GFMUtils( cProc, nLine, nVariable )
	LOCAL aSets := SetAll()
   LOCAL nR1 := -1, nC1 := -1, nR2 := -1, nC2 := -1
   LOCAL _GFMbyte := 0, nResult := 1, nCursor := SetCursor( SC_NORMAL )
   LOCAL cTitle := GFMSet( _GFM_SYSTEM ) + " Utilities"
	LOCAL cFooter := "Press [Esc] to return"
   
   LOCAL GFMFuncs := {	"PopDate()", ;
								"PopCalc()", ;
								"GrumpCalc()", ;
                      	"PopNote()", ;
								"PopPhone()", ;
								"PopStop()" }
   
   LOCAL aPrompts := { "Appointments/Calendar", "Calculator", ;
                     "GrumpFish Spreadsheet", "Notepad", "Phone directory", ;
							"Stop Watch" }
   
   LOCAL aMessages := { '"The GrumpFish Library Pop-up Appointment Calendar"', ;
                        '"The GrumpFish Library Pop-up Calculator"', ;
                        '"The GrumpFish Spreadsheet"', ;
                        '"The GrumpFish Library Pop-up Notepad"', ;
                        '"The GrumpFish Library Pop-up Phone Directory/Dialer"', ;
                        '"The GrumpFish Library Internal Stop-Watch"' }
   
   nR1 := nC1 := nR2 := nC2 := -1
   w_Scale( Len( aPrompts ) + 2, w_TextDim( aPrompts[ 1 ], cTitle, cFooter ), ;
           @nR1, @nC1, @nR2, @nC2 )
   
   DO WHILE ( nResult := GFMenu( aPrompts, aMessages, 'E', cTitle, cFooter, ;
               nR1, nC1, nR2, nC2, nResult, .t., .f., .t., frame(2) ) ) # 0
		w_Pop()
		Invoke( GFMFuncs[ nResult ], aPrompts[ nResult ] )
   
   ENDDO
	w_Pop()

   IF cProc $ 'GFMAIN#M_123#GFMENU#ACHOICE'
     SetCursor( SC_NONE )
   ELSE
     SetCursor( nCursor )
   ENDIF
	SetAll( aSets )
RETURN .T.

STATIC PROCEDURE Invoke( cMacro, cPrompt ) // Test macro before invoking it.
	IF Type( cMacro ) $ 'U,UE'
		Alert( cPrompt +';is not available' )
	ELSE
		cMacro := &( cMacro )
	ENDIF
RETURN

#include "Set.ch"
STATIC FUNCTION SetAll( aNewSets )
	LOCAL aCurrentSets[_SET_COUNT], nCurrent
	IF ( aNewSets != NIL )           // Set new and return current
		FOR nCurrent := 1 TO _SET_COUNT
			aCurrentSets[nCurrent] := SET(nCurrent, aNewSets[nCurrent])
		NEXT
	ELSE                             // Just return current
		FOR nCurrent := 1 TO _SET_COUNT
			aCurrentSets[nCurrent] := SET(nCurrent)
		NEXT
	ENDIF
RETURN (aCurrentSets)
