#include "gfm.ch"
#include "inkey.ch"
#include "fileio.ch"

#define MIN_ROWS		1
#define MIN_COLS		3
#define SIZE_FRAME	"-|-|"

STATIC aSizeStack := {}

FUNCTION GFMSizeStack( aNewStack )
	IF aNewStack # NIL THEN aSizeStack := aNewStack
RETURN aSizeStack

FUNCTION GFMSize( nOption, nTr, nLc, nBr, nRc )
	LOCAL nTop, nLeft, nBottom, nRight
	LOCAL lReSized := .F.
	IF GFMSet( _GFM_RESIZE, .F. )
		nTop		:= nTr
		nLeft		:= nLc
		nBottom	:= nBr
		nRight	:= nRc
		IF ReSizeBox( @nTop, @nLeft, @nBottom, @nRight, MIN_ROWS, MIN_COLS  )
			IF GFMSet( _GFM_LEVEL ) == 0
				IF GFMSet( _GFM_STYLE ) $ 'SNP' .AND. ;
					( GFMSet( _GFM_TOPLINE ) # nTop .OR. ;
					GFMSet( _GFM_LEFTCOL ) # nLeft .OR. ;
					GFMSet( _GFM_RIGHTCOL ) # nRight )
					GFMDeStabilize() // Pull-down style & top level has been moved
				ENDIF
				GFMSet( _GFM_TOPLINE, nTop )
				GFMSet( _GFM_LEFTCOL, nLeft )
				GFMSet( _GFM_RIGHTCOL, nRight )
			ELSE
				GFMSizePut( GFMSet( _GFM_BYTE ), nTop, nLeft, nBottom, nRight )
			ENDIF
			lReSized	:= .T.
			w_Pop()
			nOption	:= -1
			nTr		:= nTop
			nLc		:= nLeft
			nBr		:= nBottom
			nRc		:= nRight
		ENDIF
	ENDIF
RETURN lReSized

FUNCTION GFMSizePut( nMenu, nTop, nLeft, nBottom, nRight )
	LOCAL nPos := aScan( aSizeStack, { | a | nMenu = MenuSizeNumber( a ) } )
	IF nPos == 0
		aAdd( aSizeStack, { nMenu, nTop, nLeft, nBottom, nRight } )
	ELSE
		aSizeStack[ nPos ] := { nMenu, nTop, nLeft, nBottom, nRight }
	ENDIF
RETURN aSizeStack

FUNCTION GFMSizeGet( nMenu )
	LOCAL nPos := aScan( aSizeStack, { | a | nMenu = MenuSizeNumber( a ) } )
RETURN IIF( nPos # 0, aSizeStack[ nPos ], {} )

#define MENU_OFFSET		3
#define TOP_OFFSET		6
#define LEFT_OFFSET		9
#define BOTTOM_OFFSET	12
#define RIGHT_OFFSET		15
#define MENU_TOKEN		"#:"
#xtrans MenuValue( <c>, <n> ) => Val( SubStr( <c>, <n>, 3 ) )
#xtrans MenuString( <n> ) 		=> Str( <n>, 3, 0 )

FUNCTION GFMSizeString( aMenuSize )
RETURN MENU_TOKEN + MenuString( MenuSizeNumber( aMenuSize ) ) ;
						+ MenuString( MenuSizeTop( aMenuSize ) ) ;
						+ MenuString( MenuSizeLeft( aMenuSize ) ) ;
						+ MenuString( MenuSizeBottom( aMenuSize ) ) ;
						+ MenuString( MenuSizeRight( aMenuSize ) )


FUNCTION GFMSizeRead( cFileName )
	LOCAL nMenu, nTop, nLeft, nBottom, nRight, cLine
	LOCAL nHandle := fOpen( cFileName, FO_READ + FO_SHARED )
	IF nHandle > 0
		aSizeStack := {}
		IF fLocate( nHandle, MENU_TOKEN, "N" ) > -1
			DO WHILE At( MENU_TOKEN, cLine := fReadLine( nHandle ) ) == 1
				nMenu 	:= MenuValue( cLine, MENU_OFFSET )
				nTop		:= MenuValue( cLine, TOP_OFFSET )
				nLeft		:= MenuValue( cLine, LEFT_OFFSET )
				nBottom	:= MenuValue( cLine, BOTTOM_OFFSET )
				nRight	:= MenuValue( cLine, RIGHT_OFFSET )
				GFMSizePut( nMenu, nTop, nLeft, nBottom, nRight )
			ENDDO
		ENDIF
		fClose( nHandle )
	ENDIF
RETURN aSizeStack

#xtrans DoKey( <a> )		=> (<a>)\[1]
#xtrans DoBlock( <a> )	=> (<a>)\[2]

FUNCTION ReSizeBox( nTop, nLeft, nBottom, nRight, nMinRows, nMinCols )
	LOCAL aCoords := { nTop, nLeft, nBottom, nRight }
	LOCAL aSizing := { ;
		{ K_UP,		{|n| nTop -= n } }, ;
		{ K_DOWN,	{|n| nBottom += n } }, ;
		{ K_LEFT,	{|n| nLeft -= n } }, ;
		{ K_RIGHT,	{|n| nRight += n } }, ;
		{ K_HOME,	{|n| nTop -= n, nLeft -= n } }, ;
		{ K_END,		{|n| nBottom += n, nLeft += n } }, ;
		{ K_PGUP,	{|n| nTop -= n, nRight += n } }, ;
		{ K_PGDN,	{|n| nBottom += n, nRight += n } }, ;
		{ Asc('8'), {|n| nBottom -= n } }, ;
		{ Asc('2'), {|n| nTop += n } }, ;
		{ Asc('4'),	{|n| nRight -= n } }, ;
		{ Asc('6'), {|n| nLeft += n } }, ;
		{ Asc('7'), {|n| nTop += n, nLeft += n } }, ;
		{ Asc('1'), {|n| nBottom -= n, nLeft += n } }, ;
		{ Asc('9'), {|n| nTop += n, nRight -= n } }, ;
		{ Asc('3'), {|n| nBottom -= n, nRight -= n } } }
	LOCAL aMoving := { ;
		{ K_UP,		{|n| nTop -= n, nBottom -= n } }, ;
		{ K_DOWN,	{|n| nTop += n, nBottom += n } }, ;
		{ K_LEFT,	{|n| nLeft -= n, nRight -= n } }, ;
		{ K_RIGHT,	{|n| nRight += n, nLeft += n } }, ;
		{ K_HOME,	{|n| nTop -= n, nLeft -= n, nBottom -= n, nRight -= n } }, ;
		{ K_END,		{|n| nTop += n, nLeft -= n, nBottom += n, nRight -= n } }, ;
		{ K_PGUP,	{|n| nTop -= n, nLeft += n, nBottom -= n, nRight += n } }, ;
		{ K_PGDN,	{|n| nTop += n, nLeft += n, nBottom += n, nRight += n } }, ;
		{ Asc('8'), {|n| nBottom := nBottom - nTop, nTop := 0 } } , ;
		{ Asc('2'), {|n| nTop := MaxRow() - ( nBottom - nTop ), ;
								nBottom := MaxRow() } }, ;
		{ Asc('4'),	{|n| nRight := nRight - nLeft, nLeft := 0 } }, ;
		{ Asc('6'),	{|n| nLeft := MaxCol() - ( nRight - nLeft ), ;
								nRight := MaxCol() } }, ;
		{ Asc('7'),	{|n| nBottom := nBottom - nTop, nTop := 0, ;
								nRight := nRight - nLeft, nLeft := 0 } }, ;
		{ Asc('1'),	{|n| nTop := MaxRow() - ( nBottom - nTop ), ;
								nBottom := MaxRow(), ;
								nRight := nRight - nLeft, nLeft := 0 } }, ;
		{ Asc('9'),	{|n| nBottom := nBottom - nTop, nTop := 0, ;
								nLeft := MaxCol() - ( nRight - nLeft ), ;
								nRight := MaxCol() } }, ;
		{ Asc('3'),	{|n| nTop := MaxRow() - ( nBottom - nTop ), ;
								nBottom := MaxRow(), ;
								nLeft := MaxCol() - ( nRight - nLeft ), ;
								nRight := MaxCol() } }, ;
		{ Asc('5'),	{|n| n := nBottom - nTop, nTop := MaxRow()/2 - n/2, ;
								nBottom := nTop + n, ;
								n := nRight - nLeft, nLeft := MaxCol()/2 - n/2, ;
								nRight := nLeft + n } } }
	LOCAL nOption, bKeyBlock, nKey, lMoving, cScreen

	DEFAULT nMinRows TO MIN_ROWS, nMinCols TO MIN_COLS

	CLEAR TYPEAHEAD
	REPEAT

		cScreen := SaveScreen( nTop, nLeft, nBottom, nRight )
		DispBegin()
		@ nTop, nLeft, nBottom, nRight BOX SIZE_FRAME
		DispEnd()
		nKey := GFMGetKey(0)
		DispBegin()
		RestScreen( nTop, nLeft, nBottom, nRight, cScreen )
		DispEnd()
		bKeyBlock := {||.T.}
		IF ( lMoving := KeyTest('S') )
			IF ( nOption := aScan( aMoving, { |a| DoKey( a ) == nKey } ) ) > 0
				bKeyBlock := DoBlock( aMoving[ nOption ] )
			ENDIF
		ELSE
			IF ( nOption := aScan( aSizing, { |a| DoKey( a ) == nKey } ) ) > 0
				bKeyBlock := DoBlock( aSizing[ nOption ] )
			ENDIF
		ENDIF
		Eval( bKeyBlock, 1 )
		IF ( !lMoving .AND. ( nBottom - nTop + 1 < nMinRows .OR. ;
			nRight - nLeft + 1 < nMinCols ) ) .OR. ;
			( lMoving .AND. ( nTop < 0 .OR. nLeft < 0 .OR. nBottom > MaxRow() ;
				.OR. nRight > MaxCol() ) )
			Eval( bKeyBlock, -1 )
		ENDIF
		IF nTop < 0 THEN nTop := 0
		IF nLeft < 0 THEN nLeft := 0
		IF nBottom > MaxRow() THEN nBottom := MaxRow()
		IF nRight > MaxCol() THEN nRight := MaxCol()

	UNTIL nKey == K_ESC .OR. nKey == K_ENTER

	KeyToggle('S','N')	// Turn ScrollLock off
	IF LastKey() == K_ESC
		nTop		:= aCoords[1]
		nLeft		:= aCoords[2]
		nBottom	:= aCoords[3]
		nRight	:= aCoords[4]
	ENDIF

RETURN LastKey() # K_ESC
