#include "gfm.ch"
#include "error.ch"

STATIC aBlocks

//////////////////////
//////////////////////
//
//	Purpose:
//		Prototype error recovery function for GrumpMenu
//
//	Syntax:
//		GFMPrototype( <e> )
//
//	Formal Arguments: (1)
//		Name       	Description
//			
//		e         	Error Block
//
//	Examples:
//		
//
//	Files:
//		None.
//
//	Description:
//		This function will check to see if the function called
//		has been linked into the application.  If it hasn't, it
//		will display an error message.  Otherwise, it will macro
//		execute it.
//
//	Notes:
//		
//
//	Category:
//		Menu Handling
//
//	See Also:
//
//
//	Include files:
//		gfm.ch
//		error.ch
//
//	Revisions:
//		06/06/91	07:24:56	1.0	Original version
//
//////////////////////
//////////////////////
PROCEDURE GFMPrototype( e )
	LOCAL nMaxRow 	:= MaxRow(), nMaxCol := MaxCol(), lBlink := SetBlink()
	LOCAL cMessage 
	IF e:genCode == EG_NOFUNC
		cMessage := "GrumpFish Menu Error Scavenger;This routine is missing;" ;
						+ e:operation + ';' + e:description + ':' + e:subSystem
		Alert( cMessage )
	ELSE
		EVal( aBlocks[1], e )
	ENDIF
	SetMode( nMaxRow, nMaxCol )
	SetBlink( lBlink )
RETURN

FUNCTION GFMErrorPush( bError )
	DEFAULT aBlocks TO { ErrorBlock() }
	aAdd( aBlocks, ErrorBlock( bError ) )
RETURN aTail( aBlocks )

FUNCTION GFMErrorPop()
	LOCAL bError := aTail( aBlocks )
	aBlocks := aSize( aBlocks, Len( aBlocks ) - 1 )
	ErrorBlock( bError )	// Restore error block
RETURN bError

FUNCTION GFMErrorBlock()
	DEFAULT aBlocks TO { ErrorBlock() }
RETURN aTail( aBlocks )	
